/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logisticspipes;

import buildcraft.transport.TileGenericPipe;
import java.util.LinkedList;
import logisticspipes.logisticspipes.IAdjacentWorldAccess;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.ITrackStatistics;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.RoutedEntityItem;
import logisticspipes.utils.AdjacentTile;
import net.minecraftforge.common.ForgeDirection;

public class PipeTransportLayer
extends TransportLayer {
    private final IAdjacentWorldAccess _worldAccess;
    private final ITrackStatistics _trackStatistics;
    private final IRouter _router;

    public PipeTransportLayer(IAdjacentWorldAccess worldAccess, ITrackStatistics trackStatistics, IRouter router) {
        this._worldAccess = worldAccess;
        this._trackStatistics = trackStatistics;
        this._router = router;
    }

    @Override
    public ForgeDirection itemArrived(IRoutedItem item, ForgeDirection denyed) {
        CoreRoutedPipe pipe;
        if (item.getItemStack() != null) {
            this._trackStatistics.recievedItem(item.getItemStack().a);
        }
        item.setArrived(true);
        this._router.inboundItemArrived((RoutedEntityItem)item);
        LinkedList adjacentEntities = this._worldAccess.getConnectedEntities();
        LinkedList<ForgeDirection> possibleForgeDirection = new LinkedList<ForgeDirection>();
        for (AdjacentTile tile : adjacentEntities) {
            if (tile.tile instanceof TileGenericPipe || denyed != null && denyed.equals((Object)tile.orientation) || (pipe = this._router.getPipe()) != null && pipe.isLockedExit(tile.orientation)) continue;
            possibleForgeDirection.add(tile.orientation);
        }
        if (possibleForgeDirection.size() != 0) {
            return (ForgeDirection)possibleForgeDirection.get(this._worldAccess.getRandomInt(possibleForgeDirection.size()));
        }
        for (AdjacentTile tile : adjacentEntities) {
            if (this._router.isRoutedExit(tile.orientation) || (pipe = this._router.getPipe()) != null && pipe.isLockedExit(tile.orientation)) continue;
            possibleForgeDirection.add(tile.orientation);
        }
        if (possibleForgeDirection.size() == 0) {
            return null;
        }
        return (ForgeDirection)possibleForgeDirection.get(this._worldAccess.getRandomInt(possibleForgeDirection.size()));
    }

    @Override
    public boolean stillWantItem(IRoutedItem item) {
        return true;
    }
}

