/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.ArrayList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;

public class ModuleApiaristAnalyser
implements ILogisticsModule {
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private int ticksToAction = 100;
    private int currentTick = 0;
    private IRoutedPowerProvider _power;
    private static final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.APIARIST_Analyser, 0, true, false, 3, 0);

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier itemID, int bestPriority, int bestCustomPriority) {
        if (bestPriority > ModuleApiaristAnalyser._sinkReply.fixedPriority.ordinal() || bestPriority == ModuleApiaristAnalyser._sinkReply.fixedPriority.ordinal() && bestCustomPriority >= ModuleApiaristAnalyser._sinkReply.customPriority) {
            return null;
        }
        ur item = itemID.makeNormalStack(1);
        if (SimpleServiceLocator.forestryProxy.isBee(item) && !SimpleServiceLocator.forestryProxy.isAnalysedBee(item) && this._power.canUseEnergy(3)) {
            return _sinkReply;
        }
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction) {
            return;
        }
        this.currentTick = 0;
        la inv = this._invProvider.getRawInventory();
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.k_(); ++i) {
            Pair3 reply;
            ur item = inv.a(i);
            if (!SimpleServiceLocator.forestryProxy.isBee(item) || !SimpleServiceLocator.forestryProxy.isAnalysedBee(item) || (reply = this._itemSender.hasDestination(ItemIdentifier.get(item), true, new ArrayList())) == null || !this._power.useEnergy(6)) continue;
            this._itemSender.sendStack(inv.a(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
        }
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

