/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;

public class ModuleElectricBuffer
implements ILogisticsModule {
    private IInventoryProvider _invProvider;
    private IRoutedPowerProvider _power;
    private ISendRoutedItem _itemSender;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private IWorldProvider _world;
    private int currentTickCount = 0;
    private int ticksToAction = 80;
    private final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ElectricNetwork, 0, true, false, 1, 0);

    @Override
    public void readFromNBT(bq nbttagcompound) {
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerProvider) {
        this._invProvider = invProvider;
        this._power = powerProvider;
        this._world = world;
        this._itemSender = itemSender;
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier stack, int bestPriority, int bestCustomPriority) {
        if (bestPriority >= SinkReply.FixedPriority.ElectricNetwork.ordinal()) {
            return null;
        }
        if (SimpleServiceLocator.IC2Proxy.isElectricItem(stack.makeNormalStack(1)) && this._power.canUseEnergy(1)) {
            return this._sinkReply;
        }
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (++this.currentTickCount < this.ticksToAction) {
            return;
        }
        this.currentTickCount = 0;
        la inv = this._invProvider.getPointedInventory();
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.k_(); ++i) {
            Pair3 reply;
            ur stack = inv.a(i);
            if (stack == null || !SimpleServiceLocator.IC2Proxy.isElectricItem(stack) || (reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._itemSender.getSourceID(), true, SinkReply.FixedPriority.ElectricNetwork)) == null) continue;
            MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this._world.getWorld(), 2);
            this._itemSender.sendStack(inv.a(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            return;
        }
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return true;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

