/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.gui.hud.modules.HUDElectricManager;
import logisticspipes.interfaces.IClientInformationProvider;
import logisticspipes.interfaces.IHUDModuleHandler;
import logisticspipes.interfaces.IHUDModuleRenderer;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IModuleInventoryReceive;
import logisticspipes.interfaces.IModuleWatchReciver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.network.packets.PacketModuleInteger;
import logisticspipes.network.packets.PacketModuleInvContent;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;

public class ModuleElectricManager
implements ILogisticsGuiModule,
IClientInformationProvider,
IHUDModuleHandler,
IModuleWatchReciver,
ISimpleInventoryEventHandler,
IModuleInventoryReceive {
    private final SimpleInventory _filterInventory = new SimpleInventory(9, "Electric Items", 1);
    private boolean _dischargeMode;
    protected IInventoryProvider _invProvider;
    protected ISendRoutedItem _itemSender;
    protected IRoutedPowerProvider _power;
    private int ticksToAction = 100;
    private int currentTick = 0;
    private int slot = 0;
    public int xCoord = 0;
    public int yCoord = 0;
    public int zCoord = 0;
    private IWorldProvider _world;
    private IHUDModuleRenderer HUD = new HUDElectricManager(this);
    private final List localModeWatchers = new ArrayList();
    private final SinkReply _sinkReply = new SinkReply(SinkReply.FixedPriority.ElectricNetwork, 0, true, false, 1, 1);

    public ModuleElectricManager() {
        this._filterInventory.addListener(this);
    }

    public la getFilterInventory() {
        return this._filterInventory;
    }

    public boolean isDischargeMode() {
        return this._dischargeMode;
    }

    public void setDischargeMode(boolean isDischargeMode) {
        this._dischargeMode = isDischargeMode;
        MainProxy.sendToPlayerList(new PacketModuleInteger(64, this.xCoord, this.yCoord, this.zCoord, this.slot, this.isDischargeMode() ? 1 : 0).getPacket(), this.localModeWatchers);
    }

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier stackID, int bestPriority, int bestCustomPriority) {
        if (bestPriority >= SinkReply.FixedPriority.ElectricNetwork.ordinal()) {
            return null;
        }
        if (!this._power.canUseEnergy(1)) {
            return null;
        }
        ur stack = stackID.makeNormalStack(1);
        if (this.isOfInterest(stack)) {
            if (this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyCharged(stack)) {
                return this._sinkReply;
            }
            if (!this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyDischarged(stack)) {
                return this._sinkReply;
            }
            if (SimpleServiceLocator.IC2Proxy.isPartiallyCharged(stack)) {
                return this._sinkReply;
            }
        }
        return null;
    }

    @Override
    public int getGuiHandlerID() {
        return 40;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        this._filterInventory.readFromNBT(nbttagcompound, "");
        this.setDischargeMode(nbttagcompound.n("discharge"));
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        this._filterInventory.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("discharge", this.isDischargeMode());
    }

    @Override
    public void tick() {
        if (++this.currentTick < this.ticksToAction) {
            return;
        }
        this.currentTick = 0;
        la inv = this._invProvider.getPointedInventory();
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.k_(); ++i) {
            Pair3 reply;
            ur stack = inv.a(i);
            if (stack == null) {
                return;
            }
            if (!this.isOfInterest(stack)) continue;
            if (this._dischargeMode && SimpleServiceLocator.IC2Proxy.isFullyDischarged(stack)) {
                reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._itemSender.getSourceID(), true, SinkReply.FixedPriority.ElectricNetwork);
                if (reply == null) continue;
                if (this._power.useEnergy(10)) {
                    MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this._world.getWorld(), 2);
                    this._itemSender.sendStack(inv.a(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
                    return;
                }
            }
            if (this._dischargeMode || !SimpleServiceLocator.IC2Proxy.isFullyCharged(stack) || (reply = SimpleServiceLocator.logisticsManager.hasDestinationWithMinPriority(ItemIdentifier.get(stack), this._itemSender.getSourceID(), true, SinkReply.FixedPriority.ElectricNetwork)) == null || !this._power.useEnergy(10)) continue;
            MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this._world.getWorld(), 2);
            this._itemSender.sendStack(inv.a(i, 1), reply, CoreRoutedPipe.ItemSendMode.Normal);
            return;
        }
    }

    private boolean isOfInterest(ur stack) {
        if (!SimpleServiceLocator.IC2Proxy.isElectricItem(stack)) {
            return false;
        }
        String stackName = stack.a();
        for (int i = 0; i < this._filterInventory.k_(); ++i) {
            String fStackName;
            ur fStack = this._filterInventory.a(i);
            if (fStack == null || !stackName.equals(fStackName = fStack.a())) continue;
            return true;
        }
        return false;
    }

    @Override
    public List getClientInformation() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("Mode: " + (this.isDischargeMode() ? "Discharge Items" : "Charge Items"));
        list.add("Supplied: ");
        list.add("<inventory>");
        list.add("<that>");
        return list;
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
        this.slot = slot;
    }

    @Override
    public void startWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void stopWatching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(60, this.xCoord, this.yCoord, this.zCoord, this.slot).getPacket());
    }

    @Override
    public void startWatching(qx player) {
        this.localModeWatchers.add(player);
        MainProxy.sendPacketToPlayer(new PacketModuleInvContent(62, this.xCoord, this.yCoord, this.zCoord, this.slot, ItemIdentifierStack.getListFromInventory(this._filterInventory)).getPacket(), (Player)player);
        MainProxy.sendPacketToPlayer(new PacketModuleInteger(64, this.xCoord, this.yCoord, this.zCoord, this.slot, this.isDischargeMode() ? 1 : 0).getPacket(), (Player)player);
    }

    @Override
    public void stopWatching(qx player) {
        this.localModeWatchers.remove(player);
    }

    @Override
    public IHUDModuleRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(new PacketModuleInvContent(62, this.xCoord, this.yCoord, this.zCoord, this.slot, ItemIdentifierStack.getListFromInventory(inventory)).getPacket(), this.localModeWatchers);
    }

    @Override
    public void handleInvContent(Collection list) {
        this._filterInventory.handleItemIdentifierList(list);
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

