/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.modules;

import java.util.LinkedList;
import java.util.List;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SinkReply;

public class ModuleQuickSort
implements ILogisticsModule {
    private final int stalledDelay = 24;
    private final int normalDelay = 6;
    private int currentTick = 0;
    private boolean stalled;
    private int lastStackLookedAt = 0;
    private int lastSuceededStack = 0;
    private IInventoryProvider _invProvider;
    private ISendRoutedItem _itemSender;
    private IRoutedPowerProvider _power;
    private int xCoord;
    private int yCoord;
    private int zCoord;
    private IWorldProvider _world;

    @Override
    public void registerHandler(IInventoryProvider invProvider, ISendRoutedItem itemSender, IWorldProvider world, IRoutedPowerProvider powerprovider) {
        this._invProvider = invProvider;
        this._itemSender = itemSender;
        this._power = powerprovider;
        this._world = world;
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
    }

    @Override
    public SinkReply sinksItem(ItemIdentifier item, int bestPriority, int bestCustomPriority) {
        return null;
    }

    @Override
    public ILogisticsModule getSubModule(int slot) {
        return null;
    }

    @Override
    public void tick() {
        if (--this.currentTick > 0) {
            return;
        }
        this.currentTick = this.stalled ? 24 : 6;
        la targetInventory = this._invProvider.getPointedInventory();
        if (targetInventory == null) {
            return;
        }
        if (targetInventory.k_() == 0 || !this._power.canUseEnergy(500)) {
            this.stalled = true;
            return;
        }
        if (this.lastSuceededStack >= targetInventory.k_()) {
            this.lastSuceededStack = 0;
        }
        if (this.lastStackLookedAt >= targetInventory.k_()) {
            this.lastStackLookedAt = 0;
        }
        ur slot = targetInventory.a(this.lastStackLookedAt);
        while (slot == null) {
            ++this.lastStackLookedAt;
            if (this.lastStackLookedAt >= targetInventory.k_()) {
                this.lastStackLookedAt = 0;
            }
            slot = targetInventory.a(this.lastStackLookedAt);
            if (this.lastStackLookedAt != this.lastSuceededStack) continue;
            this.stalled = true;
            return;
        }
        LinkedList<Object> jamList = new LinkedList<Object>();
        Pair3 reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), false, jamList);
        if (reply == null) {
            if (this.lastStackLookedAt == this.lastSuceededStack) {
                this.stalled = true;
            }
            ++this.lastStackLookedAt;
            return;
        }
        if (!this._power.useEnergy(500)) {
            this.stalled = true;
            ++this.lastStackLookedAt;
            return;
        }
        this.stalled = false;
        slot = slot.l();
        boolean partialSend = false;
        while (reply != null) {
            int count = slot.a;
            if (((SinkReply)reply.getValue2()).maxNumberOfItems > 0) {
                count = Math.min(count, ((SinkReply)reply.getValue2()).maxNumberOfItems);
            }
            ur stackToSend = slot.a(count);
            this._itemSender.sendStack(stackToSend, reply, CoreRoutedPipe.ItemSendMode.Fast);
            MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this._world.getWorld(), 8);
            if (slot.a == 0 || !SimpleServiceLocator.buildCraftProxy.checkMaxItems()) break;
            jamList.add(reply.getValue1());
            reply = this._itemSender.hasDestination(ItemIdentifier.get(slot), false, jamList);
        }
        if (slot.a > 0) {
            partialSend = true;
            targetInventory.a(this.lastStackLookedAt, slot);
        } else {
            targetInventory.a(this.lastStackLookedAt, null);
        }
        this.lastSuceededStack = this.lastStackLookedAt++;
        if (partialSend) {
            ur tstack;
            if (this.lastStackLookedAt >= targetInventory.k_()) {
                this.lastStackLookedAt = 0;
            }
            while (this.lastStackLookedAt != this.lastSuceededStack && ((tstack = targetInventory.a(this.lastStackLookedAt)) == null || slot.a(tstack))) {
                ++this.lastStackLookedAt;
                if (this.lastStackLookedAt < targetInventory.k_()) continue;
                this.lastStackLookedAt = 0;
            }
        } else {
            ++this.lastStackLookedAt;
        }
    }

    @Override
    public void registerPosition(int xCoord, int yCoord, int zCoord, int slot) {
        this.xCoord = xCoord;
        this.yCoord = yCoord;
        this.zCoord = zCoord;
    }

    @Override
    public boolean hasGenericInterests() {
        return false;
    }

    @Override
    public List getSpecificInterests() {
        return null;
    }

    @Override
    public boolean interestedInAttachedInventory() {
        return false;
    }

    @Override
    public boolean interestedInUndamagedID() {
        return false;
    }

    @Override
    public boolean recievePassive() {
        return true;
    }
}

