/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.pipes.basic.CoreRoutedPipe;

public class PacketRoutingStats
extends PacketCoordinates {
    private CoreRoutedPipe pipe;
    public int stat_session_sent;
    public int stat_session_recieved;
    public int stat_session_relayed;
    public long stat_lifetime_sent;
    public long stat_lifetime_recieved;
    public long stat_lifetime_relayed;
    public int server_routing_table_size;

    public PacketRoutingStats() {
    }

    public PacketRoutingStats(int id, CoreRoutedPipe pipe) {
        super(id, pipe.xCoord, pipe.yCoord, pipe.zCoord);
        this.pipe = pipe;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        super.writeData(data);
        data.writeInt(this.pipe.stat_session_sent);
        data.writeInt(this.pipe.stat_session_recieved);
        data.writeInt(this.pipe.stat_session_relayed);
        data.writeLong(this.pipe.stat_lifetime_sent);
        data.writeLong(this.pipe.stat_lifetime_recieved);
        data.writeLong(this.pipe.stat_lifetime_relayed);
        data.writeInt(this.pipe.getRouter().getIRoutersByCost().size());
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        super.readData(data);
        this.stat_session_sent = data.readInt();
        this.stat_session_recieved = data.readInt();
        this.stat_session_relayed = data.readInt();
        this.stat_lifetime_sent = data.readLong();
        this.stat_lifetime_recieved = data.readLong();
        this.stat_lifetime_relayed = data.readLong();
        this.server_routing_table_size = data.readInt();
    }
}

