/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.logic.TemporaryLogic;
import logisticspipes.modules.ModuleItemSink;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.WorldUtil;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsBasicLogistics
extends CoreRoutedPipe {
    private ModuleItemSink itemSinkModule = new ModuleItemSink();

    public PipeItemsBasicLogistics(int itemID) {
        super(new PipeTransportLogistics(){

            public boolean isPipeConnected(any tile, ForgeDirection dir) {
                if (super.isPipeConnected(tile, dir)) {
                    return true;
                }
                if (tile instanceof ILogisticsPowerProvider) {
                    ForgeDirection ori = OrientationsUtil.getOrientationOfTilewithPipe(this, tile);
                    return ori != null && ori != ForgeDirection.UNKNOWN && ori != ForgeDirection.DOWN && ori != ForgeDirection.UP;
                }
                if (tile instanceof LogisticsSecurityTileEntity) {
                    ForgeDirection ori = OrientationsUtil.getOrientationOfTilewithPipe(this, tile);
                    return ori != null && ori != ForgeDirection.UNKNOWN && ori != ForgeDirection.DOWN && ori != ForgeDirection.UP;
                }
                return false;
            }
        }, new TemporaryLogic(), itemID);
        this.itemSinkModule.registerHandler(null, null, this, this);
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        if (this.isPowerProvider(connection)) {
            return Textures.LOGISTICSPIPE_POWERED_TEXTURE;
        }
        if (this.isSecurityProvider(connection)) {
            return Textures.LOGISTICSPIPE_SECURITY_TEXTURE;
        }
        return super.getNonRoutedTexture(connection);
    }

    @Override
    public boolean isLockedExit(ForgeDirection orientation) {
        if (this.isPowerProvider(orientation) || this.isSecurityProvider(orientation)) {
            return true;
        }
        return super.isLockedExit(orientation);
    }

    private boolean isPowerProvider(ForgeDirection ori) {
        any tilePipe = this.container.tileBuffer[ori.ordinal()].getTile();
        if (tilePipe == null || !this.container.isPipeConnected(tilePipe, ori)) {
            return false;
        }
        return tilePipe instanceof ILogisticsPowerProvider;
    }

    private boolean isSecurityProvider(ForgeDirection ori) {
        any tilePipe = this.container.tileBuffer[ori.ordinal()].getTile();
        if (tilePipe == null || !this.container.isPipeConnected(tilePipe, ori)) {
            return false;
        }
        return tilePipe instanceof LogisticsSecurityTileEntity;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_TEXTURE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return this.itemSinkModule;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    private boolean isSideOrientation(ForgeDirection ori) {
        return ori == ForgeDirection.EAST || ori == ForgeDirection.WEST || ori == ForgeDirection.SOUTH || ori == ForgeDirection.NORTH;
    }

    public List getConnectedPowerProviders() {
        ArrayList<ILogisticsPowerProvider> list = new ArrayList<ILogisticsPowerProvider>();
        WorldUtil world = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        LinkedList adjacent = world.getAdjacentTileEntities(true);
        for (AdjacentTile tile : adjacent) {
            if (!(tile.tile instanceof ILogisticsPowerProvider) || !this.isSideOrientation(tile.orientation)) continue;
            list.add((ILogisticsPowerProvider)tile.tile);
        }
        return list;
    }

    public void setTile(any tile) {
        super.setTile(tile);
        this.itemSinkModule.registerPosition(this.xCoord, this.yCoord, this.zCoord, 0);
    }

    @Override
    public Set getSpecificInterests() {
        if (this.itemSinkModule.isDefaultRoute()) {
            return null;
        }
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (int i = 0; i < 9; ++i) {
            ur item = this.itemSinkModule.getFilterInventory().a(i);
            if (item == null) continue;
            l1.add(ItemIdentifier.get(item));
        }
        return l1;
    }

    @Override
    public boolean hasGenericInterests() {
        return this.itemSinkModule.isDefaultRoute();
    }
}

