/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.PipeTransportItems;
import cpw.mods.fml.common.network.Player;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.gui.hud.HUDCraftingMK3;
import logisticspipes.interfaces.IChestContentReceiver;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.PipeItemsCraftingLogisticsMk2;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.CraftingPipeMk3Transport;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.SimpleInventory;
import net.minecraftforge.common.ForgeDirection;

public class PipeItemsCraftingLogisticsMk3
extends PipeItemsCraftingLogisticsMk2
implements ISimpleInventoryEventHandler,
IChestContentReceiver {
    public SimpleInventory inv = new SimpleInventory(16, "Buffer", 127);
    public List bufferList = new LinkedList();
    private HUDCraftingMK3 HUD = new HUDCraftingMK3(this);

    public PipeItemsCraftingLogisticsMk3(int itemID) {
        super(new CraftingPipeMk3Transport(), itemID);
        ((CraftingPipeMk3Transport)this.transport).pipe = this;
        this.inv.addListener(this);
    }

    @Override
    protected int neededEnergy() {
        return 20;
    }

    @Override
    protected int itemsToExtract() {
        return 128;
    }

    @Override
    protected int stacksToExtract() {
        if (SimpleServiceLocator.buildCraftProxy.checkMaxItems()) {
            return 8;
        }
        return 2;
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (this.inv.isEmpty()) {
            return;
        }
        if (this.worldObj.G() % 6L != 0L) {
            return;
        }
        List crafters = this.locateCrafters();
        if (crafters.size() < 1) {
            this.sendBuffer();
            return;
        }
        boolean change = false;
        for (AdjacentTile tile : crafters) {
            for (int i = 0; i < this.inv.k_(); ++i) {
                ur slot = this.inv.a(i);
                if (slot == null) continue;
                ForgeDirection insertion = tile.orientation.getOpposite();
                if (this.getUpgradeManager().hasSneakyUpgrade()) {
                    insertion = this.getUpgradeManager().getSneakyOrientation();
                }
                ur toadd = slot.l();
                toadd.a = Math.min(toadd.a, toadd.d());
                toadd.a = Math.min(toadd.a, ((la)tile.tile).c());
                ur added = InventoryHelper.getTransactorFor(tile.tile).add(toadd, insertion, true);
                slot.a -= added.a;
                if (added.a != 0) {
                    change = true;
                }
                if (slot.a <= 0) {
                    this.inv.a(i, null);
                    continue;
                }
                this.inv.a(i, slot);
            }
        }
        if (!this._orderManager.hasOrders()) {
            this.sendBuffer();
        }
        if (change) {
            this.inv.d();
        }
    }

    private void sendBuffer() {
        for (int i = 0; i < this.inv.k_(); ++i) {
            ur stackToSend = this.inv.a(i);
            if (stackToSend == null) continue;
            Position p = new Position((double)this.container.l, (double)this.container.m, (double)this.container.n, null);
            Position entityPos = new Position(p.x + 0.5, p.y + (double)Utils.getPipeFloorOf((ur)stackToSend), p.z + 0.5, ForgeDirection.UNKNOWN);
            EntityPassiveItem entityItem = new EntityPassiveItem(this.worldObj, entityPos.x, entityPos.y, entityPos.z, stackToSend);
            entityItem.setSpeed(Utils.pipeNormalSpeed * 10.0f);
            ((PipeTransportItems)this.transport).entityEntering((IPipedItem)entityItem, entityPos.orientation);
            this.inv.a(i, null);
            break;
        }
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this.inv.dropContents(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_CRAFTERMK3_TEXTURE;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound, "buffer");
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound, "buffer");
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        MainProxy.sendToPlayerList(new PacketPipeInvContent(52, this.xCoord, this.yCoord, this.zCoord, ItemIdentifierStack.getListFromInventory(this.inv, true)).getPacket(), this.localModeWatchers);
    }

    @Override
    public void playerStartWatching(qx player, int mode) {
        super.playerStartWatching(player, mode);
        if (mode == 1) {
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(52, this.xCoord, this.yCoord, this.zCoord, ItemIdentifierStack.getListFromInventory(this.inv, true)).getPacket(), (Player)player);
        }
    }

    @Override
    public void setReceivedChestContent(Collection list) {
        this.bufferList.clear();
        this.bufferList.addAll(list);
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }
}

