/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.transport.EntityData;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.gui.hud.HUDInvSysConnector;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.IOrderManagerContentReceiver;
import logisticspipes.interfaces.routing.IDirectRoutingConnection;
import logisticspipes.logic.LogicInvSysConnection;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.SidedInventoryAdapter;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.transport.TransportInvConnection;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair4;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.WorldUtil;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public class PipeItemsInvSysConnector
extends CoreRoutedPipe
implements IDirectRoutingConnection,
IHeadUpDisplayRendererProvider,
IOrderManagerContentReceiver {
    private boolean init = false;
    private LinkedList destination = new LinkedList();
    public SimpleInventory inv = new SimpleInventory(1, "Freq. card", 1);
    public int resistance;
    public Set oldList = new TreeSet();
    public final LinkedList displayList = new LinkedList();
    public final List localModeWatchers = new ArrayList();
    private HUDInvSysConnector HUD = new HUDInvSysConnector(this);
    private UUID idbuffer = UUID.randomUUID();

    public PipeItemsInvSysConnector(int itemID) {
        super(new TransportInvConnection(), new LogicInvSysConnection(), itemID);
    }

    @Override
    public void enabledUpdateEntity() {
        CoreRoutedPipe CRP;
        if (!this.init && this.hasConnectionUUID()) {
            if (!SimpleServiceLocator.connectionManager.addDirectConnection(this.getConnectionUUID(), this.getRouter())) {
                this.dropFreqCard();
            }
            if ((CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter())) != null) {
                CRP.refreshRender(true);
            }
            this.getRouter().update(true);
            this.refreshRender(true);
            this.init = true;
            this.idbuffer = this.getConnectionUUID();
        }
        if (this.init && !this.hasConnectionUUID()) {
            this.init = false;
            CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        if (this.init && this.idbuffer != null && !this.idbuffer.equals(this.getConnectionUUID())) {
            this.init = false;
            CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        if (this.destination.size() > 0) {
            this.checkConnectedInvs();
        }
    }

    private void checkConnectedInvs() {
        WorldUtil wUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        for (AdjacentTile tile : wUtil.getAdjacentTileEntities(true)) {
            if (!(tile.tile instanceof la)) continue;
            la inv = InventoryHelper.getInventory((la)tile.tile);
            if (inv instanceof ISidedInventory) {
                inv = new SidedInventoryAdapter((ISidedInventory)inv, tile.orientation.getOpposite());
            }
            if (!this.checkOneConnectedInv(inv, tile.orientation)) continue;
            this.updateContentListener();
            break;
        }
    }

    private boolean checkOneConnectedInv(la inv, ForgeDirection dir) {
        boolean contentchanged = false;
        block0: for (int i = 0; i < inv.k_(); ++i) {
            ur stack = inv.a(i);
            if (stack == null) continue;
            ItemIdentifier ident = ItemIdentifier.get(stack);
            for (Pair4 pair : this.destination) {
                if (pair.getValue1() != ident) continue;
                int tosend = Math.min((Integer)pair.getValue2(), stack.a);
                if (!this.useEnergy(6)) continue block0;
                this.sendStack(inv.a(i, tosend), (Integer)pair.getValue3(), dir, (IRoutedItem.TransportMode)((Object)pair.getValue4()));
                if (tosend < (Integer)pair.getValue2()) {
                    pair.setValue2((Integer)pair.getValue2() - tosend);
                } else {
                    this.destination.remove(pair);
                }
                contentchanged = true;
                continue block0;
            }
        }
        return contentchanged;
    }

    public void sendStack(ur stack, int destination, ForgeDirection dir, IRoutedItem.TransportMode mode) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(mode);
        super.queueRoutedItem(itemToSend, dir);
        MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 4);
    }

    private UUID getConnectionUUID() {
        if (this.inv != null && this.inv.a(0) != null && this.inv.a(0).o() && this.inv.a(0).p().b("UUID")) {
            return UUID.fromString(this.inv.a(0).p().i("UUID"));
        }
        return null;
    }

    private boolean hasConnectionUUID() {
        return this.inv != null && this.inv.a(0) != null && this.inv.a(0).o() && this.inv.a(0).p().b("UUID");
    }

    private void dropFreqCard() {
        if (this.inv.a(0) == null) {
            return;
        }
        px item = new px(this.worldObj, (double)this.xCoord, (double)this.yCoord, (double)this.zCoord, this.inv.a(0));
        this.worldObj.d((lq)item);
        this.inv.a(0, null);
    }

    public Set getExpectedItems() {
        TreeMap list = new TreeMap();
        for (Pair4 pair : this.destination) {
            ItemIdentifierStack currentStack = new ItemIdentifierStack((ItemIdentifier)pair.getValue1(), (Integer)pair.getValue2());
            Map.Entry entry = list.ceilingEntry(currentStack);
            if (entry != null && entry.getKey().getItem().uniqueID == currentStack.getItem().uniqueID) {
                entry.getKey().stackSize += currentStack.stackSize;
                continue;
            }
            list.put(currentStack, null);
        }
        return list.keySet();
    }

    @Override
    public boolean wrenchClicked(yc world, int i, int j, int k, qx entityplayer, SecuritySettings settings) {
        if (MainProxy.isServer(world)) {
            if (settings == null || settings.openGui) {
                entityplayer.openGui((Object)LogisticsPipes.instance, 16, world, i, j, k);
            } else {
                entityplayer.a("Permission denied");
            }
        }
        return true;
    }

    @Override
    public void onBlockRemoval() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.dropFreqCard();
        super.onBlockRemoval();
    }

    @Override
    public void invalidate() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.init = false;
        super.invalidate();
    }

    @Override
    public void onChunkUnload() {
        if (!this.stillNeedReplace) {
            CoreRoutedPipe CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter());
            SimpleServiceLocator.connectionManager.removeDirectConnection(this.getRouter());
            if (CRP != null) {
                CRP.refreshRender(true);
            }
        }
        this.init = false;
        super.onChunkUnload();
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.inv.writeToNBT(nbttagcompound, "");
        nbttagcompound.a("resistance", this.resistance);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.inv.readFromNBT(nbttagcompound, "");
        this.resistance = nbttagcompound.e("resistance");
    }

    private boolean hasRemoteConnection() {
        return this.hasConnectionUUID() && this.worldObj != null && SimpleServiceLocator.connectionManager.hasDirectConnection(this.getRouter());
    }

    private boolean inventoryConnected() {
        for (int i = 0; i < 6; ++i) {
            Position p = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, ForgeDirection.values()[i]);
            p.moveForwards(1.0);
            any tile = this.worldObj.q((int)p.x, (int)p.y, (int)p.z);
            if (!(tile instanceof la)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        if (!this.stillNeedReplace && this.hasRemoteConnection()) {
            if (this.inventoryConnected()) {
                return Textures.LOGISTICSPIPE_INVSYSCON_CON_TEXTURE;
            }
            return Textures.LOGISTICSPIPE_INVSYSCON_MIS_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_INVSYSCON_DIS_TEXTURE;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    @Override
    public int getConnectionResistance() {
        return this.resistance;
    }

    @Override
    public void addItem(ItemIdentifier item, int amount, int destinationId, IRoutedItem.TransportMode mode) {
        if (item != null && destinationId >= 0) {
            this.destination.addLast(new Pair4(item, amount, destinationId, (Object)mode));
            this.updateContentListener();
        }
    }

    public boolean isConnectedInv(any tile) {
        for (int i = 0; i < 6; ++i) {
            Position p = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, ForgeDirection.values()[i]);
            p.moveForwards(1.0);
            any lTile = this.worldObj.q((int)p.x, (int)p.y, (int)p.z);
            if (!(lTile instanceof la)) continue;
            return lTile == tile;
        }
        return false;
    }

    public void handleItemEnterInv(EntityData data, any tile) {
        if (this.isConnectedInv(tile) && data.item instanceof IRoutedItem) {
            CoreRoutedPipe CRP;
            IRoutedItem routed = (IRoutedItem)data.item;
            if (this.hasRemoteConnection() && (CRP = SimpleServiceLocator.connectionManager.getConnectedPipe(this.getRouter())) instanceof IDirectRoutingConnection) {
                IDirectRoutingConnection pipe = (IDirectRoutingConnection)((Object)CRP);
                pipe.addItem(ItemIdentifier.get(routed.getItemStack()), routed.getItemStack().a, routed.getDestination(), routed.getTransportMode());
                MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 4);
            }
        }
    }

    @Override
    public int getX() {
        return this.xCoord;
    }

    @Override
    public int getY() {
        return this.yCoord;
    }

    @Override
    public int getZ() {
        return this.zCoord;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    private void updateContentListener() {
        Set newList = this.getExpectedItems();
        if (!newList.equals(this.oldList)) {
            this.oldList = newList;
            MainProxy.sendToPlayerList(new PacketPipeInvContent(53, this.xCoord, this.yCoord, this.zCoord, newList).getPacket(), this.localModeWatchers);
        }
    }

    @Override
    public void playerStartWatching(qx player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(53, this.xCoord, this.yCoord, this.zCoord, this.getExpectedItems()).getPacket(), (Player)player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(qx player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    @Override
    public void setOrderManagerContent(Collection list) {
        this.displayList.clear();
        this.displayList.addAll(list);
    }
}

