/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.logic.LogicLiquidSupplier;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeTransportLogistics;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;

public class PipeItemsLiquidSupplier
extends CoreRoutedPipe
implements IRequestItems,
IItemTravelingHook {
    private boolean _lastRequestFailed = false;

    public PipeItemsLiquidSupplier(int itemID) {
        super(new PipeTransportLogistics(){

            public boolean isPipeConnected(any tile, ForgeDirection dir) {
                ITankContainer liq;
                if (super.isPipeConnected(tile, dir)) {
                    return true;
                }
                if (tile instanceof TileGenericPipe) {
                    return false;
                }
                return tile instanceof ITankContainer && (liq = (ITankContainer)tile).getTanks(ForgeDirection.UNKNOWN) != null && liq.getTanks(ForgeDirection.UNKNOWN).length > 0;
            }
        }, new LogicLiquidSupplier(), itemID);
        ((PipeTransportItems)this.transport).travelHook = this;
        ((LogicLiquidSupplier)this.logic)._power = this;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUIDSUPPLIER_TEXTURE;
    }

    public boolean isRequestFailed() {
        return this._lastRequestFailed;
    }

    public void setRequestFailed(boolean value) {
        this._lastRequestFailed = value;
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        return null;
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Fast;
    }

    public void endReached(PipeTransportItems pipe, EntityData data, any tile) {
        ((PipeTransportLogistics)pipe).markChunkModified(tile);
        if (!(tile instanceof ITankContainer)) {
            return;
        }
        if (tile instanceof TileGenericPipe) {
            return;
        }
        ITankContainer container = (ITankContainer)tile;
        if (data.item == null) {
            return;
        }
        if (data.item.getItemStack() == null) {
            return;
        }
        LiquidStack liquidId = LiquidContainerRegistry.getLiquidForFilledItem((ur)data.item.getItemStack());
        if (liquidId == null) {
            return;
        }
        ForgeDirection orientation = data.output.getOpposite();
        if (this.getUpgradeManager().hasSneakyUpgrade()) {
            orientation = this.getUpgradeManager().getSneakyOrientation();
        }
        while (data.item.getItemStack().a > 0 && container.fill(orientation, liquidId, false) == liquidId.amount && this.useEnergy(5)) {
            up item;
            container.fill(orientation, liquidId, true);
            --data.item.getItemStack().a;
            if (data.item.getItemStack().c < 0 || data.item.getItemStack().c >= up.e.length || !(item = up.e[data.item.getItemStack().c]).s()) continue;
            up containerItem = item.r();
            IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(new ur(containerItem, 1), this.worldObj);
            this.queueRoutedItem(itemToSend, data.output);
        }
        if (data.item.getItemStack().a < 1) {
            ((PipeTransportItems)this.transport).scheduleRemoval(data.item);
        }
    }

    public void drop(PipeTransportItems pipe, EntityData data) {
    }

    public void centerReached(PipeTransportItems pipe, EntityData data) {
    }

    @Override
    public boolean hasGenericInterests() {
        return true;
    }
}

