/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.transport.PipeTransportLiquids;
import buildcraft.transport.TileGenericPipe;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.interfaces.routing.ILiquidProvider;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.liquid.LiquidRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.LiquidRequest;
import logisticspipes.routing.LiquidLogisticsPromise;
import logisticspipes.routing.LogisticsLiquidOrderManager;
import logisticspipes.textures.Textures;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;
import logisticspipes.utils.Pair3;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;

public class PipeLiquidProvider
extends LiquidRoutedPipe
implements ILiquidProvider {
    LogisticsLiquidOrderManager manager = new LogisticsLiquidOrderManager();

    public PipeLiquidProvider(int itemID) {
        super(itemID);
    }

    @Override
    public void enabledUpdateEntity() {
        if (!this.manager.hasOrders() || this.worldObj.G() % 6L != 0L) {
            return;
        }
        Pair3 order = this.manager.getFirst();
        int amountToSend = Math.min((Integer)order.getValue2(), 5000);
        block0: for (Pair pair : this.getAdjacentTanks(false)) {
            ILiquidTank[] tanks;
            if (amountToSend <= 0) break;
            for (ILiquidTank tank : tanks = ((ITankContainer)pair.getValue1()).getTanks(((ForgeDirection)pair.getValue2()).getOpposite())) {
                LiquidStack liquid = tank.getLiquid();
                if (liquid == null || order.getValue1() != LiquidIdentifier.get(liquid)) continue;
                int amount = Math.min(liquid.amount, amountToSend);
                amountToSend -= amount;
                LiquidStack drained = ((ITankContainer)pair.getValue1()).drain((ForgeDirection)pair.getValue2(), amount, false);
                if (order.getValue1() != LiquidIdentifier.get(drained)) continue;
                drained = ((ITankContainer)pair.getValue1()).drain((ForgeDirection)pair.getValue2(), amount, true);
                ur stack = SimpleServiceLocator.logisticsLiquidManager.getLiquidContainer(drained);
                IRoutedItem item = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
                item.setDestination(((IRequestLiquid)order.getValue3()).getRouter().getSimpleID());
                item.setTransportMode(IRoutedItem.TransportMode.Active);
                this.queueRoutedItem(item, (ForgeDirection)pair.getValue2());
                this.manager.sendAmount(amount);
                if (amountToSend <= 0) continue block0;
            }
        }
        if (amountToSend > 0) {
            this.manager.sendFailed();
        }
    }

    @Override
    public Map getAvailableLiquids() {
        HashMap<Object, Integer> map = new HashMap<Object, Integer>();
        for (Pair pair : this.getAdjacentTanks(false)) {
            ILiquidTank[] tanks;
            for (ILiquidTank tank : tanks = ((ITankContainer)pair.getValue1()).getTanks(((ForgeDirection)pair.getValue2()).getOpposite())) {
                LiquidStack liquid = tank.getLiquid();
                if (liquid == null || liquid.itemID == 0) continue;
                LiquidIdentifier ident = LiquidIdentifier.get(liquid);
                if (map.containsKey(ident)) {
                    map.put(ident, (Integer)map.get(ident) + tank.getLiquid().amount);
                    continue;
                }
                map.put(ident, tank.getLiquid().amount);
            }
        }
        for (Pair pair : this.manager.getAll()) {
            if (!map.containsKey(pair.getValue1())) continue;
            int result = (Integer)map.get(pair.getValue1()) - (Integer)pair.getValue2();
            if (result > 0) {
                map.put(pair.getValue1(), result);
                continue;
            }
            map.remove(pair.getValue1());
        }
        return map;
    }

    @Override
    public boolean disconnectPipe(any tile, ForgeDirection dir) {
        return tile instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe != null && ((TileGenericPipe)tile).pipe.transport instanceof PipeTransportLiquids;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_PROVIDER;
    }

    @Override
    public void canProvide(LiquidRequest request) {
        if (request.isAllDone()) {
            return;
        }
        for (Pair pair : this.getAdjacentTanks(false)) {
            ILiquidTank[] tanks;
            for (ILiquidTank tank : tanks = ((ITankContainer)pair.getValue1()).getTanks(((ForgeDirection)pair.getValue2()).getOpposite())) {
                LiquidStack liquid = tank.getLiquid();
                if (liquid == null || request.getLiquid() != LiquidIdentifier.get(liquid)) continue;
                LiquidLogisticsPromise promise = new LiquidLogisticsPromise();
                promise.item = request.getLiquid();
                promise.amount = Math.min(request.amountLeft(), liquid.amount);
                promise.sender = this;
                request.addPromise(promise);
            }
        }
    }

    @Override
    public void fullFill(LiquidLogisticsPromise promise, IRequestLiquid destination) {
        this.manager.add(promise, destination);
    }

    @Override
    public boolean canInsertToTanks() {
        return true;
    }

    @Override
    public boolean canInsertFromSideToTanks() {
        return true;
    }

    @Override
    public Set getSpecificInterests() {
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        for (Pair pair : this.getAdjacentTanks(false)) {
            ILiquidTank[] tanks;
            for (ILiquidTank tank : tanks = ((ITankContainer)pair.getValue1()).getTanks(((ForgeDirection)pair.getValue2()).getOpposite())) {
                LiquidStack liquid = tank.getLiquid();
                if (liquid == null || liquid.itemID == 0) continue;
                LiquidIdentifier ident = LiquidIdentifier.get(liquid);
                l1.add(ident.getItemIdentifier());
            }
        }
        return l1;
    }
}

