/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import buildcraft.api.core.Position;
import buildcraft.core.DefaultProps;
import buildcraft.transport.TileGenericPipe;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.gui.GuiChassiPipe;
import logisticspipes.gui.hud.HUDChassiePipe;
import logisticspipes.interfaces.IHeadUpDisplayRenderer;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.interfaces.ILegacyActiveModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISendQueueContentRecieiver;
import logisticspipes.interfaces.ISendRoutedItem;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.items.ItemModule;
import logisticspipes.logic.BaseChassiLogic;
import logisticspipes.logisticspipes.ChassiModule;
import logisticspipes.logisticspipes.ChassiTransportLayer;
import logisticspipes.logisticspipes.IInventoryProvider;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.ItemModuleInformationManager;
import logisticspipes.logisticspipes.SidedInventoryAdapter;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.network.packets.PacketCoordinates;
import logisticspipes.network.packets.PacketPipeInteger;
import logisticspipes.network.packets.PacketPipeInvContent;
import logisticspipes.network.packets.PacketPipeUpdate;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.HudUpdateTick;
import logisticspipes.utils.ISimpleInventoryEventHandler;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.SimpleInventory;
import logisticspipes.utils.SinkReply;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;

public abstract class PipeLogisticsChassi
extends CoreRoutedPipe
implements ISimpleInventoryEventHandler,
IInventoryProvider,
ISendRoutedItem,
IProvideItems,
IWorldProvider,
IHeadUpDisplayRendererProvider,
ISendQueueContentRecieiver {
    private final ChassiModule _module;
    private final SimpleInventory _moduleInventory;
    private boolean switchOrientationOnTick = true;
    private boolean init = false;
    BaseChassiLogic ChassiLogic;
    private boolean convertFromMeta = false;
    public final LinkedList displayList = new LinkedList();
    public final List localModeWatchers = new ArrayList();
    private HUDChassiePipe HUD;

    public PipeLogisticsChassi(int itemID) {
        super(new BaseChassiLogic(), itemID);
        this.ChassiLogic = (BaseChassiLogic)this.logic;
        this._moduleInventory = new SimpleInventory(this.getChassiSize(), "Chassi pipe", 1);
        this._moduleInventory.addListener(this);
        this._module = new ChassiModule(this.getChassiSize(), this);
        this.HUD = new HUDChassiePipe(this, this._module, this._moduleInventory);
    }

    @Override
    protected List getConnectedRawInventories() {
        if (this._cachedAdjacentInventories != null) {
            return this._cachedAdjacentInventories;
        }
        ArrayList<la> adjacent = new ArrayList<la>(1);
        la adjinv = this.getRawInventory();
        if (adjinv != null) {
            adjacent.add(adjinv);
        }
        this._cachedAdjacentInventories = adjacent;
        return this._cachedAdjacentInventories;
    }

    public ForgeDirection getPointedOrientation() {
        return this.ChassiLogic.orientation;
    }

    public any getPointedTileEntity() {
        if (this.ChassiLogic.orientation == ForgeDirection.UNKNOWN) {
            return null;
        }
        if (this.container.tileBuffer == null) {
            return null;
        }
        return this.container.tileBuffer[this.ChassiLogic.orientation.ordinal()].getTile();
    }

    public void nextOrientation() {
        boolean found = false;
        ForgeDirection oldOrientation = this.ChassiLogic.orientation;
        for (int l = 0; l < 6; ++l) {
            this.ChassiLogic.orientation = ForgeDirection.values()[(this.ChassiLogic.orientation.ordinal() + 1) % 6];
            if (!this.isValidOrientation(this.ChassiLogic.orientation)) continue;
            found = true;
            break;
        }
        if (!found) {
            this.ChassiLogic.orientation = ForgeDirection.UNKNOWN;
        }
        if (this.ChassiLogic.orientation != oldOrientation) {
            this.clearCache();
            MainProxy.sendPacketToAllAround(this.xCoord, this.yCoord, this.zCoord, DefaultProps.NETWORK_UPDATE_RANGE, MainProxy.getDimensionForWorld(this.worldObj), new PacketPipeUpdate(36, this.xCoord, this.yCoord, this.zCoord, this.getLogisticsNetworkPacket()).getPacket());
            this.refreshRender(true);
        }
    }

    private boolean isValidOrientation(ForgeDirection connection) {
        if (connection == ForgeDirection.UNKNOWN) {
            return false;
        }
        if (this.getRouter().isRoutedExit(connection)) {
            return false;
        }
        Position pos = new Position((double)this.xCoord, (double)this.yCoord, (double)this.zCoord, connection);
        pos.moveForwards(1.0);
        any tile = this.worldObj.q((int)pos.x, (int)pos.y, (int)pos.z);
        if (tile == null) {
            return false;
        }
        if (tile instanceof TileGenericPipe) {
            return false;
        }
        return SimpleServiceLocator.buildCraftProxy.checkPipesConnections((any)this.container, tile, connection);
    }

    public la getModuleInventory() {
        return this._moduleInventory;
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_TEXTURE;
    }

    @Override
    public Textures.TextureType getRoutedTexture(ForgeDirection connection) {
        return Textures.LOGISTICSPIPE_CHASSI_ROUTED_TEXTURE;
    }

    @Override
    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        if (connection.equals((Object)this.ChassiLogic.orientation)) {
            return Textures.LOGISTICSPIPE_CHASSI_DIRECTION_TEXTURE;
        }
        return Textures.LOGISTICSPIPE_CHASSI_NOTROUTED_TEXTURE;
    }

    @Override
    public void onNeighborBlockChange_Logistics() {
        if (!this.isValidOrientation(this.ChassiLogic.orientation) && MainProxy.isServer(this.worldObj)) {
            this.nextOrientation();
        }
    }

    @Override
    public void onBlockPlaced() {
        super.onBlockPlaced();
        this.switchOrientationOnTick = true;
    }

    @Override
    public la getRawInventory() {
        any tile = this.getPointedTileEntity();
        if (tile == null) {
            return null;
        }
        if (tile instanceof TileGenericPipe) {
            return null;
        }
        if (!(tile instanceof la)) {
            return null;
        }
        return InventoryHelper.getInventory((la)tile);
    }

    @Override
    public la getPointedInventory() {
        la rawInventory = this.getRawInventory();
        if (rawInventory instanceof ISidedInventory) {
            return new SidedInventoryAdapter((ISidedInventory)rawInventory, this.getPointedOrientation().getOpposite());
        }
        return rawInventory;
    }

    @Override
    public la getSneakyInventory() {
        UpgradeManager manager = this.getUpgradeManager();
        ForgeDirection insertion = this.getPointedOrientation().getOpposite();
        if (manager.hasSneakyUpgrade()) {
            insertion = manager.getSneakyOrientation();
        }
        return this.getSneakyInventory(insertion);
    }

    @Override
    public la getSneakyInventory(ForgeDirection insertion) {
        la rawInventory = this.getRawInventory();
        if (rawInventory instanceof ISidedInventory) {
            return new SidedInventoryAdapter((ISidedInventory)rawInventory, insertion);
        }
        return rawInventory;
    }

    @Override
    public ForgeDirection inventoryOrientation() {
        return this.getPointedOrientation();
    }

    public int getSourceint() {
        return this.getRouter().getSimpleID();
    }

    @Override
    public Pair3 hasDestination(ItemIdentifier stack, boolean allowDefault, List routerIDsToExclude) {
        return SimpleServiceLocator.logisticsManager.hasDestination(stack, allowDefault, this.getRouter().getSimpleID(), routerIDsToExclude);
    }

    @Override
    public void sendStack(ur stack, Pair3 reply, CoreRoutedPipe.ItemSendMode mode) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setDestination((Integer)reply.getValue1());
        if (((SinkReply)reply.getValue2()).isPassive) {
            if (((SinkReply)reply.getValue2()).isDefault) {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Default);
            } else {
                itemToSend.setTransportMode(IRoutedItem.TransportMode.Passive);
            }
        }
        LinkedList<IFilter> list = new LinkedList<IFilter>();
        if (reply.getValue3() != null) {
            for (IFilter filter : (List)reply.getValue3()) {
                list.add(filter);
            }
        }
        itemToSend.addRelayPoints(list);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation(), mode);
    }

    @Override
    public void sendStack(ur stack, int destination, CoreRoutedPipe.ItemSendMode mode, List relays) {
        IRoutedItem itemToSend = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(stack, this.worldObj);
        itemToSend.setDestination(destination);
        itemToSend.setTransportMode(IRoutedItem.TransportMode.Active);
        itemToSend.addRelayPoints(relays);
        super.queueRoutedItem(itemToSend, this.getPointedOrientation(), mode);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        try {
            super.readFromNBT(nbttagcompound);
            this._moduleInventory.readFromNBT(nbttagcompound, "chassi");
            this.InventoryChanged(this._moduleInventory);
            this._module.readFromNBT(nbttagcompound);
            this.ChassiLogic.orientation = ForgeDirection.values()[nbttagcompound.e("Orientation") % 7];
            if (nbttagcompound.e("Orientation") == 0) {
                this.convertFromMeta = true;
            }
            this.switchOrientationOnTick = this.ChassiLogic.orientation == ForgeDirection.UNKNOWN;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this._moduleInventory.writeToNBT(nbttagcompound, "chassi");
        this._module.writeToNBT(nbttagcompound);
        nbttagcompound.a("Orientation", this.ChassiLogic.orientation.ordinal());
    }

    @Override
    public void onBlockRemoval() {
        super.onBlockRemoval();
        this._moduleInventory.removeListener(this);
        if (MainProxy.isServer(this.worldObj)) {
            int i;
            for (i = 0; i < this.getChassiSize(); ++i) {
                ILogisticsModule x = this._module.getSubModule(i);
                if (!(x instanceof ILegacyActiveModule)) continue;
                ILegacyActiveModule y2 = (ILegacyActiveModule)((Object)x);
                y2.onBlockRemoval();
            }
            for (i = 0; i < this._moduleInventory.k_(); ++i) {
                if (this._moduleInventory.a(i) == null) continue;
                ItemModuleInformationManager.saveInfotmation(this._moduleInventory.a(i), this.getLogisticsModule().getSubModule(i));
            }
            this._moduleInventory.dropContents(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
    }

    @Override
    public void InventoryChanged(SimpleInventory inventory) {
        boolean reInitGui = false;
        for (int i = 0; i < inventory.k_(); ++i) {
            ur stack = inventory.a(i);
            if (stack == null) {
                if (!this._module.hasModule(i)) continue;
                this._module.removeModule(i);
                reInitGui = true;
                continue;
            }
            if (!(stack.b() instanceof ItemModule)) continue;
            ILogisticsModule current = this._module.getModule(i);
            ILogisticsModule next = ((ItemModule)stack.b()).getModuleForItem(stack, this._module.getModule(i), this, this, this, this);
            next.registerPosition(this.xCoord, this.yCoord, this.zCoord, i);
            if (current == next) continue;
            this._module.installModule(i, next);
            if (!MainProxy.isClient()) {
                ItemModuleInformationManager.readInformation(stack, next);
            }
            ItemModuleInformationManager.removeInformation(stack);
        }
        if (reInitGui && MainProxy.isClient(this.worldObj) && FMLClientHandler.instance().getClient().r instanceof GuiChassiPipe) {
            FMLClientHandler.instance().getClient().r.A_();
        }
        if (MainProxy.isServer()) {
            MainProxy.sendToPlayerList(new PacketPipeInvContent(59, this.xCoord, this.yCoord, this.zCoord, ItemIdentifierStack.getListFromInventory(this._moduleInventory)).getPacket(), this.localModeWatchers);
            LinkedList<ILegacyActiveModule> prevModules = new LinkedList<ILegacyActiveModule>();
            for (int i = 0; i < this.getChassiSize(); ++i) {
                ILogisticsModule x = this._module.getSubModule(i);
                if (!(x instanceof ILegacyActiveModule)) continue;
                ILegacyActiveModule y2 = (ILegacyActiveModule)((Object)x);
                y2.registerPreviousLegacyModules(new ArrayList(prevModules));
                prevModules.add(y2);
            }
        }
    }

    @Override
    public void ignoreDisableUpdateEntity() {
        if (this.switchOrientationOnTick) {
            this.switchOrientationOnTick = false;
            if (MainProxy.isServer(this.worldObj)) {
                this.nextOrientation();
            }
        }
        if (this.convertFromMeta && this.worldObj.h(this.xCoord, this.yCoord, this.zCoord) != 0) {
            this.ChassiLogic.orientation = ForgeDirection.values()[this.worldObj.h(this.xCoord, this.yCoord, this.zCoord) % 6];
            this.worldObj.d(this.xCoord, this.yCoord, this.zCoord, 0);
            this.convertFromMeta = false;
        }
        if (!this.init) {
            this.init = true;
            if (MainProxy.isClient(this.worldObj)) {
                MainProxy.sendPacketToServer(new PacketCoordinates(33, this.xCoord, this.yCoord, this.zCoord).getPacket());
            }
        }
    }

    public abstract int getChassiSize();

    @Override
    public final ILogisticsModule getLogisticsModule() {
        return this._module;
    }

    @Override
    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new ChassiTransportLayer(this);
        }
        return this._transportLayer;
    }

    private boolean tryInsertingModule(qx entityplayer) {
        for (int i = 0; i < this._moduleInventory.k_(); ++i) {
            ur item = this._moduleInventory.a(i);
            if (item != null) continue;
            this._moduleInventory.a(i, entityplayer.bS().a(1));
            this.InventoryChanged(this._moduleInventory);
            return true;
        }
        return false;
    }

    @Override
    public boolean handleClick(yc world, int x, int y2, int z, qx entityplayer, SecuritySettings settings) {
        if (entityplayer.bS() == null) {
            return false;
        }
        if (SimpleServiceLocator.buildCraftProxy.isWrenchEquipped(entityplayer) && entityplayer.ah()) {
            if (MainProxy.isServer(world)) {
                if (settings == null || settings.openGui) {
                    ((PipeLogisticsChassi)this.container.pipe).nextOrientation();
                } else {
                    entityplayer.a("Permission denied");
                }
            }
            return true;
        }
        if (!entityplayer.ah() && entityplayer.bS().c == LogisticsPipes.ModuleItem.cj && entityplayer.bS().j() != 0) {
            if (MainProxy.isServer(world)) {
                if (settings == null || settings.openGui) {
                    return this.tryInsertingModule(entityplayer);
                }
                entityplayer.a("Permission denied");
            }
            return true;
        }
        return false;
    }

    @Override
    public void canProvide(RequestTreeNode tree, int donePromisses, List filters) {
        if (!this.isEnabled()) {
            return;
        }
        for (IFilter filter : filters) {
            if (filter.isBlocked() != filter.isFilteredItem(tree.getStack().getItem().getUndamaged()) && !filter.blockProvider()) continue;
            return;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILegacyActiveModule y2;
            ILogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule) || !(y2 = (ILegacyActiveModule)((Object)x)).filterAllowsItem(tree.getStack().getItem())) continue;
            y2.canProvide(tree, donePromisses, filters);
            return;
        }
    }

    @Override
    public void fullFill(LogisticsPromise promise, IRequestItems destination) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILegacyActiveModule y2;
            ILogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule) || !(y2 = (ILegacyActiveModule)((Object)x)).filterAllowsItem(promise.item)) continue;
            y2.fullFill(promise, destination);
            MainProxy.sendSpawnParticlePacket(1, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 2);
            return;
        }
    }

    @Override
    public void getAllItems(Map list, List filter) {
        if (!this.isEnabled()) {
            return;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILogisticsModule x = this._module.getSubModule(i);
            if (!(x instanceof ILegacyActiveModule)) continue;
            ILegacyActiveModule y2 = (ILegacyActiveModule)((Object)x);
            y2.getAllItems(list, filter);
        }
    }

    @Override
    public CoreRoutedPipe.ItemSendMode getItemSendMode() {
        return CoreRoutedPipe.ItemSendMode.Normal;
    }

    @Override
    public yc getWorld() {
        return this.worldObj;
    }

    @Override
    public IHeadUpDisplayRenderer getRenderer() {
        return this.HUD;
    }

    @Override
    public int getX() {
        return this.xCoord;
    }

    @Override
    public int getY() {
        return this.yCoord;
    }

    @Override
    public int getZ() {
        return this.zCoord;
    }

    @Override
    public void startWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(50, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
    }

    @Override
    public void stopWaitching() {
        MainProxy.sendPacketToServer(new PacketPipeInteger(51, this.xCoord, this.yCoord, this.zCoord, 1).getPacket());
        this.HUD.stopWatching();
    }

    @Override
    public void playerStartWatching(qx player, int mode) {
        if (mode == 1) {
            this.localModeWatchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(59, this.xCoord, this.yCoord, this.zCoord, ItemIdentifierStack.getListFromInventory(this._moduleInventory)).getPacket(), (Player)player);
            MainProxy.sendPacketToPlayer(new PacketPipeInvContent(65, this.xCoord, this.yCoord, this.zCoord, ItemIdentifierStack.getListSendQueue(this._sendQueue)).getPacket(), (Player)player);
        } else {
            super.playerStartWatching(player, mode);
        }
    }

    @Override
    public void playerStopWatching(qx player, int mode) {
        super.playerStopWatching(player, mode);
        this.localModeWatchers.remove(player);
    }

    public void handleModuleItemIdentifierList(Collection _allItems) {
        this._moduleInventory.handleItemIdentifierList(_allItems);
    }

    public void handleContentItemIdentifierList(Collection _allItems) {
        this._moduleInventory.handleItemIdentifierList(_allItems);
    }

    @Override
    public int sendQueueChanged(boolean force) {
        if (MainProxy.isServer(this.worldObj)) {
            if (Configs.MULTI_THREAD_NUMBER > 0 && !force) {
                HudUpdateTick.add(this.getRouter());
            } else if (this.localModeWatchers != null && this.localModeWatchers.size() > 0) {
                LinkedList items = ItemIdentifierStack.getListSendQueue(this._sendQueue);
                MainProxy.sendCompressedToPlayerList(new PacketPipeInvContent(65, this.xCoord, this.yCoord, this.zCoord, items).getPacket(), this.localModeWatchers);
                return items.size();
            }
        }
        return 0;
    }

    @Override
    public void handleSendQueueItemIdentifierList(Collection _allItems) {
        this.displayList.clear();
        this.displayList.addAll(_allItems);
    }

    public ChassiModule getModules() {
        return this._module;
    }

    public void setTile(any tile) {
        super.setTile(tile);
        for (int i = 0; i < this._moduleInventory.k_(); ++i) {
            ILogisticsModule current = this._module.getModule(i);
            if (current == null) continue;
            current.registerPosition(this.xCoord, this.yCoord, this.zCoord, i);
        }
    }

    @Override
    public int getSourceID() {
        return this.getRouterId();
    }

    @Override
    public Set getSpecificInterests() {
        ILogisticsModule module;
        TreeSet<ItemIdentifier> l1 = new TreeSet<ItemIdentifier>();
        if (this.getRawInventory() == null) {
            return l1;
        }
        for (int moduleIndex = 0; moduleIndex < this.getChassiSize(); ++moduleIndex) {
            module = this._module.getSubModule(moduleIndex);
            if (module == null || !module.interestedInAttachedInventory()) continue;
            la inv = this.getRawInventory();
            if (inv instanceof ISidedInventory) {
                inv = new SidedInventoryAdapter((ISidedInventory)inv, ForgeDirection.UNKNOWN);
            }
            Set items = SimpleServiceLocator.inventoryUtilFactory.getInventoryUtil(inv).getItems();
            l1.addAll(items);
            for (ItemIdentifier id : items) {
                l1.add(id.getIgnoringNBT());
            }
            boolean modulesInterestedInUndamged = false;
            for (int i = 0; i < this.getChassiSize(); ++i) {
                if (!this._module.getSubModule(moduleIndex).interestedInUndamagedID()) continue;
                modulesInterestedInUndamged = true;
                break;
            }
            if (!modulesInterestedInUndamged) break;
            for (ItemIdentifier id : items) {
                l1.add(id.getUndamaged());
            }
            break;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            Collection current;
            module = this._module.getSubModule(i);
            if (module == null || (current = module.getSpecificInterests()) == null) continue;
            l1.addAll(current);
        }
        return l1;
    }

    @Override
    public boolean hasGenericInterests() {
        if (this.getRawInventory() == null) {
            return false;
        }
        for (int i = 0; i < this.getChassiSize(); ++i) {
            ILogisticsModule x = this._module.getSubModule(i);
            if (x == null || !x.hasGenericInterests()) continue;
            return true;
        }
        return false;
    }
}

