/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.basic;

import buildcraft.api.core.Position;
import buildcraft.api.gates.ActionManager;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.utils.Utils;
import buildcraft.transport.EntityData;
import buildcraft.transport.Pipe;
import buildcraft.transport.PipeTransport;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.pipes.PipeLogic;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.DelayQueue;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.api.IRoutedPowerProvider;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.config.Configs;
import logisticspipes.gates.ActionDisableLogistics;
import logisticspipes.interfaces.ILogisticsGuiModule;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.interfaces.ISecurityProvider;
import logisticspipes.interfaces.IWatchingHandler;
import logisticspipes.interfaces.IWorldProvider;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.logic.BaseRoutingLogic;
import logisticspipes.logisticspipes.IAdjacentWorldAccess;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.logisticspipes.ITrackStatistics;
import logisticspipes.logisticspipes.PipeTransportLayer;
import logisticspipes.logisticspipes.RouteLayer;
import logisticspipes.logisticspipes.TransportLayer;
import logisticspipes.network.TilePacketWrapper;
import logisticspipes.network.packets.PacketPayload;
import logisticspipes.network.packets.PacketRoutingStats;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.buildcraft.BuildCraftProxy;
import logisticspipes.proxy.cc.interfaces.CCCommand;
import logisticspipes.proxy.cc.interfaces.CCType;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.RoutedEntityItem;
import logisticspipes.security.PermissionException;
import logisticspipes.security.SecuritySettings;
import logisticspipes.textures.Textures;
import logisticspipes.ticks.WorldTickHandler;
import logisticspipes.transport.PipeTransportLogistics;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.OrientationsUtil;
import logisticspipes.utils.Pair3;
import logisticspipes.utils.WorldUtil;
import net.minecraftforge.common.ForgeDirection;

@CCType(name="LogisticsPipes:Normal")
public abstract class CoreRoutedPipe
extends Pipe
implements IRequestItems,
IAdjacentWorldAccess,
ITrackStatistics,
IWorldProvider,
IWatchingHandler,
IRoutedPowerProvider {
    protected boolean stillNeedReplace = true;
    protected IRouter router;
    protected String routerId;
    protected Object routerIdLock = new Object();
    private static int pipecount = 0;
    protected int _delayOffset = 0;
    private boolean _textureBufferPowered;
    protected boolean _initialInit = true;
    private boolean enabled = true;
    protected RouteLayer _routeLayer;
    protected TransportLayer _transportLayer;
    private DelayQueue _inTransitToMe = new DelayQueue();
    private UpgradeManager upgradeManager = new UpgradeManager(this);
    public int stat_session_sent;
    public int stat_session_recieved;
    public int stat_session_relayed;
    public long stat_lifetime_sent;
    public long stat_lifetime_recieved;
    public long stat_lifetime_relayed;
    public int server_routing_table_size = 0;
    protected final LinkedList _sendQueue = new LinkedList();
    protected final ArrayList queuedDataForUnroutedItems = new ArrayList();
    public final List watchers = new ArrayList();
    protected List _cachedAdjacentInventories;
    public boolean globalIgnoreConnectionDisconnection = false;

    public CoreRoutedPipe(BaseRoutingLogic logic, int itemID) {
        this(new PipeTransportLogistics(), logic, itemID);
    }

    public CoreRoutedPipe(PipeTransportLogistics transport, BaseRoutingLogic logic, int itemID) {
        super((PipeTransport)transport, (PipeLogic)logic, itemID);
        transport.allowBouncing = true;
        this._delayOffset = ++pipecount % Configs.LOGISTICS_DETECTION_FREQUENCY;
    }

    public RouteLayer getRouteLayer() {
        if (this._routeLayer == null) {
            this._routeLayer = new RouteLayer(this.getRouter(), this.getTransportLayer());
        }
        return this._routeLayer;
    }

    public TransportLayer getTransportLayer() {
        if (this._transportLayer == null) {
            this._transportLayer = new PipeTransportLayer(this, this, this.getRouter());
        }
        return this._transportLayer;
    }

    public UpgradeManager getUpgradeManager() {
        return this.upgradeManager;
    }

    public PacketPayload getLogisticsNetworkPacket() {
        PacketPayload payload = new TilePacketWrapper(new Class[]{this.container.getClass(), this.transport.getClass(), this.logic.getClass()}).toPayload(this.xCoord, this.yCoord, this.zCoord, new Object[]{this.container, this.transport, this.logic});
        return payload;
    }

    public void queueRoutedItem(IRoutedItem routedItem, ForgeDirection from) {
        this._sendQueue.addLast(new Pair3(routedItem, from, (Object)ItemSendMode.Normal));
        this.sendQueueChanged(false);
    }

    public void queueRoutedItem(IRoutedItem routedItem, ForgeDirection from, ItemSendMode mode) {
        this._sendQueue.addLast(new Pair3(routedItem, from, (Object)mode));
        this.sendQueueChanged(false);
    }

    public int sendQueueChanged(boolean force) {
        return 0;
    }

    private void sendRoutedItem(IRoutedItem routedItem, ForgeDirection from) {
        CoreRoutedPipe pipe;
        Position p = new Position((double)((float)this.xCoord + 0.5f), (double)((float)this.yCoord + Utils.getPipeFloorOf((ur)routedItem.getItemStack())), (double)((float)this.zCoord + 0.5f), from);
        if (from == ForgeDirection.DOWN) {
            p.moveForwards((double)0.24f);
        } else if (from == ForgeDirection.UP) {
            p.moveForwards((double)0.74f);
        } else {
            p.moveForwards((double)0.49f);
        }
        routedItem.SetPosition(p.x, p.y, p.z);
        ((PipeTransportItems)this.transport).entityEntering((IPipedItem)routedItem.getEntityPassiveItem(), from.getOpposite());
        IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(routedItem.getDestination(), false);
        if (r != null && (pipe = r.getCachedPipe()) != null) {
            pipe.notifyOfSend(routedItem);
        }
        MainProxy.sendSpawnParticlePacket(7, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 2);
        ++this.stat_lifetime_sent;
        ++this.stat_session_sent;
        this.updateStats();
    }

    private void notifyOfSend(IRoutedItem routedItem) {
        this._inTransitToMe.add(routedItem);
    }

    public abstract ItemSendMode getItemSendMode();

    private boolean checkTileEntity(boolean force) {
        if ((this.worldObj.G() % 10L == 0L || force) && this.container.getClass() != BuildCraftProxy.logisticsTileGenericPipe) {
            any tile = this.worldObj.q(this.xCoord, this.yCoord, this.zCoord);
            if (tile != this.container) {
                LogisticsPipes.log.severe("LocalCodeError");
            }
            if (MainProxy.isClient(this.worldObj)) {
                WorldTickHandler.clientPipesToReplace.add(this.container);
            } else {
                WorldTickHandler.serverPipesToReplace.add(this.container);
            }
            return true;
        }
        return false;
    }

    public boolean sharesInventoryWith(CoreRoutedPipe other) {
        List others = other.getConnectedRawInventories();
        if (others == null || others.size() == 0) {
            return false;
        }
        for (la i : this.getConnectedRawInventories()) {
            if (!others.contains(i)) continue;
            return true;
        }
        return false;
    }

    protected List getConnectedRawInventories() {
        if (this._cachedAdjacentInventories != null) {
            return this._cachedAdjacentInventories;
        }
        WorldUtil worldUtil = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        LinkedList<la> adjacent = new LinkedList<la>();
        for (AdjacentTile tile : worldUtil.getAdjacentTileEntities(true)) {
            if (tile.tile instanceof TileGenericPipe || !(tile.tile instanceof la)) continue;
            adjacent.add(InventoryHelper.getInventory((la)tile.tile));
        }
        this._cachedAdjacentInventories = adjacent;
        return this._cachedAdjacentInventories;
    }

    public void enabledUpdateEntity() {
    }

    public void ignoreDisableUpdateEntity() {
    }

    public final void updateEntity() {
        if (this.checkTileEntity(this._initialInit)) {
            this.stillNeedReplace = true;
            return;
        }
        if (this.stillNeedReplace) {
            this.stillNeedReplace = false;
            this.worldObj.f(this.xCoord, this.yCoord, this.zCoord, this.worldObj.a(this.xCoord, this.yCoord, this.zCoord));
            for (Pair3 item : this._sendQueue) {
                ((IRoutedItem)item.getValue1()).getEntityPassiveItem().setWorld(this.worldObj);
            }
            this.getRouter();
            return;
        }
        while (this._inTransitToMe.poll() != null) {
        }
        this.getRouter().update(this.worldObj.G() % (long)Configs.LOGISTICS_DETECTION_FREQUENCY == (long)this._delayOffset || this._initialInit);
        this.getUpgradeManager().securityTick();
        super.updateEntity();
        this.ignoreDisableUpdateEntity();
        this._initialInit = false;
        if (!this._sendQueue.isEmpty()) {
            if (this.getItemSendMode() == ItemSendMode.Normal || !SimpleServiceLocator.buildCraftProxy.checkMaxItems()) {
                Pair3 itemToSend = (Pair3)this._sendQueue.getFirst();
                this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (ForgeDirection)itemToSend.getValue2());
                this._sendQueue.removeFirst();
                if (SimpleServiceLocator.buildCraftProxy.checkMaxItems()) {
                    for (int i = 0; i < 16 && !this._sendQueue.isEmpty() && ((Pair3)this._sendQueue.getFirst()).getValue3() == ItemSendMode.Fast; ++i) {
                        if (this._sendQueue.isEmpty()) continue;
                        itemToSend = (Pair3)this._sendQueue.getFirst();
                        this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (ForgeDirection)itemToSend.getValue2());
                        this._sendQueue.removeFirst();
                    }
                }
                this.sendQueueChanged(false);
            } else if (this.getItemSendMode() == ItemSendMode.Fast) {
                for (int i = 0; i < 16; ++i) {
                    if (this._sendQueue.isEmpty()) continue;
                    Pair3 itemToSend = (Pair3)this._sendQueue.getFirst();
                    this.sendRoutedItem((IRoutedItem)itemToSend.getValue1(), (ForgeDirection)itemToSend.getValue2());
                    this._sendQueue.removeFirst();
                }
                this.sendQueueChanged(false);
            } else {
                if (this.getItemSendMode() == null) {
                    throw new UnsupportedOperationException("getItemSendMode() can't return null. " + this.getClass().getName());
                }
                throw new UnsupportedOperationException("getItemSendMode() returned unhandled value. " + this.getItemSendMode().name() + " in " + this.getClass().getName());
            }
        }
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        this.checkTexturePowered();
        if (!this.isEnabled()) {
            return;
        }
        this.enabledUpdateEntity();
        if (this.getLogisticsModule() == null) {
            return;
        }
        this.getLogisticsModule().tick();
    }

    public void onBlockRemoval() {
        try {
            super.onBlockRemoval();
            if (this.logic instanceof BaseRoutingLogic) {
                ((BaseRoutingLogic)this.logic).destroy();
            }
            pipecount = Math.max(pipecount - 1, 0);
            if (this.transport != null && this.transport instanceof PipeTransportLogistics) {
                ((PipeTransportLogistics)this.transport).dropBuffer();
            }
            this.getUpgradeManager().dropUpgrades(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void invalidate() {
        super.invalidate();
        if (this.router != null) {
            this.router.destroy();
            this.router = null;
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.router != null) {
            this.router.clearPipeCache();
            this.router.clearInterests();
        }
    }

    public void checkTexturePowered() {
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return;
        }
        if (this.worldObj.G() % 10L != 0L) {
            return;
        }
        if (this.stillNeedReplace || this._initialInit || this.router == null) {
            return;
        }
        boolean flag = this.canUseEnergy(1);
        if (flag != this._textureBufferPowered) {
            this._textureBufferPowered = flag;
            this.refreshRender(false);
            MainProxy.sendSpawnParticlePacket(2, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 3);
        }
    }

    public abstract Textures.TextureType getCenterTexture();

    public String getTextureFile() {
        return "/logisticspipes/empty.png";
    }

    public final int getTextureIndex(ForgeDirection connection) {
        Textures.TextureType texture = this.getTextureType(connection);
        if (this._textureBufferPowered) {
            return texture.powered;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return texture.normal;
        }
        return texture.unpowered;
    }

    public Textures.TextureType getTextureType(ForgeDirection connection) {
        if (this.stillNeedReplace || this._initialInit) {
            return this.getCenterTexture();
        }
        if (connection == ForgeDirection.UNKNOWN) {
            return this.getCenterTexture();
        }
        if (this.router != null && this.getRouter(connection).isRoutedExit(connection)) {
            return this.getRoutedTexture(connection);
        }
        return this.getNonRoutedTexture(connection);
    }

    public Textures.TextureType getRoutedTexture(ForgeDirection connection) {
        return Textures.LOGISTICSPIPE_ROUTED_TEXTURE;
    }

    public Textures.TextureType getNonRoutedTexture(ForgeDirection connection) {
        return Textures.LOGISTICSPIPE_NOTROUTED_TEXTURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            if (this.routerId == null || this.routerId == "") {
                this.routerId = this.router != null ? this.router.getId().toString() : UUID.randomUUID().toString();
            }
        }
        nbttagcompound.a("routerId", this.routerId);
        nbttagcompound.a("stat_lifetime_sent", this.stat_lifetime_sent);
        nbttagcompound.a("stat_lifetime_recieved", this.stat_lifetime_recieved);
        nbttagcompound.a("stat_lifetime_relayed", this.stat_lifetime_relayed);
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().writeToNBT(nbttagcompound);
        }
        bq upgradeNBT = new bq();
        this.upgradeManager.writeToNBT(upgradeNBT);
        nbttagcompound.a("upgradeManager", upgradeNBT);
        by sendqueue = new by();
        for (Pair3 p : this._sendQueue) {
            bq tagentry = new bq();
            bq tagentityitem = new bq();
            ((IRoutedItem)p.getValue1()).getEntityPassiveItem().writeToNBT(tagentityitem);
            tagentry.a("entityitem", tagentityitem);
            tagentry.a("from", (byte)((ForgeDirection)p.getValue2()).ordinal());
            tagentry.a("mode", (byte)((ItemSendMode)((Object)p.getValue3())).ordinal());
            sendqueue.a((cd)tagentry);
        }
        nbttagcompound.a("sendqueue", (cd)sendqueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        Object object = this.routerIdLock;
        synchronized (object) {
            this.routerId = nbttagcompound.i("routerId");
        }
        this.stat_lifetime_sent = nbttagcompound.f("stat_lifetime_sent");
        this.stat_lifetime_recieved = nbttagcompound.f("stat_lifetime_recieved");
        this.stat_lifetime_relayed = nbttagcompound.f("stat_lifetime_relayed");
        if (this.getLogisticsModule() != null) {
            this.getLogisticsModule().readFromNBT(nbttagcompound);
        }
        this.upgradeManager.readFromNBT(nbttagcompound.l("upgradeManager"));
        this._sendQueue.clear();
        by sendqueue = nbttagcompound.m("sendqueue");
        for (int i = 0; i < sendqueue.c(); ++i) {
            bq tagentry = (bq)sendqueue.b(i);
            bq tagentityitem = tagentry.l("entityitem");
            EntityPassiveItem entity = new EntityPassiveItem(null);
            entity.readFromNBT(tagentityitem);
            IRoutedItem routeditem = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(null, (IPipedItem)entity);
            ForgeDirection from = ForgeDirection.values()[tagentry.c("from")];
            ItemSendMode mode = ItemSendMode.values()[tagentry.c("mode")];
            this._sendQueue.add(new Pair3(routeditem, from, (Object)mode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRouter getRouter() {
        if (this.stillNeedReplace) {
            System.out.println("Hey, don't get routers for pipes that aren't ready");
            new Throwable().printStackTrace();
        }
        if (this.router == null) {
            Object object = this.routerIdLock;
            synchronized (object) {
                UUID routerIntId = null;
                if (this.routerId != null && !this.routerId.isEmpty()) {
                    routerIntId = UUID.fromString(this.routerId);
                }
                this.router = SimpleServiceLocator.routerManager.getOrCreateRouter(routerIntId, MainProxy.getDimensionForWorld(this.worldObj), this.xCoord, this.yCoord, this.zCoord, false);
            }
        }
        return this.router;
    }

    public IRouter getRouter(ForgeDirection dir) {
        return this.getRouter();
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void onNeighborBlockChange(int blockId) {
        super.onNeighborBlockChange(blockId);
        this.clearCache();
        if (!this.stillNeedReplace && MainProxy.isServer(this.worldObj)) {
            this.onNeighborBlockChange_Logistics();
        }
    }

    public void onNeighborBlockChange_Logistics() {
    }

    public void onBlockPlaced() {
        super.onBlockPlaced();
    }

    public abstract ILogisticsModule getLogisticsModule();

    public final boolean blockActivated(yc world, int i, int j, int k, qx entityplayer) {
        LogisticsSecurityTileEntity station;
        SecuritySettings settings = null;
        if (MainProxy.isServer(world) && (station = SimpleServiceLocator.securityStationManager.getStation(this.getUpgradeManager().getSecurityID())) != null) {
            settings = station.getSecuritySettingsForPlayer(entityplayer, true);
        }
        if (this.handleClick(world, i, j, k, entityplayer, settings)) {
            return true;
        }
        if (SimpleServiceLocator.buildCraftProxy.isWrenchEquipped(entityplayer) && !entityplayer.ah() && this.wrenchClicked(world, i, j, k, entityplayer, settings)) {
            return true;
        }
        if (SimpleServiceLocator.buildCraftProxy.isUpgradeManagerEquipped(entityplayer) && !entityplayer.ah()) {
            if (MainProxy.isServer(world)) {
                if (settings == null || settings.openUpgrades) {
                    this.getUpgradeManager().openGui(entityplayer, this);
                } else {
                    entityplayer.a("Permission denied");
                }
            }
            return true;
        }
        if (!entityplayer.ah() && this.getUpgradeManager().tryIserting(world, entityplayer)) {
            return true;
        }
        return super.blockActivated(world, i, j, k, entityplayer);
    }

    protected boolean handleClick(yc world, int i, int j, int k, qx entityplayer, SecuritySettings settings) {
        return false;
    }

    protected boolean wrenchClicked(yc world, int i, int j, int k, qx entityplayer, SecuritySettings settings) {
        if (this.getLogisticsModule() != null && this.getLogisticsModule() instanceof ILogisticsGuiModule) {
            if (MainProxy.isServer(world)) {
                if (settings == null || settings.openGui) {
                    entityplayer.openGui((Object)LogisticsPipes.instance, ((ILogisticsGuiModule)this.getLogisticsModule()).getGuiHandlerID(), world, this.xCoord, this.yCoord, this.zCoord);
                } else {
                    entityplayer.a("Permission denied");
                }
            }
            return true;
        }
        return false;
    }

    protected void clearCache() {
        this._cachedAdjacentInventories = null;
    }

    public void refreshRender(boolean spawnPart) {
        this.container.scheduleRenderUpdate();
        if (spawnPart) {
            MainProxy.sendSpawnParticlePacket(4, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 3);
        }
    }

    public void refreshConnectionAndRender(boolean spawnPart) {
        this.clearCache();
        this.container.scheduleNeighborChange();
        if (spawnPart) {
            MainProxy.sendSpawnParticlePacket(4, this.xCoord, this.yCoord, this.zCoord, this.worldObj, 3);
        }
    }

    @Override
    public LinkedList getConnectedEntities() {
        WorldUtil world = new WorldUtil(this.worldObj, this.xCoord, this.yCoord, this.zCoord);
        LinkedList adjacent = world.getAdjacentTileEntities(true);
        Iterator iterator = adjacent.iterator();
        while (iterator.hasNext()) {
            AdjacentTile tile = (AdjacentTile)iterator.next();
            if (SimpleServiceLocator.buildCraftProxy.checkPipesConnections((any)this.container, tile.tile, tile.orientation)) continue;
            iterator.remove();
        }
        return adjacent;
    }

    @Override
    public int getRandomInt(int maxSize) {
        return this.worldObj.t.nextInt(maxSize);
    }

    @Override
    public void recievedItem(int count) {
        this.stat_session_recieved += count;
        this.stat_lifetime_recieved += (long)count;
        this.updateStats();
    }

    @Override
    public void relayedItem(int count) {
        this.stat_session_relayed += count;
        this.stat_lifetime_relayed += (long)count;
        this.updateStats();
    }

    @Override
    public yc getWorld() {
        return this.worldObj;
    }

    @Override
    public void playerStartWatching(qx player, int mode) {
        if (mode == 0) {
            this.watchers.add(player);
            MainProxy.sendPacketToPlayer(new PacketRoutingStats(74, this).getPacket(), (Player)player);
        }
    }

    @Override
    public void playerStopWatching(qx player, int mode) {
        if (mode == 0) {
            this.watchers.remove(player);
        }
    }

    public void updateStats() {
        if (this.watchers.size() > 0) {
            MainProxy.sendToPlayerList(new PacketRoutingStats(74, this).getPacket(), this.watchers);
        }
    }

    @Override
    public void itemCouldNotBeSend(ItemIdentifierStack item) {
        if (this.logic instanceof IRequireReliableTransport) {
            ((IRequireReliableTransport)this.logic).itemLost(item);
        }
    }

    public boolean isLockedExit(ForgeDirection orientation) {
        return false;
    }

    public boolean logisitcsIsPipeConnected(any tile) {
        return false;
    }

    public boolean disconnectPipe(any tile, ForgeDirection dir) {
        return false;
    }

    public final boolean isPipeConnected(any tile, ForgeDirection dir) {
        return this.isPipeConnected(tile, dir, false);
    }

    public final boolean isPipeConnected(any tile, ForgeDirection dir, boolean ignoreSystemDisconnection) {
        ForgeDirection side = OrientationsUtil.getOrientationOfTilewithPipe((PipeTransportItems)this.transport, tile);
        if (this.getUpgradeManager().isSideDisconnected(side)) {
            return false;
        }
        if (!this.stillNeedReplace && this.getRouter().isSideDisconneceted(side) && !ignoreSystemDisconnection && !this.globalIgnoreConnectionDisconnection) {
            return false;
        }
        return (super.isPipeConnected(tile, dir) || this.logisitcsIsPipeConnected(tile)) && !this.disconnectPipe(tile, dir);
    }

    public void connectionUpdate() {
        if (this.container != null && !this.stillNeedReplace) {
            this.container.scheduleNeighborChange();
            this.worldObj.f(this.xCoord, this.yCoord, this.zCoord, this.worldObj.a(this.xCoord, this.yCoord, this.zCoord));
        }
    }

    public UUID getSecurityID() {
        return this.getUpgradeManager().getSecurityID();
    }

    public void insetSecurityID(UUID id) {
        this.getUpgradeManager().insetSecurityID(id);
    }

    public List getRoutedPowerProviders() {
        if (MainProxy.isClient(this.worldObj)) {
            return null;
        }
        if (this.stillNeedReplace) {
            return null;
        }
        return this.getRouter().getPowerProvider();
    }

    @Override
    public boolean useEnergy(int amount) {
        return this.useEnergy(amount, null);
    }

    @Override
    public boolean canUseEnergy(int amount) {
        return this.canUseEnergy(amount, null);
    }

    @Override
    public boolean canUseEnergy(int amount, List providersToIgnore) {
        if (MainProxy.isClient(this.worldObj)) {
            return false;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return true;
        }
        if (amount == 0) {
            return true;
        }
        if (providersToIgnore != null && providersToIgnore.contains(this)) {
            return false;
        }
        List list = this.getRoutedPowerProviders();
        if (list == null) {
            return false;
        }
        for (ILogisticsPowerProvider provider : list) {
            if (!provider.canUseEnergy(amount, providersToIgnore)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean useEnergy(int amount, List providersToIgnore) {
        if (MainProxy.isClient(this.worldObj)) {
            return false;
        }
        if (Configs.LOGISTICS_POWER_USAGE_DISABLED) {
            return true;
        }
        if (amount == 0) {
            return true;
        }
        if (providersToIgnore == null) {
            providersToIgnore = new ArrayList<CoreRoutedPipe>();
        }
        if (providersToIgnore.contains(this)) {
            return false;
        }
        providersToIgnore.add(this);
        List list = this.getRoutedPowerProviders();
        if (list == null) {
            return false;
        }
        for (ILogisticsPowerProvider provider : list) {
            if (!provider.canUseEnergy(amount, providersToIgnore)) continue;
            provider.useEnergy(amount, providersToIgnore);
            int particlecount = amount;
            if (particlecount > 10) {
                particlecount = 10;
            }
            MainProxy.sendSpawnParticlePacket(5, this.xCoord, this.yCoord, this.zCoord, this.worldObj, particlecount);
            return true;
        }
        return false;
    }

    public void queueEvent(String event, Object[] arguments) {
        if (this.container instanceof LogisticsTileGenericPipe) {
            ((LogisticsTileGenericPipe)this.container).queueEvent(event, arguments);
        }
    }

    public boolean stillNeedReplace() {
        return this.stillNeedReplace;
    }

    @Override
    public int compareTo(IRequestItems other) {
        return this.getID() - other.getID();
    }

    @Override
    public int getID() {
        return this.itemID;
    }

    public Set getSpecificInterests() {
        return null;
    }

    public boolean hasGenericInterests() {
        return false;
    }

    public ISecurityProvider getSecurityProvider() {
        return SimpleServiceLocator.securityStationManager.getStation(this.getUpgradeManager().getSecurityID());
    }

    public void checkCCAccess() throws PermissionException {
        ISecurityProvider sec = this.getSecurityProvider();
        if (sec != null && !sec.getAllowCC()) {
            throw new PermissionException();
        }
    }

    public void queueUnroutedItemInformation(EntityData data) {
        if (data.item != null && data.item.getItemStack() != null) {
            data.item.setItemStack(data.item.getItemStack().l());
            this.queuedDataForUnroutedItems.add(data.item);
        }
    }

    public IPipedItem getQueuedForItemStack(ur stack) {
        for (IPipedItem item : this.queuedDataForUnroutedItems) {
            if (!ItemIdentifierStack.GetFromStack(item.getItemStack()).equals(ItemIdentifierStack.GetFromStack(stack))) continue;
            this.queuedDataForUnroutedItems.remove(item);
            return item;
        }
        return null;
    }

    public LinkedList getActions() {
        LinkedList actions = super.getActions();
        actions.add(BuildCraftProxy.LogisticsDisableAction);
        return actions;
    }

    protected void actionsActivated(HashMap actions) {
        super.actionsActivated(actions);
        this.setEnabled(true);
        for (Map.Entry i : actions.entrySet()) {
            if (!((Boolean)i.getValue()).booleanValue() || !(ActionManager.actions[(Integer)i.getKey()] instanceof ActionDisableLogistics)) continue;
            this.setEnabled(false);
        }
    }

    @CCCommand(description="Returns the Router UUID as an integer; all pipes have a unique ID")
    public int getRouterId() {
        return this.getRouter().getSimpleID();
    }

    @CCCommand(description="Sets the TurtleConnect flag for this Turtle on this LogisticsPipe")
    public void setTurtleConnect(Boolean flag) {
        if (this.container instanceof LogisticsTileGenericPipe) {
            ((LogisticsTileGenericPipe)this.container).setTurtrleConnect(flag);
        }
    }

    @CCCommand(description="Returns the TurtleConnect flag for this Turtle on this LogisticsPipe")
    public boolean getTurtleConnect() {
        if (this.container instanceof LogisticsTileGenericPipe) {
            return ((LogisticsTileGenericPipe)this.container).getTurtrleConnect();
        }
        return false;
    }

    @CCCommand(description="Returns the Item Id for given ItemIdentifier Id.")
    public int getItemID(Double itemId) throws Exception {
        ItemIdentifier item = ItemIdentifier.getForId((int)Math.floor(itemId));
        if (item == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        return item.itemID;
    }

    @CCCommand(description="Returns the Item damage for the given ItemIdentifier Id.")
    public int getItemDamage(Double itemId) throws Exception {
        ItemIdentifier itemd = ItemIdentifier.getForId((int)Math.floor(itemId));
        if (itemd == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        return itemd.itemDamage;
    }

    @CCCommand(description="Returns the NBTTagCompound for the given ItemIdentifier Id.")
    public Map getNBTTagCompound(Double itemId) throws Exception {
        ItemIdentifier itemn = ItemIdentifier.getForId((int)Math.floor(itemId));
        if (itemn == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        return itemn.getNBTTagCompoundAsMap();
    }

    @CCCommand(description="Returns the ItemIdentifier Id for the given Item id and damage.")
    public int getItemIdentifierIDFor(Double itemID, Double itemDamage) {
        return ItemIdentifier.get((int)Math.floor(itemID), (int)Math.floor(itemDamage), null).getId();
    }

    @CCCommand(description="Returns the name of the item for the given ItemIdentifier Id.")
    public String getItemName(Double itemId) throws Exception {
        ItemIdentifier itemd = ItemIdentifier.getForId((int)Math.floor(itemId));
        if (itemd == null) {
            throw new Exception("Invalid ItemIdentifierID");
        }
        return itemd.getFriendlyNameCC();
    }

    public double getLoadFactor() {
        return 0.0;
    }

    public void notifyOfItemArival(RoutedEntityItem routedEntityItem) {
        this._inTransitToMe.remove(routedEntityItem);
    }

    public int countOnRoute(ItemIdentifier it) {
        int count = 0;
        for (IRoutedItem next : this._inTransitToMe) {
            if (next.getIDStack().getItem() != it) continue;
            count += next.getIDStack().stackSize;
        }
        return count;
    }

    public static enum ItemSendMode {
        Normal,
        Fast;

    }
}

