/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.cc;

import dan200.computer.api.IComputerAccess;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.proxy.interfaces.ICCProxy;
import logisticspipes.utils.AdjacentTile;
import logisticspipes.utils.WorldUtil;
import net.minecraftforge.common.ForgeDirection;

public class CCProxy
implements ICCProxy {
    private Field Computer_m_computer;
    private Field Net_m_computer;
    private Field m_apis;
    private Field m_peripherals;
    private Class computerClass;
    private Class peripheralAPIClass;
    private Field target;
    protected boolean valid = false;

    public CCProxy() {
        try {
            this.computerClass = Class.forName("dan200.computer.shared.TileEntityComputer");
            this.Computer_m_computer = this.computerClass.getDeclaredField("m_computer");
            this.Computer_m_computer.setAccessible(true);
            this.Net_m_computer = Class.forName("dan200.computer.shared.NetworkedComputerHelper").getDeclaredField("m_computer");
            this.Net_m_computer.setAccessible(true);
            this.m_apis = Class.forName("dan200.computer.core.Computer").getDeclaredField("m_apis");
            this.m_apis.setAccessible(true);
            this.peripheralAPIClass = Class.forName("dan200.computer.core.apis.PeripheralAPI");
            this.m_peripherals = this.peripheralAPIClass.getDeclaredField("m_peripherals");
            this.m_peripherals.setAccessible(true);
            this.target = Thread.class.getDeclaredField("target");
            this.target.setAccessible(true);
            this.valid = true;
        }
        catch (Exception e) {
            if (LogisticsPipes.DEBUG) {
                e.printStackTrace();
            }
            this.valid = false;
        }
    }

    @Override
    public boolean isTurtle(any tile) {
        return false;
    }

    @Override
    public boolean isComputer(any tile) {
        if (!this.valid) {
            return false;
        }
        return this.computerClass.isAssignableFrom(tile.getClass());
    }

    @Override
    public boolean isCC() {
        return this.valid;
    }

    protected Object get_local_tile_m_computer(any tile) throws IllegalArgumentException, IllegalAccessException {
        if (this.computerClass.isAssignableFrom(tile.getClass())) {
            return this.Computer_m_computer.get(tile);
        }
        return null;
    }

    @Override
    public ForgeDirection getOrientation(Object cObject, any pipe) {
        if (!this.valid) {
            return ForgeDirection.UNKNOWN;
        }
        if (!(cObject instanceof IComputerAccess)) {
            return ForgeDirection.UNKNOWN;
        }
        IComputerAccess computer = (IComputerAccess)cObject;
        WorldUtil world = new WorldUtil(pipe.k, pipe.l, pipe.m, pipe.n);
        LinkedList adjacent = world.getAdjacentTileEntities(false);
        for (AdjacentTile aTile : adjacent) {
            try {
                Object local_tile_m_computer = this.get_local_tile_m_computer(aTile.tile);
                if (local_tile_m_computer == null) continue;
                Object local_net_m_omputer = this.Net_m_computer.get(local_tile_m_computer);
                ArrayList local_m_apis = (ArrayList)this.m_apis.get(local_net_m_omputer);
                for (Object api : local_m_apis) {
                    Object[] local_m_peripherals;
                    if (!this.peripheralAPIClass.isAssignableFrom(api.getClass())) continue;
                    for (Object computeraccess : local_m_peripherals = (Object[])this.m_peripherals.get(api)) {
                        if (computeraccess != computer) continue;
                        return aTile.orientation;
                    }
                }
            }
            catch (IllegalArgumentException e) {
                if (!LogisticsPipes.DEBUG) continue;
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                if (!LogisticsPipes.DEBUG) continue;
                e.printStackTrace();
            }
            catch (ClassCastException e) {
                if (!LogisticsPipes.DEBUG) continue;
                e.printStackTrace();
            }
        }
        return ForgeDirection.UNKNOWN;
    }

    private Runnable getTaget(Thread thread) {
        block6: {
            try {
                return (Runnable)this.target.get(thread);
            }
            catch (SecurityException e) {
                if (LogisticsPipes.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (IllegalArgumentException e) {
                if (LogisticsPipes.DEBUG) {
                    e.printStackTrace();
                }
            }
            catch (IllegalAccessException e) {
                if (!LogisticsPipes.DEBUG) break block6;
                e.printStackTrace();
            }
        }
        return null;
    }

    @Override
    public boolean isLuaThread(Thread thread) {
        Runnable tar = this.getTaget(thread);
        if (tar == null) {
            return false;
        }
        return tar.getClass().getName().contains("org.luaj.vm2.LuaThread");
    }
}

