/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.recipeproviders;

import java.lang.reflect.Method;
import logisticspipes.proxy.interfaces.ICraftingRecipeProvider;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.SimpleInventory;

public class RollingMachine
implements ICraftingRecipeProvider {
    private static Class tileRollingMachineClass;
    private static Method getCraftMatrixMethod;

    public static boolean load() {
        try {
            tileRollingMachineClass = Class.forName("railcraft.common.blocks.machine.alpha.TileRollingMachine");
            getCraftMatrixMethod = tileRollingMachineClass.getMethod("getCraftMatrix", new Class[0]);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("Necessary classes from Railcraft were not found");
            return false;
        }
        return true;
    }

    @Override
    public boolean canOpenGui(any tile) {
        return tileRollingMachineClass.isInstance(tile);
    }

    private ur getResult(ry inventorycrafting, yc world) {
        if (inventorycrafting == null) {
            return null;
        }
        try {
            Class<?> c = Class.forName("railcraft.common.util.crafting.RollingMachineCraftingManager");
            Method inst = c.getMethod("getInstance", new Class[0]);
            Object instance = inst.invoke(null, new Object[0]);
            Method findMatchingRecipe = c.getMethod("findMatchingRecipe", ry.class, yc.class);
            return (ur)findMatchingRecipe.invoke(instance, inventorycrafting, world);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("getResult fail");
            return null;
        }
    }

    private ry getCraftMatrix(any tile) {
        try {
            return (ry)getCraftMatrixMethod.invoke((Object)tile, new Object[0]);
        }
        catch (Exception ex) {
            ModLoader.getLogger().fine("getCraftMatrix fail");
            return null;
        }
    }

    @Override
    public boolean importRecipe(any tile, SimpleInventory inventory) {
        int i;
        if (!tileRollingMachineClass.isInstance(tile)) {
            return false;
        }
        ry craftMatrix = this.getCraftMatrix(tile);
        if (craftMatrix == null) {
            return false;
        }
        ur result = this.getResult(craftMatrix, tile.k);
        if (result == null) {
            return false;
        }
        inventory.a(9, result);
        for (i = 0; i < craftMatrix.k_() && i < inventory.k_() - 1; ++i) {
            ur newStack = craftMatrix.a(i) == null ? null : craftMatrix.a(i).l();
            inventory.a(i, newStack);
        }
        for (i = 0; i < inventory.k_() - 1; ++i) {
            ur stackInSlot = inventory.a(i);
            if (stackInSlot == null) continue;
            ItemIdentifier itemInSlot = ItemIdentifier.get(stackInSlot);
            for (int j = i + 1; j < inventory.k_() - 1; ++j) {
                ur stackInOtherSlot = inventory.a(j);
                if (stackInOtherSlot == null || itemInSlot != ItemIdentifier.get(stackInOtherSlot)) continue;
                stackInSlot.a += stackInOtherSlot.a;
                inventory.a(j, null);
            }
        }
        block3: for (i = 0; i < inventory.k_() - 1; ++i) {
            if (inventory.a(i) != null) continue;
            for (int j = i + 1; j < inventory.k_() - 1; ++j) {
                if (inventory.a(j) == null) continue;
                inventory.a(i, inventory.a(j));
                inventory.a(j, null);
                continue block3;
            }
        }
        return true;
    }
}

