/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.proxy.specialinventoryhandler;

import appeng.api.me.tiles.ITileInterfaceApi;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.proxy.specialinventoryhandler.SpecialInventoryHandler;
import logisticspipes.utils.ItemIdentifier;
import net.minecraftforge.common.ForgeDirection;

public class AEInterfaceInventoryHandler
extends SpecialInventoryHandler {
    private final ITileInterfaceApi _tile;
    private final boolean _hideOnePerStack;

    private AEInterfaceInventoryHandler(any tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._tile = (ITileInterfaceApi)tile;
        this._hideOnePerStack = hideOnePerStack || hideOne;
    }

    public AEInterfaceInventoryHandler() {
        this._tile = null;
        this._hideOnePerStack = false;
    }

    @Override
    public boolean init() {
        return true;
    }

    @Override
    public boolean isType(any tile) {
        return tile instanceof ITileInterfaceApi;
    }

    @Override
    public SpecialInventoryHandler getUtilForTile(any tile, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        return new AEInterfaceInventoryHandler(tile, hideOnePerStack, hideOne, cropStart, cropEnd);
    }

    @Override
    public HashMap getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> result = new HashMap<ItemIdentifier, Integer>();
        for (ur items : this._tile.apiGetNetworkContents()) {
            ItemIdentifier ident = ItemIdentifier.get(items);
            Integer count = (Integer)result.get(ident);
            if (count != null) {
                result.put(ident, count + items.a - (this._hideOnePerStack ? 1 : 0));
                continue;
            }
            result.put(ident, items.a - (this._hideOnePerStack ? 1 : 0));
        }
        return result;
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> result = new TreeSet<ItemIdentifier>();
        for (ur items : this._tile.apiGetNetworkContents()) {
            ItemIdentifier ident = ItemIdentifier.get(items);
            result.add(ident);
        }
        return result;
    }

    @Override
    public ur getSingleItem(ItemIdentifier item) {
        return this._tile.apiExtractNetworkItem(item.makeNormalStack(1), true);
    }

    @Override
    public boolean containsItem(ItemIdentifier item) {
        ur result = this._tile.apiExtractNetworkItem(item.unsafeMakeNormalStack(1), false);
        return result != null;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier item) {
        for (ur items : this._tile.apiGetNetworkContents()) {
            ItemIdentifier ident = ItemIdentifier.getUndamaged(items);
            if (ident != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, item.getMaxStackSize());
    }

    @Override
    public int roomForItem(ItemIdentifier item, int count) {
        return this._tile.apiCurrentAvailableSpace(item.unsafeMakeNormalStack(1), count);
    }

    public ur add(ur stack, ForgeDirection from, boolean doAdd) {
        ur overflow;
        ur st = stack.l();
        ur tst = stack.l();
        if (tst.d != null && tst.d.e().equals("")) {
            tst.d.p("tag");
        }
        if ((overflow = this._tile.apiAddNetworkItem(tst, doAdd)) != null) {
            st.a -= overflow.a;
        }
        return st;
    }
}

