/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import cpw.mods.fml.client.FMLClientHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedList;
import logisticspipes.LogisticsPipes;
import logisticspipes.config.Configs;
import logisticspipes.hud.HUDConfig;
import logisticspipes.interfaces.IHeadUpDisplayBlockRendererProvider;
import logisticspipes.interfaces.IHeadUpDisplayRendererProvider;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.MathVector;
import logisticspipes.utils.Pair;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class LogisticsHUDRenderer {
    private LinkedList list = new LinkedList();
    private double lastXPos = 0.0;
    private double lastYPos = 0.0;
    private double lastZPos = 0.0;
    private ArrayList providers = new ArrayList();
    private static LogisticsHUDRenderer renderer = null;

    public void add(IHeadUpDisplayBlockRendererProvider provider) {
        IHeadUpDisplayBlockRendererProvider toRemove = null;
        for (IHeadUpDisplayBlockRendererProvider listedProvider : this.providers) {
            if (listedProvider.getX() != provider.getX() || listedProvider.getY() != provider.getY() || listedProvider.getZ() != provider.getZ()) continue;
            toRemove = listedProvider;
            break;
        }
        if (toRemove != null) {
            this.providers.remove(toRemove);
        }
        this.providers.add(provider);
    }

    public void remove(IHeadUpDisplayBlockRendererProvider provider) {
        this.providers.remove(provider);
    }

    public void clear() {
        this.providers.clear();
        LogisticsHUDRenderer.instance().clearList(false);
    }

    private void clearList(boolean flag) {
        if (flag) {
            for (IHeadUpDisplayRendererProvider renderer : this.list) {
                renderer.stopWaitching();
            }
        }
        this.list.clear();
    }

    private void refreshList(double x, double y2, double z) {
        double dis;
        ArrayList<Pair> newList = new ArrayList<Pair>();
        for (IRouter router : SimpleServiceLocator.routerManager.getRouters()) {
            CoreRoutedPipe pipe;
            if (router == null || !((pipe = router.getPipe()) instanceof IHeadUpDisplayRendererProvider) || MainProxy.getDimensionForWorld(pipe.worldObj) != MainProxy.getDimensionForWorld((yc)FMLClientHandler.instance().getClient().e) || !((dis = Math.hypot((double)pipe.xCoord - x + 0.5, Math.hypot((double)pipe.yCoord - y2 + 0.5, (double)pipe.zCoord - z + 0.5))) < (double)Configs.LOGISTICS_HUD_RENDER_DISTANCE) || !(dis > 0.75)) continue;
            newList.add(new Pair(dis, (IHeadUpDisplayRendererProvider)((Object)pipe)));
            if (this.list.contains(pipe)) continue;
            ((IHeadUpDisplayRendererProvider)((Object)pipe)).startWaitching();
        }
        ArrayList<IHeadUpDisplayBlockRendererProvider> remove = new ArrayList<IHeadUpDisplayBlockRendererProvider>();
        for (IHeadUpDisplayBlockRendererProvider provider : this.providers) {
            if (MainProxy.getDimensionForWorld(provider.getWorld()) != MainProxy.getDimensionForWorld((yc)FMLClientHandler.instance().getClient().e)) continue;
            dis = Math.hypot((double)provider.getX() - x + 0.5, Math.hypot((double)provider.getY() - y2 + 0.5, (double)provider.getZ() - z + 0.5));
            if (dis < (double)Configs.LOGISTICS_HUD_RENDER_DISTANCE && dis > 0.75 && !provider.r() && provider.isExistend()) {
                newList.add(new Pair(dis, provider));
                if (this.list.contains(provider)) continue;
                provider.startWaitching();
                continue;
            }
            if (!provider.r() && provider.isExistend()) continue;
            remove.add(provider);
        }
        for (IHeadUpDisplayBlockRendererProvider provider : remove) {
            this.providers.remove(provider);
        }
        if (newList.size() < 1) {
            this.clearList(false);
            return;
        }
        Object[] sorter = newList.toArray();
        Arrays.sort(sorter, new Comparator(){

            public int compare(Object o1, Object o2) {
                if ((Double)((Pair)o1).getValue1() < (Double)((Pair)o2).getValue1()) {
                    return -1;
                }
                if ((Double)((Pair)o1).getValue1() > (Double)((Pair)o2).getValue1()) {
                    return 1;
                }
                return 0;
            }
        });
        for (IHeadUpDisplayRendererProvider part : this.list) {
            boolean contains = false;
            for (Pair inpart : newList) {
                if (!((IHeadUpDisplayRendererProvider)inpart.getValue2()).equals(part)) continue;
                contains = true;
                break;
            }
            if (contains) continue;
            part.stopWaitching();
        }
        this.clearList(false);
        for (Object part : sorter) {
            this.list.addLast(((Pair)part).getValue2());
        }
    }

    private boolean playerWearsHUD() {
        return FMLClientHandler.instance().getClient().g != null && FMLClientHandler.instance().getClient().g.bJ != null && FMLClientHandler.instance().getClient().g.bJ.b != null && FMLClientHandler.instance().getClient().g.bJ.b[3] != null && FMLClientHandler.instance().getClient().g.bJ.b[3].c == LogisticsPipes.LogisticsHUDArmor.cj;
    }

    public void renderPlayerDisplay(long renderTicks) {
    }

    public void renderWorldRelative(long renderTicks, float partialTick) {
        if (!this.displayRenderer()) {
            return;
        }
        Minecraft mc = FMLClientHandler.instance().getClient();
        ays player = mc.g;
        if (this.list.size() == 0 || Math.hypot(this.lastXPos - player.t, Math.hypot(this.lastYPos - player.u, this.lastZPos - player.v)) > 0.5 || renderTicks % 10L == 0L && (this.lastXPos != player.t || this.lastYPos != player.u + (double)player.e() || this.lastZPos != player.v) || renderTicks % 600L == 0L) {
            this.refreshList(player.t, player.u, player.v);
            this.lastXPos = player.t;
            this.lastYPos = player.u + (double)player.e();
            this.lastZPos = player.v;
        }
        boolean cursorHandled = false;
        HUDConfig config = new HUDConfig(FMLClientHandler.instance().getClient().g.bJ.b[3]);
        for (IHeadUpDisplayRendererProvider renderer : this.list) {
            if (renderer.getRenderer() == null || !renderer.getRenderer().display(config)) continue;
            GL11.glPushMatrix();
            if (!cursorHandled) {
                double z;
                double y2;
                double x = (double)renderer.getX() + 0.5 - player.t;
                if (Math.hypot(x, Math.hypot(y2 = (double)renderer.getY() + 0.5 - player.u, z = (double)renderer.getZ() + 0.5 - player.v)) < 0.75 || renderer instanceof IHeadUpDisplayBlockRendererProvider && (((IHeadUpDisplayBlockRendererProvider)renderer).r() || !((IHeadUpDisplayBlockRendererProvider)renderer).isExistend())) {
                    this.refreshList(player.t, player.u, player.v);
                    GL11.glPopMatrix();
                    break;
                }
                cursorHandled = this.handleCursor(renderer);
            }
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            this.displayOneView(renderer, config, partialTick);
            GL11.glPopMatrix();
        }
    }

    private void displayOneView(IHeadUpDisplayRendererProvider renderer, HUDConfig config, float partialTick) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        ays player = mc.g;
        double x = (double)renderer.getX() + 0.5 - player.q - (player.t - player.q) * (double)partialTick;
        double y2 = (double)renderer.getY() + 0.5 - player.r - (player.u - player.r) * (double)partialTick;
        double z = (double)renderer.getZ() + 0.5 - player.s - (player.v - player.s) * (double)partialTick;
        GL11.glTranslatef((float)((float)x), (float)((float)y2), (float)((float)z));
        GL11.glRotatef((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glRotatef((float)(this.getAngle(z, x) + 90.0f), (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)(-1.0f * this.getAngle(Math.hypot(x, z), y2) + 180.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glTranslatef((float)0.0f, (float)0.0f, (float)-0.4f);
        GL11.glScalef((float)0.01f, (float)0.01f, (float)1.0f);
        float light = mc.e.m(renderer.getX(), renderer.getY(), renderer.getZ());
        boolean dark = light < 11.0f;
        renderer.getRenderer().renderHeadUpDisplay(Math.hypot(x, Math.hypot(y2, z)), dark, mc, config);
    }

    private float getAngle(double x, double y2) {
        return (float)(Math.atan2(x, y2) * 360.0 / (Math.PI * 2));
    }

    public double up(double input) {
        input %= 360.0;
        while (input < 0.0 && !Double.isNaN(input) && !Double.isInfinite(input)) {
            input += 360.0;
        }
        return input;
    }

    private boolean handleCursor(IHeadUpDisplayRendererProvider renderer) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        ays player = mc.g;
        MathVector playerView = MathVector.getFromAngles((double)((270.0f - player.z) / 360.0f * -2.0f) * Math.PI, (double)(player.A / 360.0f * -2.0f) * Math.PI);
        MathVector playerPos = new MathVector();
        playerPos.X = player.t;
        playerPos.Y = player.u;
        playerPos.Z = player.v;
        MathVector panelPos = new MathVector();
        panelPos.X = (double)renderer.getX() + 0.5;
        panelPos.Y = (double)renderer.getY() + 0.5;
        panelPos.Z = (double)renderer.getZ() + 0.5;
        MathVector panelView = new MathVector();
        panelView.X = playerPos.X - panelPos.X;
        panelView.Y = playerPos.Y - panelPos.Y;
        panelView.Z = playerPos.Z - panelPos.Z;
        panelPos.add(panelView, 0.44);
        double d = panelPos.X * panelView.X + panelPos.Y * panelView.Y + panelPos.Z * panelView.Z;
        double c = panelView.X * playerPos.X + panelView.Y * playerPos.Y + panelView.Z * playerPos.Z;
        double b = panelView.X * playerView.X + panelView.Y * playerView.Y + panelView.Z * playerView.Z;
        double a = (d - c) / b;
        MathVector viewPos = new MathVector();
        viewPos.X = playerPos.X + a * playerView.X - panelPos.X;
        viewPos.Y = playerPos.Y + a * playerView.Y - panelPos.Y;
        viewPos.Z = playerPos.Z + a * playerView.Z - panelPos.Z;
        MathVector panelScalVector1 = new MathVector();
        if (panelView.Y == 0.0) {
            panelScalVector1.X = 0.0;
            panelScalVector1.Y = 1.0;
            panelScalVector1.Z = 0.0;
        } else {
            panelScalVector1 = panelView.getOrtogonal(-panelView.X, null, -panelView.Z).makeVectorLength(1.0);
        }
        MathVector panelScalVector2 = new MathVector();
        if (panelView.Z == 0.0) {
            panelScalVector2.X = 0.0;
            panelScalVector2.Y = 0.0;
            panelScalVector2.Z = 1.0;
        } else {
            panelScalVector2 = panelView.getOrtogonal(1.0, 0.0, null).makeVectorLength(1.0);
        }
        if (panelScalVector1.Y == 0.0) {
            return false;
        }
        double cursorY = -viewPos.Y / panelScalVector1.Y;
        MathVector restViewPos = viewPos.clone();
        restViewPos.X += cursorY * panelScalVector1.X;
        restViewPos.Y = 0.0;
        restViewPos.Z += cursorY * panelScalVector1.Z;
        double cursorX = panelScalVector2.X == 0.0 ? restViewPos.Z / panelScalVector2.Z : restViewPos.X / panelScalVector2.X;
        cursorX *= 106.38297872340426;
        cursorY *= 106.38297872340426;
        if (panelView.Z < 0.0) {
            cursorX *= -1.0;
        }
        if (panelView.Y < 0.0) {
            cursorY *= -1.0;
        }
        if (renderer.getRenderer().cursorOnWindow((int)cursorX, (int)cursorY)) {
            renderer.getRenderer().handleCursor((int)cursorX, (int)cursorY);
            return true;
        }
        return false;
    }

    public boolean displayRenderer() {
        if (!this.displayHUD() && this.list.size() != 0) {
            this.clearList(true);
        }
        return this.displayHUD();
    }

    private boolean displayHUD() {
        return this.playerWearsHUD() && FMLClientHandler.instance().getClient().r == null && FMLClientHandler.instance().getClient().y.W == 0 && !FMLClientHandler.instance().getClient().y.V;
    }

    public static LogisticsHUDRenderer instance() {
        if (renderer == null) {
            renderer = new LogisticsHUDRenderer();
        }
        return renderer;
    }
}

