/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.renderer;

import buildcraft.BuildCraftCore;
import buildcraft.core.render.RenderEntityBlock;
import buildcraft.transport.Pipe;
import buildcraft.transport.TileGenericPipe;
import buildcraft.transport.render.RenderPipe;
import java.util.HashMap;
import logisticspipes.transport.PipeLiquidTransportLogistics;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;

public class LogisticsRenderPipe
extends RenderPipe {
    private static final int LIQUID_STAGES = 40;
    private final int[] angleY = new int[]{0, 0, 270, 90, 0, 180};
    private final int[] angleZ = new int[]{90, 270, 0, 0, 0, 0};
    private HashMap displayLiquidLists = new HashMap();

    public void a(any tileentity, double x, double y2, double z, float f) {
        super.a(tileentity, x, y2, z, f);
        if (BuildCraftCore.render == BuildCraftCore.RenderMode.NoDynamic) {
            return;
        }
        TileGenericPipe pipe = (TileGenericPipe)tileentity;
        if (pipe.pipe == null) {
            return;
        }
        if (pipe.pipe.transport instanceof PipeLiquidTransportLogistics) {
            this.renderLiquids(pipe.pipe, x, y2, z);
        }
    }

    private void renderLiquids(Pipe pipe, double x, double y2, double z) {
        DisplayLiquidList d;
        PipeLiquidTransportLogistics liq = (PipeLiquidTransportLogistics)pipe.transport;
        GL11.glPushMatrix();
        GL11.glDisable((int)2896);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y2 + 0.5f), (float)((float)z + 0.5f));
        boolean sides = false;
        boolean above = false;
        for (int i = 0; i < 6; ++i) {
            DisplayLiquidList d2;
            LiquidStack liquid = liq.renderCache[i];
            if (liquid == null || liquid.amount <= 0 || (d2 = this.getListFromBuffer(liquid, pipe.worldObj)) == null) continue;
            int stage = (int)((float)liquid.amount / (float)liq.getSideCapacity() * 39.0f);
            GL11.glPushMatrix();
            int list = 0;
            switch (ForgeDirection.VALID_DIRECTIONS[i]) {
                case UP: {
                    above = true;
                    list = d2.sideVertical[stage];
                    break;
                }
                case DOWN: {
                    GL11.glTranslatef((float)0.0f, (float)-0.75f, (float)0.0f);
                    list = d2.sideVertical[stage];
                    break;
                }
                case EAST: 
                case WEST: 
                case SOUTH: 
                case NORTH: {
                    sides = true;
                    GL11.glRotatef((float)this.angleY[i], (float)0.0f, (float)1.0f, (float)0.0f);
                    GL11.glRotatef((float)this.angleZ[i], (float)0.0f, (float)0.0f, (float)1.0f);
                    list = d2.sideHorizontal[stage];
                    break;
                }
            }
            GL11.glCallList((int)list);
            GL11.glPopMatrix();
        }
        LiquidStack liquid = liq.renderCache[ForgeDirection.UNKNOWN.ordinal()];
        if (liquid != null && liquid.amount > 0 && (d = this.getListFromBuffer(liquid, pipe.worldObj)) != null) {
            int stage = (int)((float)liquid.amount / (float)liq.getInnerCapacity() * 39.0f);
            if (above) {
                GL11.glCallList((int)d.centerVertical[stage]);
            }
            if (!above || sides) {
                GL11.glCallList((int)d.centerHorizontal[stage]);
            }
        }
        GL11.glEnable((int)2896);
        GL11.glPopMatrix();
    }

    private DisplayLiquidList getListFromBuffer(LiquidStack stack, yc world) {
        int liquidId = stack.itemID;
        if (liquidId == 0) {
            return null;
        }
        if (liquidId < amq.p.length && amq.p[liquidId] != null) {
            ForgeHooksClient.bindTexture((String)amq.p[liquidId].getTextureFile(), (int)0);
        } else if (up.e[liquidId] != null) {
            ForgeHooksClient.bindTexture((String)up.e[liquidId].getTextureFile(), (int)0);
        } else {
            return null;
        }
        return this.getDisplayLiquidLists(liquidId, stack.itemMeta, world);
    }

    private DisplayLiquidList getDisplayLiquidLists(int liquidId, int meta, yc world) {
        HashMap<Integer, DisplayLiquidList> list = (HashMap<Integer, DisplayLiquidList>)this.displayLiquidLists.get(liquidId);
        if (list != null) {
            HashMap x = (HashMap)this.displayLiquidLists.get(liquidId);
            DisplayLiquidList liquidList = (DisplayLiquidList)x.get(meta);
            if (liquidList != null) {
                return liquidList;
            }
        } else {
            list = new HashMap<Integer, DisplayLiquidList>();
            this.displayLiquidLists.put(liquidId, list);
        }
        DisplayLiquidList d = new DisplayLiquidList();
        list.put(meta, d);
        RenderEntityBlock.BlockInterface block = new RenderEntityBlock.BlockInterface();
        block.texture = liquidId < amq.p.length && amq.p[liquidId] != null ? amq.p[liquidId].a(0, meta) : up.e[liquidId].b(meta);
        float size = 0.5f;
        for (int s = 0; s < 40; ++s) {
            float ratio = (float)s / 40.0f;
            d.sideHorizontal[s] = arx.a((int)1);
            GL11.glNewList((int)d.sideHorizontal[s], (int)4864);
            block.minX = 0.0;
            block.minZ = 0.26f;
            block.maxX = block.minX + (double)(size / 2.0f) + (double)0.01f;
            block.maxZ = block.minZ + (double)size - (double)0.02f;
            block.minY = 0.26f;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (ym)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
            d.sideVertical[s] = arx.a((int)1);
            GL11.glNewList((int)d.sideVertical[s], (int)4864);
            block.minY = 0.74;
            block.maxY = 1.0;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.01) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.01) * (double)ratio;
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (ym)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
            d.centerHorizontal[s] = arx.a((int)1);
            GL11.glNewList((int)d.centerHorizontal[s], (int)4864);
            block.minX = 0.26;
            block.minZ = 0.26;
            block.maxX = block.minX + (double)size - 0.02;
            block.maxZ = block.minZ + (double)size - 0.02;
            block.minY = 0.26;
            block.maxY = block.minY + (double)((size - 0.02f) * ratio);
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (ym)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
            d.centerVertical[s] = arx.a((int)1);
            GL11.glNewList((int)d.centerVertical[s], (int)4864);
            block.minY = 0.26;
            block.maxY = 0.74;
            block.minX = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxX = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.minZ = 0.5 - ((double)(size / 2.0f) - 0.02) * (double)ratio;
            block.maxZ = 0.5 + ((double)(size / 2.0f) - 0.02) * (double)ratio;
            RenderEntityBlock.renderBlock((RenderEntityBlock.BlockInterface)block, (ym)world, (int)0, (int)0, (int)0, (boolean)false, (boolean)true);
            GL11.glEndList();
        }
        return d;
    }

    private class DisplayLiquidList {
        public int[] sideHorizontal = new int[40];
        public int[] sideVertical = new int[40];
        public int[] centerHorizontal = new int[40];
        public int[] centerVertical = new int[40];

        private DisplayLiquidList() {
        }
    }
}

