/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair;

public class CraftingTemplate
implements Comparable {
    private ItemIdentifierStack _result;
    private ICraftItems _crafter;
    private ArrayList _required = new ArrayList(9);
    private final int priority;

    public CraftingTemplate(ItemIdentifierStack result, ICraftItems crafter, int priority) {
        this._result = result;
        this._crafter = crafter;
        this.priority = priority;
    }

    public void addRequirement(ItemIdentifierStack stack, IRequestItems crafter) {
        for (Pair i : this._required) {
            if (((ItemIdentifierStack)i.getValue1()).getItem() != stack.getItem() || i.getValue2() != crafter) continue;
            ((ItemIdentifierStack)i.getValue1()).stackSize += stack.stackSize;
            return;
        }
        this._required.add(new Pair(stack, crafter));
    }

    public LogisticsPromise generatePromise(int nResultSets, List relays) {
        LogisticsPromise promise = new LogisticsPromise();
        promise.item = this._result.getItem();
        promise.numberOfItems = this._result.stackSize * nResultSets;
        promise.sender = this._crafter;
        promise.relayPoints = relays;
        return promise;
    }

    public List getSource() {
        return this._required;
    }

    public ItemIdentifierStack getResultStack() {
        return this._result;
    }

    public ICraftItems getCrafter() {
        return this._crafter;
    }

    public int getPriority() {
        return this.priority;
    }

    public int compareTo(CraftingTemplate o) {
        int c = this.priority - o.priority;
        if (c == 0) {
            c = this._result.compareTo(o._result);
        }
        if (c == 0) {
            c = this._crafter.compareTo(o._crafter);
        }
        return c;
    }

    public static class PairPrioritizer
    implements Comparator {
        public int compare(Pair o1, Pair o2) {
            return ((CraftingTemplate)o2.getValue1()).priority - ((CraftingTemplate)o1.getValue1()).priority;
        }
    }
}

