/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.request.RequestLog;
import logisticspipes.routing.LiquidLogisticsPromise;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.ItemMessage;
import logisticspipes.utils.LiquidIdentifier;

public class LiquidRequest {
    private final LiquidIdentifier liquid;
    private final int amount;
    private List promises = new ArrayList();

    public LiquidRequest(LiquidIdentifier liquid, int amount) {
        this.liquid = liquid;
        this.amount = amount;
    }

    public int getAmount() {
        return this.amount;
    }

    public LiquidIdentifier getLiquid() {
        return this.liquid;
    }

    public ItemIdentifierStack getStack() {
        return this.liquid.getItemIdentifier().makeStack(this.amount);
    }

    public int amountLeft() {
        int promised = 0;
        for (LiquidLogisticsPromise promise : this.promises) {
            promised += promise.amount;
        }
        return this.amount - promised;
    }

    public boolean isAllDone() {
        return this.amountLeft() <= 0;
    }

    public void fullFill(IRequestLiquid destination) {
        for (LiquidLogisticsPromise promise : this.promises) {
            promise.sender.fullFill(promise, destination);
        }
    }

    public void sendMissingMessage(RequestLog log) {
        LinkedList<ItemMessage> mes = new LinkedList<ItemMessage>();
        mes.add(new ItemMessage(this.liquid.getItemIdentifier(), this.amountLeft()));
        log.handleMissingItems(mes);
    }

    public void addPromise(LiquidLogisticsPromise promise) {
        this.promises.add(promise);
    }
}

