/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.PriorityQueue;
import logisticspipes.interfaces.routing.ICraftItems;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.interfaces.routing.IFilteringRouter;
import logisticspipes.interfaces.routing.ILiquidProvider;
import logisticspipes.interfaces.routing.IProvideItems;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.interfaces.routing.IRequestLiquid;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.request.CraftingTemplate;
import logisticspipes.request.LiquidRequest;
import logisticspipes.request.RequestLog;
import logisticspipes.request.RequestTree;
import logisticspipes.request.RequestTreeNode;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.LogisticsExtraPromise;
import logisticspipes.routing.LogisticsPromise;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.IHavePriority;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.ItemMessage;
import logisticspipes.utils.LiquidIdentifier;
import logisticspipes.utils.Pair;

public class RequestManager {
    public static boolean request(List items, IRequestItems requester, RequestLog log) {
        LinkedList<ItemMessage> messages = new LinkedList<ItemMessage>();
        RequestTree tree = new RequestTree(new ItemIdentifierStack(ItemIdentifier.get(1, 0, null), 0), requester, null);
        boolean isDone = true;
        for (ItemIdentifierStack stack : items) {
            RequestTree node = new RequestTree(stack, requester, tree);
            messages.add(new ItemMessage(stack));
            RequestManager.generateRequestTree(tree, node);
            isDone = isDone && node.isDone();
        }
        if (isDone) {
            RequestManager.handleRequestTree(tree);
            if (log != null) {
                log.handleSucessfullRequestOfList(messages);
            }
            return true;
        }
        if (log != null) {
            for (RequestTreeNode node : tree.subRequests) {
                RequestManager.recurseFailedRequestTree(tree, node);
            }
            for (RequestTreeNode node : tree.subRequests) {
                if (!(node instanceof RequestTree)) continue;
                ((RequestTree)node).sendMissingMessage(log);
            }
        }
        return false;
    }

    public static boolean request(ItemIdentifierStack item, IRequestItems requester, RequestLog log) {
        RequestTree tree = new RequestTree(item, requester, null);
        RequestManager.generateRequestTree(tree, tree);
        if (tree.isDone()) {
            RequestManager.handleRequestTree(tree);
            if (log != null) {
                log.handleSucessfullRequestOf(new ItemMessage(tree.getStack()));
            }
            return true;
        }
        if (log != null) {
            RequestManager.recurseFailedRequestTree(tree, tree);
            tree.sendMissingMessage(log);
        }
        return false;
    }

    public static int requestPartial(ItemIdentifierStack item, IRequestItems requester) {
        RequestTree tree = new RequestTree(item, requester, null);
        RequestManager.generateRequestTree(tree, tree);
        int r = tree.getPromiseItemCount();
        if (r > 0) {
            RequestManager.handleRequestTree(tree);
        }
        return r;
    }

    public static void simulate(ItemIdentifierStack item, IRequestItems requester, RequestLog log) {
        RequestTree tree = new RequestTree(item, requester, null);
        RequestManager.generateRequestTree(tree, tree);
        if (log != null) {
            if (!tree.isDone()) {
                RequestManager.recurseFailedRequestTree(tree, tree);
            }
            tree.sendUsedMessage(log);
        }
    }

    private static List getCrafters(List validDestinations, BitSet layer, List filters) {
        ArrayList<Pair> crafters = new ArrayList<Pair>(validDestinations.size());
        LinkedList<ExitRoute> firewalls = new LinkedList<ExitRoute>();
        BitSet used = (BitSet)layer.clone();
        for (ExitRoute r : validDestinations) {
            CoreRoutedPipe pipe = r.destination.getPipe();
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(r.destination.getSimpleID())) continue;
            if (pipe instanceof ICraftItems) {
                used.set(r.destination.getSimpleID());
                CraftingTemplate craftable = ((ICraftItems)((Object)pipe)).addCrafting();
                if (craftable != null) {
                    for (IFilter filter : filters) {
                        if (filter.isBlocked() != filter.isFilteredItem(craftable.getResultStack().getItem().getUndamaged()) && !filter.blockCrafting()) continue;
                    }
                    LinkedList list = new LinkedList();
                    list.addAll(filters);
                    crafters.add(new Pair(craftable, list));
                }
            }
            if (!(r.destination instanceof IFilteringRouter)) continue;
            firewalls.add(r);
            used.set(r.destination.getSimpleID());
        }
        for (ExitRoute r : firewalls) {
            IFilter filter = ((IFilteringRouter)((Object)r.destination)).getFilter();
            filters.add(filter);
            List list = RequestManager.getCrafters(((IFilteringRouter)((Object)r.destination)).getRouters(), used, filters);
            filters.remove(filter);
            crafters.addAll(list);
        }
        return crafters;
    }

    private static List getProviders(List validDestinations, BitSet layer, List filters) {
        List list;
        LinkedList<Pair> providers = new LinkedList<Pair>();
        LinkedList<ExitRoute> firewalls = new LinkedList<ExitRoute>();
        BitSet used = (BitSet)layer.clone();
        for (ExitRoute r : validDestinations) {
            if (!r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || used.get(r.destination.getSimpleID())) continue;
            CoreRoutedPipe pipe = r.destination.getPipe();
            if (pipe instanceof IProvideItems) {
                list = new LinkedList();
                list.addAll(filters);
                providers.add(new Pair((IProvideItems)((Object)pipe), list));
                used.set(r.root.getSimpleID());
            }
            if (!(r.destination instanceof IFilteringRouter)) continue;
            firewalls.add(r);
            used.set(r.destination.getSimpleID());
        }
        for (ExitRoute r : firewalls) {
            IFilter filter = ((IFilteringRouter)((Object)r.destination)).getFilter();
            filters.add(filter);
            list = RequestManager.getProviders(((IFilteringRouter)((Object)r.destination)).getRouters(), used, filters);
            filters.remove(filter);
            providers.addAll(list);
        }
        return providers;
    }

    private static void handleRequestTree(RequestTree tree) {
        tree.fullFillAll();
    }

    private static boolean generateRequestTree(RequestTree tree, RequestTreeNode treeNode) {
        RequestManager.checkProvider(tree, treeNode);
        if (treeNode.isDone()) {
            return true;
        }
        RequestManager.checkExtras(tree, treeNode);
        if (treeNode.isDone()) {
            return true;
        }
        RequestManager.checkCrafting(tree, treeNode);
        return treeNode.isDone();
    }

    private static void checkExtras(RequestTree tree, RequestTreeNode treeNode) {
        LinkedList map = tree.getExtrasFor(treeNode.getStack().getItem());
        for (LogisticsExtraPromise extraPromise : map) {
            if (treeNode.isDone()) break;
            if (extraPromise.numberOfItems == 0) continue;
            boolean valid = false;
            ExitRoute source = (ExitRoute)extraPromise.sender.getRouter().getRouteTable().get(treeNode.target.getRouter().getSimpleID());
            if (source != null && !source.containsFlag(PipeRoutingConnectionType.canRouteTo)) {
                for (ExitRoute node : treeNode.target.getRouter().getIRoutersByCost()) {
                    if (node.destination != extraPromise.sender.getRouter() || !node.containsFlag(PipeRoutingConnectionType.canRequestFrom)) continue;
                    valid = true;
                }
            }
            if (!valid) continue;
            extraPromise.numberOfItems = Math.min(extraPromise.numberOfItems, treeNode.getMissingItemCount());
            treeNode.addPromise(extraPromise);
        }
    }

    private static void checkCrafting(RequestTree tree, RequestTreeNode treeNode) {
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(treeNode.getStack().getItem());
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            ExitRoute e = treeNode.target.getRouter().getDistanceTo(r);
            if (e != null) {
                validSources.add(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        workWeightedSorter wSorter = new workWeightedSorter(0.0);
        Collections.sort(validSources, wSorter);
        List allCraftersForItem = RequestManager.getCrafters(validSources, new BitSet(ServerRouter.getBiggestSimpleID()), new LinkedList());
        Iterator iterAllCrafters = allCraftersForItem.iterator();
        PriorityQueue<CraftingSorterNode> craftersSamePriority = new PriorityQueue<CraftingSorterNode>(5);
        boolean done = false;
        Pair lastCrafter = null;
        int currentPriority = 0;
        int itemsNeeded = treeNode.getMissingItemCount();
        ArrayList craftersToBalance = new ArrayList();
        block1: while (!done) {
            itemsNeeded = treeNode.getMissingItemCount();
            if (iterAllCrafters.hasNext()) {
                if (lastCrafter == null) {
                    lastCrafter = (Pair)iterAllCrafters.next();
                }
            } else {
                done = true;
            }
            if (lastCrafter != null && (craftersSamePriority.isEmpty() || currentPriority == ((CraftingTemplate)lastCrafter.getValue1()).getPriority())) {
                currentPriority = ((CraftingTemplate)lastCrafter.getValue1()).getPriority();
                Pair crafter = lastCrafter;
                lastCrafter = null;
                CraftingTemplate template = (CraftingTemplate)crafter.getValue1();
                if (treeNode.isCrafterUsed(template) || template.getResultStack().getItem() != treeNode.getStack().getItem()) continue;
                for (IFilter filter : (List)crafter.getValue2()) {
                    if (filter.isBlocked() != filter.isFilteredItem(template.getResultStack().getItem().getUndamaged()) && !filter.blockCrafting()) continue;
                    continue block1;
                }
                CraftingSorterNode cn = new CraftingSorterNode(crafter, itemsNeeded, tree, treeNode);
                craftersSamePriority.add(cn);
                continue;
            }
            if (craftersSamePriority.size() == 1) {
                craftersToBalance.add(craftersSamePriority.poll());
                ((CraftingSorterNode)craftersToBalance.get(0)).addToWorkRequest(itemsNeeded);
            } else {
                if (!craftersSamePriority.isEmpty()) {
                    craftersToBalance.add(craftersSamePriority.poll());
                }
                while (!craftersToBalance.isEmpty() && itemsNeeded > 0) {
                    while (!craftersSamePriority.isEmpty() && ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() <= ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo()) {
                        craftersToBalance.add(craftersSamePriority.poll());
                    }
                    int cap = !craftersSamePriority.isEmpty() ? ((CraftingSorterNode)craftersSamePriority.peek()).currentToDo() : Integer.MAX_VALUE;
                    int floor = ((CraftingSorterNode)craftersToBalance.get(0)).currentToDo();
                    cap = Math.min(cap, floor + (itemsNeeded + craftersToBalance.size() - 1) / craftersToBalance.size());
                    for (CraftingSorterNode crafter : craftersToBalance) {
                        int request = Math.min(itemsNeeded, cap - floor);
                        if (request <= 0) continue;
                        int craftingDone = crafter.addToWorkRequest(request);
                        itemsNeeded -= craftingDone;
                    }
                }
            }
            Iterator iter = craftersToBalance.iterator();
            while (iter.hasNext()) {
                CraftingSorterNode c = (CraftingSorterNode)iter.next();
                if (c.addWorkPromisesToTree()) continue;
                iter.remove();
            }
            itemsNeeded = treeNode.getMissingItemCount();
            if (itemsNeeded <= 0) break;
            if (craftersToBalance.isEmpty()) continue;
            done = false;
        }
    }

    private static void recurseFailedRequestTree(RequestTree tree, RequestTreeNode treeNode) {
        if (treeNode.isDone()) {
            return;
        }
        if (treeNode.lastCrafterTried == null) {
            return;
        }
        CraftingTemplate template = treeNode.lastCrafterTried;
        List components = template.getSource();
        ArrayList<Pair> stacks = new ArrayList<Pair>(components.size());
        int nCraftingSetsNeeded = (treeNode.getMissingItemCount() + template.getResultStack().stackSize - 1) / template.getResultStack().stackSize;
        for (Pair stack : components) {
            Pair pair = new Pair(((ItemIdentifierStack)stack.getValue1()).clone(), stack.getValue2());
            ((ItemIdentifierStack)pair.getValue1()).stackSize *= nCraftingSetsNeeded;
            stacks.add(pair);
        }
        for (Pair stack : stacks) {
            RequestTreeNode node = new RequestTreeNode((ItemIdentifierStack)stack.getValue1(), (IRequestItems)stack.getValue2(), treeNode);
            node.declareCrafterUsed(template);
            RequestManager.generateRequestTree(tree, node);
        }
        treeNode.addPromise(template.generatePromise(nCraftingSetsNeeded, new ArrayList()));
        for (RequestTreeNode subNode : treeNode.subRequests) {
            RequestManager.recurseFailedRequestTree(tree, subNode);
        }
    }

    private static void checkProvider(RequestTree tree, RequestTreeNode treeNode) {
        CoreRoutedPipe thisPipe = treeNode.target.getRouter().getPipe();
        BitSet routersIndex = ServerRouter.getRoutersInterestedIn(treeNode.getStack().getItem());
        ArrayList<ExitRoute> validSources = new ArrayList<ExitRoute>();
        int i = routersIndex.nextSetBit(0);
        while (i >= 0) {
            IRouter r = SimpleServiceLocator.routerManager.getRouterUnsafe(i, false);
            ExitRoute e = treeNode.target.getRouter().getDistanceTo(r);
            if (e != null) {
                validSources.add(e);
            }
            i = routersIndex.nextSetBit(i + 1);
        }
        Collections.sort(validSources, new workWeightedSorter(1.0));
        for (Pair provider : RequestManager.getProviders(validSources, new BitSet(ServerRouter.getBiggestSimpleID()), new LinkedList())) {
            if (treeNode.isDone()) break;
            if (thisPipe.sharesInventoryWith(((IProvideItems)provider.getValue1()).getRouter().getPipe())) continue;
            ((IProvideItems)provider.getValue1()).canProvide(treeNode, tree.getAllPromissesFor((IProvideItems)provider.getValue1(), treeNode.getStack().getItem()), (List)provider.getValue2());
        }
    }

    public static boolean requestLiquid(LiquidIdentifier liquid, int amount, IRequestLiquid pipe, List list, RequestLog log) {
        List providers = RequestManager.getLiquidProviders(list);
        LiquidRequest request = new LiquidRequest(liquid, amount);
        for (ILiquidProvider provider : providers) {
            provider.canProvide(request);
        }
        if (request.isAllDone()) {
            request.fullFill(pipe);
            if (log != null) {
                log.handleSucessfullRequestOf(new ItemMessage(request.getStack()));
            }
            return true;
        }
        if (log != null) {
            request.sendMissingMessage(log);
        }
        return false;
    }

    private static List getLiquidProviders(List list) {
        LinkedList<ILiquidProvider> providers = new LinkedList<ILiquidProvider>();
        for (ExitRoute r : list) {
            CoreRoutedPipe pipe = r.destination.getPipe();
            if (!(pipe instanceof ILiquidProvider)) continue;
            providers.add((ILiquidProvider)((Object)pipe));
        }
        return providers;
    }

    private static class CraftingSorterNode
    implements Comparable {
        private int stacksOfWorkRequested;
        private final int setSize;
        private final int maxWorkSetsAvailable;
        private final RequestTree tree;
        private final RequestTreeNode treeNode;
        private List lastNode;
        private int sizeOfLastNodeRequest;
        public final Pair crafter;
        public final int originalToDo;

        CraftingSorterNode(Pair crafter, int maxCount, RequestTree tree, RequestTreeNode treeNode) {
            this.crafter = crafter;
            this.tree = tree;
            this.treeNode = treeNode;
            this.originalToDo = ((CraftingTemplate)crafter.getValue1()).getCrafter().getTodo();
            this.stacksOfWorkRequested = 0;
            this.sizeOfLastNodeRequest = 0;
            this.setSize = ((CraftingTemplate)crafter.getValue1()).getResultStack().stackSize;
            this.maxWorkSetsAvailable = (treeNode.getMissingItemCount() + this.setSize - 1) / this.setSize;
        }

        int calculateMaxWork(int maxSetsToCraft) {
            int nCraftingSetsNeeded = maxSetsToCraft == 0 ? (this.treeNode.getMissingItemCount() + this.setSize - 1) / this.setSize : maxSetsToCraft;
            if (nCraftingSetsNeeded == 0) {
                return 0;
            }
            CraftingTemplate template = (CraftingTemplate)this.crafter.getValue1();
            List components = template.getSource();
            ArrayList<Pair> stacks = new ArrayList<Pair>(components.size());
            for (Pair stack : components) {
                Pair pair = new Pair(((ItemIdentifierStack)stack.getValue1()).clone(), stack.getValue2());
                ((ItemIdentifierStack)pair.getValue1()).stackSize *= nCraftingSetsNeeded;
                stacks.add(pair);
            }
            this.sizeOfLastNodeRequest = nCraftingSetsNeeded;
            boolean failed = false;
            int workSetsAvailable = nCraftingSetsNeeded;
            this.lastNode = new ArrayList(components.size());
            for (Pair stack : stacks) {
                RequestTreeNode node = new RequestTreeNode((ItemIdentifierStack)stack.getValue1(), (IRequestItems)stack.getValue2(), this.treeNode);
                this.lastNode.add(node);
                node.declareCrafterUsed(template);
                if (RequestManager.generateRequestTree(this.tree, node)) continue;
                failed = true;
            }
            if (failed) {
                this.treeNode.lastCrafterTried = template;
                for (int i = 0; i < components.size(); ++i) {
                    workSetsAvailable = Math.min(workSetsAvailable, ((RequestTreeNode)this.lastNode.get(i)).getPromiseItemCount() / ((ItemIdentifierStack)((Pair)components.get((int)i)).getValue1()).stackSize);
                }
                return this.generateRequestTreeFor(workSetsAvailable);
            }
            return workSetsAvailable;
        }

        private int generateRequestTreeFor(int workSetsAvailable) {
            if (workSetsAvailable == this.sizeOfLastNodeRequest) {
                return workSetsAvailable;
            }
            this.sizeOfLastNodeRequest = workSetsAvailable;
            if (this.lastNode != null) {
                this.treeNode.remove(this.lastNode);
            }
            this.lastNode = new ArrayList();
            if (workSetsAvailable > 0) {
                CraftingTemplate template = (CraftingTemplate)this.crafter.getValue1();
                List components = template.getSource();
                ArrayList<Pair> stacks = new ArrayList<Pair>(components.size());
                for (Pair stack : components) {
                    Pair pair = new Pair(((ItemIdentifierStack)stack.getValue1()).clone(), stack.getValue2());
                    ((ItemIdentifierStack)pair.getValue1()).stackSize *= workSetsAvailable;
                    stacks.add(pair);
                }
                boolean failed = false;
                for (Pair stack : stacks) {
                    RequestTreeNode node = new RequestTreeNode((ItemIdentifierStack)stack.getValue1(), (IRequestItems)stack.getValue2(), this.treeNode);
                    this.lastNode.add(node);
                    node.declareCrafterUsed(template);
                    if (RequestManager.generateRequestTree(this.tree, node)) continue;
                    failed = true;
                }
                if (failed) {
                    this.treeNode.remove(this.lastNode);
                    return 0;
                }
            }
            return workSetsAvailable;
        }

        int addToWorkRequest(int extraWork) {
            int stacksRequested = (extraWork + this.setSize - 1) / this.setSize;
            this.stacksOfWorkRequested += stacksRequested;
            return stacksRequested * this.setSize;
        }

        boolean addWorkPromisesToTree() {
            CraftingTemplate template = (CraftingTemplate)this.crafter.getValue1();
            int setsToCraft = Math.min(this.stacksOfWorkRequested, this.maxWorkSetsAvailable);
            int setsAbleToCraft = this.calculateMaxWork(setsToCraft);
            if (setsAbleToCraft > 0) {
                LinkedList<IFilter> relays = new LinkedList<IFilter>();
                for (IFilter filter : (List)this.crafter.getValue2()) {
                    relays.add(filter);
                }
                LogisticsPromise job = template.generatePromise(setsAbleToCraft, relays);
                if (job.numberOfItems != setsAbleToCraft * this.setSize) {
                    throw new IllegalStateException("generatePromises not creating the promisesPromised; this is goign to end badly.");
                }
                this.treeNode.addPromise(job);
            }
            this.stacksOfWorkRequested = 0;
            if (setsToCraft == 0) {
                return false;
            }
            return setsToCraft == setsAbleToCraft;
        }

        public int compareTo(CraftingSorterNode o) {
            return this.currentToDo() - o.currentToDo();
        }

        public int currentToDo() {
            return this.originalToDo + this.stacksOfWorkRequested * this.setSize;
        }

        public void clearWorkRequest() {
            this.treeNode.remove(this.lastNode);
            this.lastNode.clear();
            this.stacksOfWorkRequested = 0;
            this.sizeOfLastNodeRequest = 0;
        }
    }

    public static class workWeightedSorter
    implements Comparator {
        public final double distanceWeight;

        public workWeightedSorter(double distanceWeight) {
            this.distanceWeight = distanceWeight;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public int compare(ExitRoute o1, ExitRoute o2) {
            double eps;
            if (o1.equals(o2)) {
                return 0;
            }
            double c = 0.0;
            if (o1.destination.getPipe() instanceof IHavePriority) {
                if (!(o2.destination.getPipe() instanceof IHavePriority)) return -1;
                c = ((IHavePriority)((Object)o2.destination.getCachedPipe())).getPriority() - ((IHavePriority)((Object)o1.destination.getCachedPipe())).getPriority();
            } else if (o2.destination.getPipe() instanceof IHavePriority) {
                return 1;
            }
            if (c != 0.0) {
                return (int)c;
            }
            int flip = 1;
            if (o1.destination.getSimpleID() - o2.destination.getSimpleID() < 0) {
                flip = -1;
                ExitRoute o_temp = o1;
                o1 = o2;
                o2 = o_temp;
            }
            c = o1.destination.getCachedPipe().getLoadFactor() - o2.destination.getCachedPipe().getLoadFactor();
            if (this.distanceWeight != 0.0) {
                c += (double)(o1.distanceToDestination - o2.distanceToDestination) * this.distanceWeight;
            }
            if (c > (eps = 2.2784756311113742E-305)) {
                return flip;
            }
            if (!(c < -eps)) return 0;
            return -flip;
        }
    }
}

