/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import buildcraft.transport.TileGenericPipe;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.ILogisticsModule;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.RoutedEntityItem;
import net.minecraftforge.common.ForgeDirection;

public class ClientRouter
implements IRouter {
    private final int _xCoord;
    private final int _yCoord;
    private final int _zCoord;

    public ClientRouter(UUID id, int dimension, int xCoord, int yCoord, int zCoord) {
        this._xCoord = xCoord;
        this._yCoord = yCoord;
        this._zCoord = zCoord;
    }

    @Override
    public void destroy() {
    }

    @Override
    public int getSimpleID() {
        return -420;
    }

    @Override
    public void update(boolean fullRefresh) {
    }

    @Override
    public boolean isRoutedExit(ForgeDirection connection) {
        if (LogisticsPipes.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return false;
    }

    @Override
    public boolean hasRoute(int id) {
        if (LogisticsPipes.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return false;
    }

    @Override
    public ForgeDirection getExitFor(int id) {
        if (LogisticsPipes.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return ForgeDirection.UNKNOWN;
    }

    @Override
    public ArrayList getRouteTable() {
        if (LogisticsPipes.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return new ArrayList();
    }

    @Override
    public List getIRoutersByCost() {
        if (LogisticsPipes.DEBUG) {
            throw new UnsupportedOperationException("noClientRouting");
        }
        return new LinkedList();
    }

    @Override
    public CoreRoutedPipe getPipe() {
        yc worldObj = MainProxy.proxy.getWorld();
        if (worldObj == null) {
            return null;
        }
        any tile = worldObj.q(this._xCoord, this._yCoord, this._zCoord);
        if (!(tile instanceof TileGenericPipe)) {
            return null;
        }
        TileGenericPipe pipe = (TileGenericPipe)tile;
        if (!(pipe.pipe instanceof CoreRoutedPipe)) {
            return null;
        }
        return (CoreRoutedPipe)pipe.pipe;
    }

    @Override
    public CoreRoutedPipe getCachedPipe() {
        return this.getPipe();
    }

    @Override
    public boolean isInDim(int dimension) {
        return true;
    }

    @Override
    public boolean isAt(int dimension, int xCoord, int yCoord, int zCoord) {
        return this._xCoord == xCoord && this._yCoord == yCoord && this._zCoord == zCoord;
    }

    @Override
    public UUID getId() {
        return null;
    }

    @Override
    public void displayRoutes() {
    }

    @Override
    public void displayRouteTo(int r) {
    }

    @Override
    public void inboundItemArrived(RoutedEntityItem routedEntityItem) {
    }

    @Override
    public ILogisticsModule getLogisticsModule() {
        CoreRoutedPipe pipe = this.getPipe();
        if (pipe == null) {
            return null;
        }
        return pipe.getLogisticsModule();
    }

    @Override
    public void clearPipeCache() {
    }

    @Override
    public List getPowerProvider() {
        return null;
    }

    @Override
    public IRouter getRouter(ForgeDirection insertOrientation) {
        return null;
    }

    @Override
    public boolean act(BitSet hasBeenProcessed, IRouter.IRAction actor) {
        return false;
    }

    @Override
    public void flagForRoutingUpdate() {
    }

    @Override
    public boolean checkAdjacentUpdate() {
        return false;
    }

    @Override
    public void clearPrevAdjacent() {
    }

    @Override
    public boolean isSideDisconneceted(ForgeDirection dir) {
        return false;
    }

    @Override
    public void updateInterests() {
    }

    @Override
    public ExitRoute getDistanceTo(IRouter r) {
        return null;
    }

    @Override
    public void clearInterests() {
    }
}

