/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.LinkedList;
import java.util.List;
import logisticspipes.interfaces.IChangeListener;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;
import logisticspipes.utils.Pair;
import logisticspipes.utils.Pair3;

public class LogisticsOrderManager {
    private LinkedList _orders = new LinkedList();
    private IChangeListener listener = null;

    public LogisticsOrderManager() {
    }

    public LogisticsOrderManager(IChangeListener listener) {
        this.listener = listener;
    }

    private void listen() {
        if (this.listener != null) {
            this.listener.listenedChanged();
        }
    }

    public LinkedList getContentList(yc world) {
        if (MainProxy.isClient(world) || this._orders.size() == 0) {
            return new LinkedList();
        }
        LinkedList list = new LinkedList();
        for (Pair request : this._orders) {
            LogisticsOrderManager.addToList((ItemIdentifierStack)request.getValue1(), list);
        }
        return list;
    }

    private static void addToList(ItemIdentifierStack stack, LinkedList list) {
        for (ItemIdentifierStack ident : list) {
            if (!ident.getItem().equals(stack.getItem())) continue;
            ident.stackSize += stack.stackSize;
            return;
        }
        list.addLast(stack.clone());
    }

    public boolean hasOrders() {
        return this._orders.size() > 0;
    }

    public Pair3 getNextRequest() {
        return (Pair3)this._orders.getFirst();
    }

    public void sendSuccessfull(int number, boolean defersend) {
        ((ItemIdentifierStack)((Pair3)this._orders.getFirst()).getValue1()).stackSize -= number;
        if (((ItemIdentifierStack)((Pair3)this._orders.getFirst()).getValue1()).stackSize <= 0) {
            this._orders.removeFirst();
        } else if (defersend) {
            this._orders.add(this._orders.removeFirst());
        }
        this.listen();
    }

    public void sendFailed() {
        ((IRequestItems)((Pair3)this._orders.getFirst()).getValue2()).itemCouldNotBeSend((ItemIdentifierStack)((Pair3)this._orders.getFirst()).getValue1());
        if (!this._orders.isEmpty()) {
            this._orders.removeFirst();
        }
        this.listen();
    }

    public void deferSend() {
        this._orders.add(this._orders.removeFirst());
        this.listen();
    }

    public void addOrder(ItemIdentifierStack stack, IRequestItems requester, List relays) {
        for (Pair3 request : this._orders) {
            if (((ItemIdentifierStack)request.getValue1()).getItem() != stack.getItem() || request.getValue2() != requester) continue;
            stack.stackSize += ((ItemIdentifierStack)request.getValue1()).stackSize;
            this._orders.remove(request);
            break;
        }
        this._orders.addLast(new Pair3(stack, requester, relays));
        this.listen();
    }

    public int totalItemsCountInOrders(ItemIdentifier item) {
        int itemCount = 0;
        for (Pair request : this._orders) {
            if (((ItemIdentifierStack)request.getValue1()).getItem() != item) continue;
            itemCount += ((ItemIdentifierStack)request.getValue1()).stackSize;
        }
        return itemCount;
    }

    public int totalItemsCountInAllOrders() {
        int itemCount = 0;
        for (Pair request : this._orders) {
            itemCount += ((ItemIdentifierStack)request.getValue1()).stackSize;
        }
        return itemCount;
    }
}

