/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import buildcraft.BuildCraftCore;
import buildcraft.api.core.Position;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import logisticspipes.interfaces.routing.IRelayItem;
import logisticspipes.interfaces.routing.IRequireReliableTransport;
import logisticspipes.items.LogisticsLiquidContainer;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.PipeLogisticsChassi;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.IRouterManager;
import logisticspipes.routing.RoutedEntityItemSaveHandler;
import logisticspipes.utils.ItemIdentifierStack;
import net.minecraftforge.common.ForgeDirection;

public class RoutedEntityItem
extends EntityPassiveItem
implements IRoutedItem {
    int destinationint = -1;
    UUID destinationUUID;
    ItemIdentifierStack thisItem;
    boolean _doNotBuffer;
    int bufferCounter = 0;
    boolean arrived;
    LinkedList relays = new LinkedList();
    IRoutedItem.TransportMode _transportMode = IRoutedItem.TransportMode.Unknown;
    List jamlist = new ArrayList();
    private final long origin = System.currentTimeMillis();
    private final long delay;

    public RoutedEntityItem(yc world, IPipedItem entityItem) {
        super(world, entityItem.getEntityId());
        this.thisItem = ItemIdentifierStack.GetFromStack(entityItem.getItemStack());
        this.container = entityItem.getContainer();
        this.position = entityItem.getPosition();
        this.speed = entityItem.getSpeed();
        this.item = entityItem.getItemStack();
        this.delay = 1240L;
        if (entityItem.getContribution("routingInformation") == null) {
            this.addContribution("routingInformation", new RoutedEntityItemSaveHandler(this));
        } else {
            RoutedEntityItemSaveHandler settings = (RoutedEntityItemSaveHandler)entityItem.getContribution("routingInformation");
            if (settings.transportMode != IRoutedItem.TransportMode.Active) {
                this.destinationUUID = settings.destinationUUID;
                this.checkIDFromUUID();
            }
            this.bufferCounter = settings.bufferCounter;
            this.arrived = settings.arrived;
            this._transportMode = settings.transportMode;
            this.addContribution("routingInformation", new RoutedEntityItemSaveHandler(this));
        }
    }

    public px toEntityItem(ForgeDirection dir) {
        if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
            if (this.getItemStack().a <= 0) {
                return null;
            }
            if (this.getItemStack().b() instanceof LogisticsLiquidContainer) {
                this.remove();
                return null;
            }
            if (this.position.x == (double)this.container.l + 0.5 && this.position.y == (double)this.container.m + 0.25 && this.position.z == (double)this.container.n + 0.5) {
                this.position.orientation = dir;
                if (dir == ForgeDirection.DOWN) {
                    this.position.moveForwards(0.251);
                } else if (dir == ForgeDirection.UP) {
                    this.position.moveForwards(0.75);
                } else if (dir == ForgeDirection.NORTH || dir == ForgeDirection.WEST) {
                    this.position.moveForwards(0.501);
                } else {
                    this.position.moveForwards(0.5);
                }
            }
            Position motion = new Position(0.0, 0.0, 0.0, dir);
            motion.moveForwards(0.1 + (double)(this.getSpeed() * 2.0f));
            px entityitem = new px(this.worldObj, this.position.x, this.position.y, this.position.z, this.getItemStack());
            entityitem.lifespan = BuildCraftCore.itemLifespan;
            entityitem.b = 10;
            float f3 = this.worldObj.t.nextFloat() * 0.01f - 0.02f;
            entityitem.w = (double)((float)this.worldObj.t.nextGaussian() * f3) + motion.x;
            entityitem.x = (double)((float)this.worldObj.t.nextGaussian() * f3) + motion.y;
            entityitem.y = (double)((float)this.worldObj.t.nextGaussian() * f3) + motion.z;
            this.worldObj.d((lq)entityitem);
            this.remove();
            return entityitem;
        }
        return null;
    }

    @Override
    public void clearDestination() {
        if (this.destinationint >= 0) {
            IRouter destinationRouter;
            if (SimpleServiceLocator.routerManager.isRouter(this.destinationint) && (destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.destinationint)).getPipe() != null && destinationRouter.getPipe().logic instanceof IRequireReliableTransport) {
                ((IRequireReliableTransport)destinationRouter.getPipe().logic).itemLost(ItemIdentifierStack.GetFromStack(this.item));
            }
            this.jamlist.add(this.destinationint);
        }
        this.destinationint = -1;
        this.destinationUUID = null;
        this._doNotBuffer = false;
        this.arrived = false;
        this.relays.clear();
        this._transportMode = IRoutedItem.TransportMode.Unknown;
    }

    public void remove() {
        if (MainProxy.isClient(this.worldObj)) {
            return;
        }
        if (this.destinationint >= 0 && SimpleServiceLocator.routerManager.isRouter(this.destinationint)) {
            IRouter destinationRouter = SimpleServiceLocator.routerManager.getRouter(this.destinationint);
            if (!this.arrived && destinationRouter.getPipe() != null && destinationRouter.getPipe().logic instanceof IRequireReliableTransport) {
                ((IRequireReliableTransport)destinationRouter.getPipe().logic).itemLost(ItemIdentifierStack.GetFromStack(this.item));
            }
        }
        super.remove();
    }

    @Override
    public int getDestination() {
        if (this.relays.isEmpty()) {
            return this.destinationint;
        }
        return (Integer)this.relays.getLast();
    }

    @Override
    public ItemIdentifierStack getIDStack() {
        return this.thisItem;
    }

    @Override
    public ur getItemStack() {
        return this.item;
    }

    @Override
    public void setItemStack(ur item) {
        this.item = item;
    }

    @Override
    public void setDestination(int destination) {
        this.destinationint = destination;
        IRouter router = SimpleServiceLocator.routerManager.getRouter(destination);
        this.destinationUUID = router != null ? router.getId() : null;
    }

    @Override
    public void setDoNotBuffer(boolean isBuffered) {
        this._doNotBuffer = isBuffered;
    }

    @Override
    public boolean getDoNotBuffer() {
        return this._doNotBuffer;
    }

    @Override
    public EntityPassiveItem getEntityPassiveItem() {
        return this;
    }

    @Override
    @Deprecated
    public void setArrived(boolean flag) {
        this.arrived = flag;
    }

    @Override
    public boolean getArrived() {
        return this.arrived;
    }

    @Override
    public void split(yc worldObj, int itemsToTake, ForgeDirection orientation) {
        if (this.getItemStack().b() instanceof LogisticsLiquidContainer) {
            throw new UnsupportedOperationException("Can't split up a LiquidContainer");
        }
        EntityPassiveItem newItem = new EntityPassiveItem(worldObj);
        newItem.setPosition(this.position.x, this.position.y, this.position.z);
        newItem.setSpeed(this.speed);
        newItem.setItemStack(this.item.a(this.item.a - itemsToTake));
        if (this.container instanceof TileGenericPipe && ((TileGenericPipe)this.container).pipe.transport instanceof PipeTransportItems) {
            if (((TileGenericPipe)this.container).pipe instanceof PipeLogisticsChassi) {
                PipeLogisticsChassi chassi = (PipeLogisticsChassi)((TileGenericPipe)this.container).pipe;
                chassi.queueRoutedItem(SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(worldObj, (IPipedItem)newItem), orientation, CoreRoutedPipe.ItemSendMode.Fast);
            } else {
                newItem.toEntityItem(orientation);
            }
        }
    }

    @Override
    public void SetPosition(double x, double y2, double z) {
        this.position = new Position(x, y2, z);
    }

    @Override
    public void setTransportMode(IRoutedItem.TransportMode transportMode) {
        this._transportMode = transportMode;
    }

    @Override
    public IRoutedItem.TransportMode getTransportMode() {
        return this._transportMode;
    }

    public EntityPassiveItem getNewEntityPassiveItem() {
        if (this.getItemStack().b() instanceof LogisticsLiquidContainer) {
            throw new UnsupportedOperationException("Can't change LiquidContainer to EntityPassiveItem");
        }
        EntityPassiveItem Entityitem = new EntityPassiveItem(this.worldObj, this.entityId);
        Entityitem.setContainer(this.container);
        Entityitem.setPosition(this.position.x, this.position.y, this.position.z);
        Entityitem.setSpeed(this.speed);
        Entityitem.setItemStack(this.item);
        return Entityitem;
    }

    @Override
    public void addToJamList(IRouter router) {
        this.jamlist.add(router.getSimpleID());
    }

    @Override
    public List getJamList() {
        return this.jamlist;
    }

    @Override
    public int getBufferCounter() {
        return this.bufferCounter;
    }

    @Override
    public void setBufferCounter(int counter) {
        this.bufferCounter = counter;
    }

    @Override
    public IRoutedItem getCopy() {
        EntityPassiveItem Entityitem = new EntityPassiveItem(this.worldObj, this.entityId);
        Entityitem.setContainer(this.container);
        Entityitem.setPosition(this.position.x, this.position.y, this.position.z);
        Entityitem.setSpeed(this.speed);
        Entityitem.setItemStack(this.item.l());
        RoutedEntityItem routed = new RoutedEntityItem(this.worldObj, (IPipedItem)Entityitem);
        routed.destinationint = this.destinationint;
        routed._doNotBuffer = this._doNotBuffer;
        routed.bufferCounter = this.bufferCounter;
        routed.arrived = this.arrived;
        routed._transportMode = this._transportMode;
        routed.jamlist.addAll(this.jamlist);
        routed.relays.addAll(this.relays);
        routed.thisItem = this.thisItem;
        return routed;
    }

    @Override
    public void addRelayPoints(List relays) {
        if (relays != null) {
            for (IRelayItem relay : relays) {
                this.relays.add(relay.getSimpleID());
            }
        }
    }

    @Override
    public void itemRelayed() {
        this.relays.removeLast();
    }

    @Override
    public boolean isItemRelayed() {
        return !this.relays.isEmpty();
    }

    @Override
    public void replaceRelayID(int newId) {
        this.relays.removeLast();
        this.relays.addLast(newId);
    }

    @Override
    public UUID getDestinationUUID() {
        return this.destinationUUID;
    }

    @Override
    public void checkIDFromUUID() {
        IRouterManager rm = SimpleServiceLocator.routerManager;
        IRouter router = rm.getRouter(this.destinationint);
        if (router == null || this.destinationUUID != router.getId()) {
            this.destinationint = rm.getIDforUUID(this.destinationUUID);
        }
    }

    public void useInformationFrom(RoutedEntityItem result) {
        this.destinationint = result.destinationint;
        this.destinationUUID = result.destinationUUID;
        this.thisItem = result.thisItem;
        this._doNotBuffer = result._doNotBuffer;
        this.arrived = result.arrived;
        this.relays = result.relays;
        this._transportMode = result._transportMode;
        this.jamlist = result.jamlist;
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.delay - (System.currentTimeMillis() - this.origin), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed delayed) {
        if (delayed == this) {
            return 0;
        }
        if (delayed instanceof RoutedEntityItem) {
            long diff = this.delay - ((RoutedEntityItem)delayed).delay;
            return diff == 0L ? 0 : (diff < 0L ? -1 : 1);
        }
        long d = this.getDelay(TimeUnit.MILLISECONDS) - delayed.getDelay(TimeUnit.MILLISECONDS);
        return d == 0L ? 0 : (d < 0L ? -1 : 1);
    }
}

