/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import buildcraft.api.transport.IPassiveItemContribution;
import java.util.LinkedList;
import java.util.UUID;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.RoutedEntityItem;

public class RoutedEntityItemSaveHandler
implements IPassiveItemContribution {
    private RoutedEntityItem routedEntityItem;
    public UUID destinationUUID;
    public int bufferCounter = 0;
    public boolean arrived;
    public IRoutedItem.TransportMode transportMode = IRoutedItem.TransportMode.Unknown;
    public LinkedList relays = new LinkedList();

    public RoutedEntityItemSaveHandler() {
    }

    public RoutedEntityItemSaveHandler(RoutedEntityItem routedEntityItem) {
        this.routedEntityItem = routedEntityItem;
    }

    private void extract() {
        if (this.routedEntityItem != null) {
            this.destinationUUID = this.routedEntityItem.destinationUUID;
            this.bufferCounter = this.routedEntityItem.getBufferCounter();
            this.arrived = this.routedEntityItem.arrived;
            this.transportMode = this.routedEntityItem.getTransportMode();
            this.relays.clear();
            this.relays.addAll(this.routedEntityItem.relays);
        }
    }

    public void readFromNBT(bq nbttagcompound) {
        if (nbttagcompound.b("destinationUUID")) {
            this.destinationUUID = UUID.fromString(nbttagcompound.i("destinationUUID"));
        }
        this.arrived = nbttagcompound.n("arrived");
        this.bufferCounter = nbttagcompound.e("bufferCounter");
        this.transportMode = IRoutedItem.TransportMode.values()[nbttagcompound.e("transportMode")];
        this.relays.clear();
        int size = nbttagcompound.e("relaysSize");
        for (int i = 0; i < size; ++i) {
            this.relays.add(SimpleServiceLocator.routerManager.getIDforUUID(UUID.fromString(nbttagcompound.i("relays" + i))));
        }
    }

    public void writeToNBT(bq nbttagcompound) {
        this.extract();
        if (this.destinationUUID != null) {
            nbttagcompound.a("destinationUUID", this.destinationUUID.toString());
        }
        nbttagcompound.a("arrived", this.arrived);
        nbttagcompound.a("bufferCounter", this.bufferCounter);
        nbttagcompound.a("transportMode", this.transportMode.ordinal());
        nbttagcompound.a("relaysSize", this.relays.size());
        for (int i = 0; i < this.relays.size(); ++i) {
            nbttagcompound.a("relays" + i, SimpleServiceLocator.routerManager.getRouter((Integer)this.relays.get(i)).getId().toString());
        }
    }
}

