/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.transport;

import buildcraft.api.transport.IPipeEntry;
import buildcraft.api.transport.IPipedItem;
import buildcraft.core.EntityPassiveItem;
import buildcraft.core.proxy.CoreProxy;
import buildcraft.core.utils.Utils;
import buildcraft.transport.EntityData;
import buildcraft.transport.IItemTravelingHook;
import buildcraft.transport.PipeTransportItems;
import buildcraft.transport.TileGenericPipe;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import logisticspipes.LogisticsPipes;
import logisticspipes.interfaces.IItemAdvancedExistance;
import logisticspipes.logisticspipes.IRoutedItem;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.upgrades.UpgradeManager;
import logisticspipes.proxy.MainProxy;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.RoutedEntityItem;
import logisticspipes.utils.InventoryHelper;
import logisticspipes.utils.Pair;
import net.minecraftforge.common.ForgeDirection;

public class PipeTransportLogistics
extends PipeTransportItems
implements IItemTravelingHook {
    private final int _bufferTimeOut = 40;
    private CoreRoutedPipe _pipe = null;
    private final HashMap _itemBuffer = new HashMap();
    private Method _reverseItem = null;
    private Field toRemove = null;
    private Set notToRemove = new HashSet();
    private zz chunk;

    public PipeTransportLogistics() {
        this.allowBouncing = true;
        try {
            this._reverseItem = PipeTransportItems.class.getDeclaredMethod("reverseItem", EntityData.class);
            this._reverseItem.setAccessible(true);
            this.toRemove = PipeTransportItems.class.getDeclaredField("toRemove");
            this.toRemove.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        this.travelHook = this;
    }

    public void initialize() {
        super.initialize();
        if (MainProxy.isServer(this.worldObj)) {
            this.chunk = this.worldObj.d(this.xCoord, this.zCoord);
        }
    }

    public void markChunkModified(any tile) {
        if (tile != null && this.chunk != null && (this.xCoord >> 4 != tile.l >> 4 || this.zCoord >> 4 != tile.n >> 4)) {
            this.chunk.l = true;
            if (tile instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe != null && ((TileGenericPipe)tile).pipe.transport instanceof PipeTransportLogistics && ((PipeTransportLogistics)((TileGenericPipe)tile).pipe.transport).chunk != null) {
                ((PipeTransportLogistics)((TileGenericPipe)tile).pipe.transport).chunk.l = true;
            } else {
                this.worldObj.b(tile.l, tile.m, tile.n, tile);
            }
        }
    }

    public void performRemoval() {
        try {
            if (!this.notToRemove.isEmpty()) {
                Set toRemoveList = (Set)this.toRemove.get((Object)this);
                toRemoveList.removeAll(this.notToRemove);
                this.notToRemove.clear();
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        super.performRemoval();
    }

    private CoreRoutedPipe getPipe() {
        if (this._pipe == null) {
            this._pipe = (CoreRoutedPipe)this.container.pipe;
        }
        return this._pipe;
    }

    public void updateEntity() {
        super.updateEntity();
        if (!this._itemBuffer.isEmpty()) {
            LinkedList<IRoutedItem> toAdd = new LinkedList<IRoutedItem>();
            Iterator iterator = this._itemBuffer.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry next = iterator.next();
                int currentTimeOut = (Integer)((Pair)next.getValue()).getValue1();
                if (currentTimeOut > 0) {
                    ((Pair)next.getValue()).setValue1(currentTimeOut - 1);
                    continue;
                }
                EntityPassiveItem item = new EntityPassiveItem(this.worldObj, (double)((float)this.xCoord + 0.5f), (double)((float)this.yCoord + Utils.getPipeFloorOf((ur)((ur)next.getKey()))) - 0.1, (double)this.zCoord + 0.5, (ur)next.getKey());
                IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.CreateRoutedItem(this.worldObj, (IPipedItem)item);
                routedItem.setDoNotBuffer(true);
                routedItem.setBufferCounter((Integer)((Pair)next.getValue()).getValue2() + 1);
                toAdd.add(routedItem);
                iterator.remove();
            }
            for (IRoutedItem item : toAdd) {
                this.entityEntering((IPipedItem)item.getEntityPassiveItem(), ForgeDirection.UP);
            }
        }
    }

    public void dropBuffer() {
        Iterator iterator = this._itemBuffer.keySet().iterator();
        while (iterator.hasNext()) {
            ur next = (ur)iterator.next();
            SimpleServiceLocator.buildCraftProxy.dropItems(this.worldObj, next, this.xCoord, this.yCoord, this.zCoord);
            iterator.remove();
        }
    }

    public ForgeDirection resolveDestination(EntityData data) {
        ForgeDirection value;
        IPipedItem result;
        if (data.item != null && data.item.getItemStack() != null) {
            this.getPipe().relayedItem(data.item.getItemStack().a);
        }
        data.item.setWorld(this.worldObj);
        ForgeDirection blocked = null;
        if (!(data.item instanceof IRoutedItem) && data.item != null && (result = this.getPipe().getQueuedForItemStack(data.item.getItemStack())) != null) {
            IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.GetOrCreateRoutedItem(this.worldObj, data);
            if (routedItem instanceof RoutedEntityItem && result instanceof RoutedEntityItem) {
                ((RoutedEntityItem)routedItem).useInformationFrom((RoutedEntityItem)result);
                blocked = data.input.getOpposite();
            } else {
                LogisticsPipes.log.warning("Unable to transfer information from ont Item to another. (" + routedItem.getClass().getName() + ", " + result.getClass().getName() + ")");
            }
        }
        IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.GetOrCreateRoutedItem(this.worldObj, data);
        if (this.getPipe().stillNeedReplace()) {
            routedItem.setDoNotBuffer(false);
            value = ForgeDirection.UNKNOWN;
        } else {
            value = this.getPipe().getRouteLayer().getOrientationForItem(routedItem, blocked);
        }
        if (value == null && MainProxy.isClient(this.worldObj)) {
            routedItem.getItemStack().a = 0;
            this.scheduleRemoval(data.item);
            return ForgeDirection.UNKNOWN;
        }
        if (value == null) {
            LogisticsPipes.log.severe("THIS IS NOT SUPPOSED TO HAPPEN!");
            return ForgeDirection.UNKNOWN;
        }
        if (value == ForgeDirection.UNKNOWN && !routedItem.getDoNotBuffer() && routedItem.getBufferCounter() < 5) {
            this._itemBuffer.put(routedItem.getItemStack().l(), new Pair(40, routedItem.getBufferCounter()));
            routedItem.getItemStack().a = 0;
            this.scheduleRemoval(data.item);
            return ForgeDirection.UNKNOWN;
        }
        if (value != ForgeDirection.UNKNOWN && !this._pipe.getRouter().isRoutedExit(value) && !this.isItemExitable(routedItem.getItemStack())) {
            routedItem.getItemStack().a = 0;
            this.scheduleRemoval(data.item);
            return ForgeDirection.UNKNOWN;
        }
        this.readjustSpeed((IPipedItem)routedItem.getEntityPassiveItem());
        return value;
    }

    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this._itemBuffer.clear();
        by nbttaglist = nbttagcompound.m("buffercontents");
        for (int i = 0; i < nbttaglist.c(); ++i) {
            bq nbttagcompound1 = (bq)nbttaglist.b(i);
            this._itemBuffer.put(ur.a((bq)nbttagcompound1), new Pair(40, 0));
        }
    }

    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        by nbttaglist = new by();
        for (ur stack : this._itemBuffer.keySet()) {
            bq nbttagcompound1 = new bq();
            stack.b(nbttagcompound1);
            nbttaglist.a((cd)nbttagcompound1);
        }
        nbttagcompound.a("buffercontents", (cd)nbttaglist);
    }

    public void readjustSpeed(IPipedItem item) {
        if (SimpleServiceLocator.buildCraftProxy.isRoutedItem(item)) {
            IRoutedItem routedItem = SimpleServiceLocator.buildCraftProxy.GetRoutedItem(item);
            float defaultBoost = 1.0f;
            switch (routedItem.getTransportMode()) {
                case Default: {
                    defaultBoost = 10.0f;
                    break;
                }
                case Passive: {
                    defaultBoost = 20.0f;
                    break;
                }
                case Active: {
                    defaultBoost = 30.0f;
                    break;
                }
                case Unknown: {
                    break;
                }
            }
            float multiplyerSpeed = 1.0f + 0.2f * (float)this.getPipe().getUpgradeManager().getSpeedUpgradeCount();
            float multiplyerPower = 1.0f + 0.3f * (float)this.getPipe().getUpgradeManager().getSpeedUpgradeCount();
            float add = Math.max(item.getSpeed(), Utils.pipeNormalSpeed * defaultBoost * multiplyerPower) - item.getSpeed();
            if (this.getPipe().useEnergy((int)((double)(add * 25.0f) + 0.5))) {
                item.setSpeed(Math.min(Math.max(item.getSpeed(), Utils.pipeNormalSpeed * defaultBoost * multiplyerSpeed), 1.0f));
            }
        }
        if (MainProxy.isClient(this.worldObj)) {
            MainProxy.spawnParticle(5, this.xCoord, this.yCoord, this.zCoord, 1);
        }
    }

    private void handleTileReached(EntityData data, any tile) {
        if (SimpleServiceLocator.specialtileconnection.needsInformationTransition(tile)) {
            SimpleServiceLocator.specialtileconnection.transmit(tile, data);
        }
        if (tile instanceof IPipeEntry) {
            ((IPipeEntry)tile).entityEntering(data.item, data.output);
        } else if (tile instanceof TileGenericPipe && ((TileGenericPipe)tile).pipe.transport instanceof PipeTransportItems) {
            TileGenericPipe pipe = (TileGenericPipe)tile;
            ((PipeTransportItems)pipe.pipe.transport).entityEntering(data.item, data.output);
        } else if (tile instanceof la) {
            if (!this.isItemExitable(data.item.getItemStack())) {
                return;
            }
            if (!CoreProxy.proxy.isRenderWorld(this.worldObj)) {
                if (data.item instanceof IRoutedItem) {
                    IRoutedItem routed = (IRoutedItem)data.item;
                    if (!this.getPipe().getTransportLayer().stillWantItem(routed)) {
                        this.logisticsReverseItem(data);
                        return;
                    }
                }
                UpgradeManager manager = this.getPipe().getUpgradeManager();
                ForgeDirection insertion = data.output.getOpposite();
                if (manager.hasSneakyUpgrade()) {
                    insertion = manager.getSneakyOrientation();
                }
                ur added = InventoryHelper.getTransactorFor(tile).add(data.item.getItemStack(), insertion, true);
                data.item.getItemStack().a -= added.a;
                if (data.item instanceof IRoutedItem) {
                    IRoutedItem routed = (IRoutedItem)data.item;
                    IRoutedItem newItem = routed.getCopy();
                    newItem.setItemStack(added);
                    EntityData addedData = new EntityData((IPipedItem)newItem.getEntityPassiveItem(), data.input);
                    this.insertedItemStack(addedData, tile);
                }
                if (data.item.getItemStack().a > 0) {
                    this.logisticsReverseItem(data);
                }
            }
        } else {
            px dropped;
            if (this.travelHook != null) {
                this.travelHook.drop((PipeTransportItems)this, data);
            }
            if ((dropped = data.item.toEntityItem(data.output)) != null) {
                this.onDropped(dropped);
            }
        }
    }

    protected boolean isItemExitable(ur stack) {
        if (stack != null && stack.b() instanceof IItemAdvancedExistance) {
            return ((IItemAdvancedExistance)stack.b()).canExistInNormalInventory(stack);
        }
        return true;
    }

    protected void logisticsReverseItem(EntityData data) {
        if (this._reverseItem != null) {
            try {
                this._reverseItem.invoke((Object)this, data);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                this._reverseItem = null;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                this._reverseItem = null;
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
                this._reverseItem = null;
            }
        } else {
            throw new UnsupportedOperationException("Failed calling reverseItem(EntityItem);");
        }
    }

    protected void insertedItemStack(EntityData data, any tile) {
    }

    public void endReached(PipeTransportItems pipe, EntityData data, any tile) {
        ((PipeTransportLogistics)pipe).markChunkModified(tile);
        try {
            Set toRemoveList = (Set)this.toRemove.get((Object)this);
            toRemoveList.add(data.item.getEntityId());
            this.handleTileReached(data, tile);
            if (!toRemoveList.contains(data.item.getEntityId())) {
                this.notToRemove.add(data.item.getEntityId());
                toRemoveList.add(data.item.getEntityId());
            }
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    public void drop(PipeTransportItems pipe, EntityData data) {
        data.item.setSpeed(0.0f);
    }

    public void centerReached(PipeTransportItems pipe, EntityData data) {
    }
}

