/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.utils.ItemIdentifier;

public class InventoryUtil
implements IInventoryUtil {
    protected final la _inventory;
    private final boolean _hideOnePerStack;
    private final boolean _hideOne;
    private final int _cropStart;
    private final int _cropEnd;

    public InventoryUtil(la inventory, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._inventory = inventory;
        this._hideOnePerStack = hideOnePerStack;
        this._hideOne = hideOne;
        this._cropStart = cropStart;
        this._cropEnd = cropEnd;
    }

    @Override
    public int itemCount(ItemIdentifier item) {
        int count = 0;
        boolean first = true;
        for (int i = this._cropStart; i < this._inventory.k_() - this._cropEnd; ++i) {
            ur stack = this._inventory.a(i);
            if (stack == null || ItemIdentifier.get(stack) != item) continue;
            if (first) {
                count = stack.a - (this._hideOne || this._hideOnePerStack ? 1 : 0);
                first = false;
                continue;
            }
            count += stack.a - (this._hideOnePerStack ? 1 : 0);
        }
        return count;
    }

    @Override
    public HashMap getItemsAndCount() {
        HashMap<ItemIdentifier, Integer> items = new HashMap<ItemIdentifier, Integer>();
        for (int i = this._cropStart; i < this._inventory.k_() - this._cropEnd; ++i) {
            ur stack = this._inventory.a(i);
            if (stack == null) continue;
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.a - (this._hideOnePerStack ? 1 : 0);
            Integer currentSize = (Integer)items.get(itemId);
            if (currentSize == null) {
                items.put(itemId, stackSize - (this._hideOne ? 1 : 0));
                continue;
            }
            items.put(itemId, currentSize + stackSize);
        }
        return items;
    }

    @Override
    public Set getItems() {
        TreeSet<ItemIdentifier> items = new TreeSet<ItemIdentifier>();
        for (int i = this._cropStart; i < this._inventory.k_() - this._cropEnd; ++i) {
            ur stack = this._inventory.a(i);
            if (stack == null) continue;
            items.add(ItemIdentifier.get(stack));
        }
        return items;
    }

    @Override
    public ur getSingleItem(ItemIdentifier item) {
        return this.getMultipleItems(item, 1);
    }

    @Override
    public ur getMultipleItems(ItemIdentifier item, int count) {
        if (this.itemCount(item) < count) {
            return null;
        }
        ur outputStack = null;
        boolean first = true;
        for (int i = this._cropStart; i < this._inventory.k_() - this._cropEnd && count > 0; ++i) {
            ur stack = this._inventory.a(i);
            if (stack == null || stack.a == 1 && this._hideOnePerStack || ItemIdentifier.get(stack) != item) continue;
            int itemsToSplit = Math.min(count, stack.a - (first && this._hideOne || this._hideOnePerStack ? 1 : 0));
            first = false;
            if (itemsToSplit == 0) continue;
            ur removed = null;
            if (stack.a > itemsToSplit) {
                removed = stack.a(itemsToSplit);
                this._inventory.a(i, stack);
            } else {
                removed = stack;
                this._inventory.a(i, null);
            }
            if (outputStack == null) {
                outputStack = removed;
            } else {
                outputStack.a += removed.a;
            }
            count -= removed.a;
        }
        return outputStack;
    }

    @Override
    public boolean containsItem(ItemIdentifier item) {
        for (int i = 0; i < this._inventory.k_(); ++i) {
            ur stack = this._inventory.a(i);
            if (stack == null || ItemIdentifier.get(stack) != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier item) {
        for (int i = 0; i < this._inventory.k_(); ++i) {
            ur stack = this._inventory.a(i);
            if (stack == null || ItemIdentifier.getUndamaged(stack) != item) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, Integer.MAX_VALUE);
    }

    @Override
    public int roomForItem(ItemIdentifier item, int count) {
        int totalRoom = 0;
        int stackLimit = this._inventory.c();
        for (int i = 0; i < this._inventory.k_() && count > totalRoom; ++i) {
            ur stack = this._inventory.a(i);
            if (stack == null) {
                totalRoom += Math.min(stackLimit, item.getMaxStackSize());
                continue;
            }
            if (ItemIdentifier.get(stack) != item) continue;
            totalRoom += Math.min(stackLimit, item.getMaxStackSize()) - stack.a;
        }
        return totalRoom;
    }
}

