/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.List;
import logisticspipes.utils.ItemIdentifier;
import logisticspipes.utils.ItemIdentifierStack;

public class ItemMessage {
    public int id = 0;
    public int data = 0;
    public int amount = 0;
    public bq tag;

    public ItemMessage() {
    }

    public ItemMessage(int id, int data, int amount, bq tag) {
        this.id = id;
        this.data = data;
        this.amount = amount;
        this.tag = tag;
    }

    public ItemMessage(ItemIdentifier selectedItem, int requestCount) {
        this(selectedItem.itemID, selectedItem.itemDamage, requestCount, selectedItem.tag);
    }

    public ItemMessage(ItemIdentifierStack selectedItemStack) {
        this(selectedItemStack.getItem(), selectedItemStack.stackSize);
    }

    public String toString() {
        return this.amount + " " + ItemIdentifier.get(this.id, this.data, this.tag).getFriendlyName();
    }

    public ItemIdentifier getItemIdentifier() {
        return ItemIdentifier.get(this.id, this.data, this.tag);
    }

    public static void compress(List input) {
        for (int i = 0; i < input.size(); ++i) {
            ItemMessage one = (ItemMessage)input.get(i);
            for (int j = i + 1; j < input.size(); ++j) {
                ItemMessage two = (ItemMessage)input.get(j);
                if (one.id != two.id || one.data != two.data || one.tag != two.tag) continue;
                one.amount += two.amount;
                input.remove(j--);
            }
        }
    }
}

