/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import com.google.common.base.Objects;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListSet;
import logisticspipes.utils.ItemIdentifier;
import net.minecraftforge.liquids.LiquidDictionary;
import net.minecraftforge.liquids.LiquidStack;

public class LiquidIdentifier {
    private static final ConcurrentHashMap _liquidIdentifierCache = new ConcurrentHashMap();
    private static final ConcurrentSkipListSet _liquidIdentifierKeyQueue = new ConcurrentSkipListSet();
    public final int itemId;
    public final int itemMeta;
    public final String name;
    private static boolean init = false;

    private LiquidIdentifier(int itemId, int itemMeta, String name) {
        this.itemId = itemId;
        this.itemMeta = itemMeta;
        if (name == null) {
            name = "";
        }
        this.name = name;
        ItemKey key = new ItemKey(itemId, itemMeta);
        _liquidIdentifierCache.put(key, this);
        _liquidIdentifierKeyQueue.add(key);
    }

    public String getName() {
        return this.name;
    }

    public ItemIdentifier getItemIdentifier() {
        return ItemIdentifier.get(this.itemId, this.itemMeta, null);
    }

    public static LiquidIdentifier get(LiquidStack stack) {
        return LiquidIdentifier.get(stack.itemID, stack.itemMeta);
    }

    public static LiquidIdentifier get(LiquidStack stack, String name) {
        return LiquidIdentifier.get(stack.itemID, stack.itemMeta, name);
    }

    public static LiquidIdentifier get(int itemID, int itemMeta) {
        return LiquidIdentifier.get(itemID, itemMeta, "");
    }

    public static LiquidIdentifier get(int itemID, int itemMeta, String name) {
        if (_liquidIdentifierCache.containsKey(new ItemKey(itemID, itemMeta))) {
            return (LiquidIdentifier)_liquidIdentifierCache.get(new ItemKey(itemID, itemMeta));
        }
        return new LiquidIdentifier(itemID, itemMeta, name);
    }

    public static void initFromForge(boolean flag) {
        if (init) {
            return;
        }
        Map liquids = LiquidDictionary.getLiquids();
        for (Map.Entry name : liquids.entrySet()) {
            LiquidIdentifier.get((LiquidStack)name.getValue(), (String)name.getKey());
        }
        if (flag) {
            init = true;
        }
    }

    public String toString() {
        return this.name + "/" + this.itemId + ":" + this.itemMeta;
    }

    public LiquidIdentifier next() {
        ItemKey key = new ItemKey(this.itemId, this.itemMeta);
        if ((key = _liquidIdentifierKeyQueue.higher(key)) == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    public LiquidIdentifier prev() {
        ItemKey key = new ItemKey(this.itemId, this.itemMeta);
        if ((key = _liquidIdentifierKeyQueue.lower(key)) == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    public static LiquidIdentifier first() {
        ItemKey key = (ItemKey)_liquidIdentifierKeyQueue.first();
        if (key == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    public static LiquidIdentifier last() {
        ItemKey key = (ItemKey)_liquidIdentifierKeyQueue.last();
        if (key == null) {
            return null;
        }
        return (LiquidIdentifier)_liquidIdentifierCache.get(key);
    }

    private static class ItemKey
    implements Comparable {
        public int itemID;
        public int itemDamage;

        public ItemKey(int id, int d) {
            this.itemID = id;
            this.itemDamage = d;
        }

        public boolean equals(Object that) {
            if (!(that instanceof ItemKey)) {
                return false;
            }
            ItemKey i = (ItemKey)that;
            return this.itemID == i.itemID && this.itemDamage == i.itemDamage;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.itemID, this.itemDamage});
        }

        public int compareTo(ItemKey o) {
            if (this.itemID == o.itemID) {
                return this.itemDamage - o.itemDamage;
            }
            return this.itemID - o.itemID;
        }
    }
}

