/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.ic2;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import powercrystals.minefactoryreloaded.api.FarmingRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.fertilizables.FertilizerStandard;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableTreeLeaves;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableStandard;
import powercrystals.minefactoryreloaded.modhelpers.ic2.FertilizableIC2RubberTree;
import powercrystals.minefactoryreloaded.modhelpers.ic2.HarvestableIC2Crop;
import powercrystals.minefactoryreloaded.modhelpers.ic2.HarvestableIC2RubberWood;

@Mod(modid="MFReloaded|CompatIC2", name="MFR Compat: IC2", version="1.4.6R2.3.2", dependencies="after:MFReloaded;after:IC2")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class IC2 {
    @Mod.Init
    public static void load(FMLInitializationEvent e) {
        if (!Loader.isModLoaded((String)"IC2")) {
            FMLLog.warning((String)"IC2 missing - MFR IC2 Compat not loading", (Object[])new Object[0]);
            return;
        }
        try {
            Class<?> ic2Items = Class.forName("ic2.core.Ic2Items");
            if (ic2Items != null) {
                ur fertilizer;
                ur rubberSapling = (ur)ic2Items.getField("rubberSapling").get(null);
                ur rubberLeaves = (ur)ic2Items.getField("rubberLeaves").get(null);
                ur rubberWood = (ur)ic2Items.getField("rubberWood").get(null);
                ur stickyResin = (ur)ic2Items.getField("resin").get(null);
                ur crop = (ur)ic2Items.getField("crop").get(null);
                if (rubberSapling != null) {
                    FarmingRegistry.registerPlantable(new PlantableStandard(rubberSapling.c, rubberSapling.c));
                    FarmingRegistry.registerFertilizable(new FertilizableIC2RubberTree(rubberSapling.c));
                }
                if (rubberLeaves != null) {
                    FarmingRegistry.registerHarvestable(new HarvestableTreeLeaves(rubberLeaves.c));
                }
                if (rubberWood != null) {
                    FarmingRegistry.registerHarvestable(new HarvestableIC2RubberWood(rubberWood.c, HarvestType.Tree, stickyResin.c));
                }
                if ((fertilizer = (ur)ic2Items.getField("fertilizer").get(null)) != null) {
                    FarmingRegistry.registerFertilizer(new FertilizerStandard(fertilizer.c, fertilizer.j()));
                }
                FarmingRegistry.registerHarvestable(new HarvestableIC2Crop(crop.c));
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

