/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.modhelpers.pam;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.network.NetworkMod;
import java.lang.reflect.Method;
import powercrystals.minefactoryreloaded.api.FarmingRegistry;
import powercrystals.minefactoryreloaded.api.HarvestType;
import powercrystals.minefactoryreloaded.farmables.harvestables.HarvestableStandard;
import powercrystals.minefactoryreloaded.farmables.plantables.PlantableCropPlant;
import powercrystals.minefactoryreloaded.modhelpers.FertilizableCropReflection;
import powercrystals.minefactoryreloaded.modhelpers.pam.HarvestablePams;
import powercrystals.minefactoryreloaded.modhelpers.pam.HarvestablePamsPerennial;
import powercrystals.minefactoryreloaded.modhelpers.pam.PlantablePamRice;
import powercrystals.minefactoryreloaded.modhelpers.pam.PlantablePamWhiteMushroom;

@Mod(modid="MFReloaded|CompatPams", name="MFR Compat: Pam's Mods", version="1.4.6R2.3.2", dependencies="after:MFReloaded;after:PamHCBean;after:PamHCBellpepper;after:PamHCBlueberry;after:PamHCChilipepper;after:PamHCCorn;after:PamHCCotton;after:PamHCCucumber;after:PamHCGrape;after:PamHCLettuce;after:PamHCOnion;after:PamHCPeanut;after:PamHCRice;after:PamHCStrawberry;after:PamHCTomato;after:PamHCWhitemushroom;after:PamWeeeFlowers;after:PamHCBase")
@NetworkMod(clientSideRequired=false, serverSideRequired=false)
public class Pam {
    @Mod.Init
    public static void load(FMLInitializationEvent e) {
        if (!Loader.isModLoaded((String)"PamHCBase")) {
            FMLLog.warning((String)"Pam's HC base missing - MFR Pam HC Compat not loading", (Object[])new Object[0]);
        } else {
            Pam.registerPamMod("Bean", false, false);
            Pam.registerPamMod("Bellpepper", true, false);
            Pam.registerPamMod("Blueberry", true, true);
            Pam.registerPamMod("Chilipepper", true, false);
            Pam.registerPamMod("Corn", false, false);
            Pam.registerPamMod("Cotton", true, true);
            Pam.registerPamMod("Grape", true, true);
            Pam.registerPamMod("Cucumber", true, false);
            Pam.registerPamMod("Lettuce", false, false);
            Pam.registerPamMod("Onion", false, false);
            Pam.registerPamMod("Peanut", true, false);
            Pam.registerPamMod("Strawberry", true, true);
            Pam.registerPamMod("Tomato", true, false);
            Pam.registerPamRice();
            Pam.registerPamWhiteMushroom();
        }
        if (!Loader.isModLoaded((String)"PamWeeeFlowers")) {
            FMLLog.warning((String)"Pam's Weee! Flowers missing - MFR Pam Weee! Flowers Compat not loading", (Object[])new Object[0]);
        } else {
            String[] flowers = new String[]{"White", "Orange", "Magenta", "LightBlue", "Yellow", "Lime", "Pink", "LightGrey", "DarkGrey", "Cyan", "Purple", "Blue", "Brown", "Green", "Red", "Black"};
            try {
                Class<?> mod = Class.forName("pamsmods.common.weeeflowers.PamWeeeFlowers");
                FarmingRegistry.registerHarvestable(new HarvestableStandard(((amq)mod.getField((String)"pamFlower").get(null)).cm, HarvestType.Normal));
                for (String flower : flowers) {
                    int seedId = ((up)mod.getField((String)new StringBuilder().append((String)flower.toLowerCase()).append((String)"flowerseedItem").toString()).get(null)).cj;
                    int blockId = ((amq)mod.getField((String)new StringBuilder().append((String)"pam").append((String)flower.toLowerCase()).append((String)"flowerCrop").toString()).get(null)).cm;
                    Method fertilize = Class.forName("pamsmods.common.weeeflowers.BlockPam" + flower + "FlowerCrop").getMethod("fertilize", yc.class, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                    FarmingRegistry.registerPlantable(new PlantableCropPlant(seedId, blockId));
                    FarmingRegistry.registerHarvestable(new HarvestablePams(blockId));
                    FarmingRegistry.registerFertilizable(new FertilizableCropReflection(blockId, fertilize));
                }
            }
            catch (ClassNotFoundException x) {
                FMLLog.warning((String)"Unable to load Pam support for Weee! Flowers even though HarvestCraft base was present", (Object[])new Object[0]);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private static void registerPamMod(String modName, boolean isPerennial, boolean hasWild) {
        try {
            Class<?> mod = Class.forName("pamsmods.common.harvestcraft." + modName.toLowerCase() + ".PamHC" + modName);
            int blockIdCrop = ((amq)mod.getField((String)new StringBuilder().append((String)"pam").append((String)modName.toLowerCase()).append((String)"Crop").toString()).get(null)).cm;
            int seedId = ((up)mod.getField((String)new StringBuilder().append((String)modName.toLowerCase()).append((String)"seedItem").toString()).get(null)).cj;
            FarmingRegistry.registerPlantable(new PlantableCropPlant(seedId, blockIdCrop));
            if (hasWild) {
                int blockIdWild = ((amq)mod.getField((String)new StringBuilder().append((String)"pam").append((String)modName.toLowerCase()).append((String)"Wild").toString()).get(null)).cm;
                FarmingRegistry.registerHarvestable(new HarvestableStandard(blockIdWild, HarvestType.Normal));
            }
            if (isPerennial) {
                FarmingRegistry.registerHarvestable(new HarvestablePamsPerennial(blockIdCrop));
            } else {
                FarmingRegistry.registerHarvestable(new HarvestablePams(blockIdCrop));
            }
            FarmingRegistry.registerFertilizable(new FertilizableCropReflection(blockIdCrop, Class.forName("pamsmods.common.harvestcraft." + modName.toLowerCase() + ".BlockPam" + modName + "Crop").getMethod("fertilize", yc.class, Integer.TYPE, Integer.TYPE, Integer.TYPE)));
        }
        catch (ClassNotFoundException x) {
            FMLLog.warning((String)"Unable to load Pam support for %s even though HarvestCraft base was present", (Object[])new Object[]{modName});
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static void registerPamRice() {
        try {
            Class<?> mod = Class.forName("pamsmods.common.harvestcraft.rice.PamHCRice");
            int blockIdCrop = ((amq)mod.getField((String)"pamriceCrop").get(null)).cm;
            int seedId = ((up)mod.getField((String)"riceseedItem").get(null)).cj;
            FarmingRegistry.registerPlantable(new PlantablePamRice(blockIdCrop, seedId));
            FarmingRegistry.registerHarvestable(new HarvestablePams(blockIdCrop));
            FarmingRegistry.registerFertilizable(new FertilizableCropReflection(blockIdCrop, Class.forName("pamsmods.common.harvestcraft.rice.BlockPamRiceCrop").getMethod("fertilize", yc.class, Integer.TYPE, Integer.TYPE, Integer.TYPE)));
        }
        catch (ClassNotFoundException x) {
            FMLLog.warning((String)"Unable to load Pam support for Rice even though HarvestCraft base was present", (Object[])new Object[0]);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private static void registerPamWhiteMushroom() {
        try {
            Class<?> mod = Class.forName("pamsmods.common.harvestcraft.whitemushroom.PamHCWhitemushroom");
            int blockIdCrop = ((amq)mod.getField((String)"pamwhitemushroomCrop").get(null)).cm;
            int blockIdWild = ((amq)mod.getField((String)"pamwhitemushroomWild").get(null)).cm;
            int seedId = ((up)mod.getField((String)"whitemushroomseedItem").get(null)).cj;
            FarmingRegistry.registerPlantable(new PlantablePamWhiteMushroom(blockIdCrop, seedId));
            FarmingRegistry.registerHarvestable(new HarvestableStandard(blockIdWild, HarvestType.Normal));
            FarmingRegistry.registerHarvestable(new HarvestablePams(blockIdCrop));
            FarmingRegistry.registerFertilizable(new FertilizableCropReflection(blockIdCrop, Class.forName("pamsmods.common.harvestcraft.whitemushroom.BlockPamWhitemushroomCrop").getMethod("fertilize", yc.class, Integer.TYPE, Integer.TYPE, Integer.TYPE)));
        }
        catch (ClassNotFoundException x) {
            FMLLog.warning((String)"Unable to load Pam support for WhiteMushroom even though HarvestCraft base was present", (Object[])new Object[0]);
            x.printStackTrace();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

