/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.processing;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import powercrystals.minefactoryreloaded.core.MFRUtil;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryInventory;

public class TileEntityDeepStorageUnit
extends TileEntityFactoryInventory
implements ISidedInventory,
IDeepStorageUnit {
    private boolean[] _isSideOutput = new boolean[]{false, false, true, true, true, true};
    private int _storedQuantity;
    private int _storedId;
    private int _storedMeta;

    @Override
    public String getGuiBackground() {
        return "dsu.png";
    }

    public boolean getIsSideOutput(int side) {
        return this._isSideOutput[side];
    }

    public void setSideIsOutput(int side, boolean isOutput) {
        this._isSideOutput[side] = isOutput;
    }

    public int getQuantity() {
        return this._storedQuantity;
    }

    public int getQuantityAdjusted() {
        int quantity = this._storedQuantity;
        for (int i = 0; i < this.k_(); ++i) {
            if (this._inventory[i] != null && this._storedQuantity == 0) {
                quantity += this._inventory[i].a;
                continue;
            }
            if (this._inventory[i] == null || this._inventory[i].c != this._storedId || this._inventory[i].j() != this._storedMeta) continue;
            quantity += this._inventory[i].a;
        }
        return quantity;
    }

    public void setQuantity(int quantity) {
        this._storedQuantity = quantity;
    }

    public void clearSlots() {
        for (int i = 0; i < this.k_(); ++i) {
            this._inventory[i] = null;
        }
    }

    public int getId() {
        if (this._storedQuantity == 0 && this._inventory[2] != null) {
            return this._inventory[2].c;
        }
        return this._storedId;
    }

    public void setId(int id) {
        this._storedId = id;
    }

    public int getMeta() {
        if (this._storedQuantity == 0 && this._inventory[2] != null) {
            return this._inventory[2].j();
        }
        return this._storedMeta;
    }

    public void setMeta(int meta) {
        this._storedMeta = meta;
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    @Override
    public ForgeDirection getDropDirection() {
        return ForgeDirection.UP;
    }

    @Override
    public void g() {
        super.g();
        if (this.k.I) {
            return;
        }
        if (this._inventory[2] == null && this._storedQuantity > 0) {
            this._inventory[2] = new ur(this._storedId, Math.min(this._storedQuantity, new ur(this._storedId, 1, this._storedMeta).d()), this._storedMeta);
            this._storedQuantity -= this._inventory[2].a;
        } else if (this._inventory[2] != null && this._inventory[2].a < this._inventory[2].d() && this._inventory[2].c == this._storedId && this._inventory[2].j() == this._storedMeta && this._storedQuantity > 0) {
            int amount = Math.min(this._inventory[2].d() - this._inventory[2].a, this._storedQuantity);
            this._inventory[2].a += amount;
            this._storedQuantity -= amount;
        }
        this.checkInput(0);
        this.checkInput(1);
    }

    private void checkInput(int slot) {
        if (this._inventory[slot] != null) {
            if (this._storedQuantity == 0 && (this._inventory[2] == null || this._inventory[2].c == this._inventory[slot].c && this._inventory[2].j() == this._inventory[slot].j()) && this._inventory[slot].p() == null) {
                this._storedId = this._inventory[slot].c;
                this._storedMeta = this._inventory[slot].j();
                this._storedQuantity = this._inventory[slot].a;
                this._inventory[slot] = null;
            } else if (this._inventory[slot].c == this._storedId && this._inventory[slot].j() == this._storedMeta && this._inventory[slot].p() == null && 2147483581 - this._inventory[slot].a > this._storedQuantity) {
                if (this._inventory[slot].d() > 1) {
                    this._storedQuantity += this._inventory[slot].a - 1;
                    this._inventory[slot].a = 1;
                } else {
                    this._storedQuantity += this._inventory[slot].a;
                    this._inventory[slot] = null;
                }
            } else if (this._inventory[slot].c != this._storedId || this._inventory[slot].j() != this._storedMeta || this._inventory[slot].p() != null) {
                MFRUtil.dropStack(this, this._inventory[slot]);
                this._inventory[slot] = null;
            }
        }
        if (this._inventory[slot] == null && this._storedQuantity > 1 && this._inventory[2] != null && this._inventory[2].d() > 1) {
            this._inventory[slot] = new ur(this._storedId, 1, this._storedMeta);
            --this._storedQuantity;
        }
    }

    public int k_() {
        return 3;
    }

    public String b() {
        return "Deep Storage Unit";
    }

    @Override
    public int c() {
        return 64;
    }

    @Override
    public boolean a_(qx player) {
        return player.e((double)this.l, (double)this.m, (double)this.n) <= 64.0;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side.ordinal() > 5) {
            return 0;
        }
        return this._isSideOutput[side.ordinal()] ? 2 : 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        if (side.ordinal() > 5) {
            return 0;
        }
        return this._isSideOutput[side.ordinal()] ? 1 : 2;
    }

    @Override
    public void b(bq nbttagcompound) {
        super.b(nbttagcompound);
        nbttagcompound.a("storedId", this._storedId);
        nbttagcompound.a("storedMeta", this._storedMeta);
        nbttagcompound.a("storedQuantity", this._storedQuantity);
        nbttagcompound.a("side0output", this._isSideOutput[0]);
        nbttagcompound.a("side1output", this._isSideOutput[1]);
        nbttagcompound.a("side2output", this._isSideOutput[2]);
        nbttagcompound.a("side3output", this._isSideOutput[3]);
        nbttagcompound.a("side4output", this._isSideOutput[4]);
        nbttagcompound.a("side5output", this._isSideOutput[5]);
    }

    @Override
    public void a(bq nbttagcompound) {
        super.a(nbttagcompound);
        this._storedId = nbttagcompound.e("storedId");
        this._storedMeta = nbttagcompound.e("storedMeta");
        this._storedQuantity = nbttagcompound.e("storedQuantity");
        this._isSideOutput[0] = nbttagcompound.n("side0output");
        this._isSideOutput[1] = nbttagcompound.n("side1output");
        this._isSideOutput[2] = nbttagcompound.n("side2output");
        this._isSideOutput[3] = nbttagcompound.n("side3output");
        this._isSideOutput[4] = nbttagcompound.n("side4output");
        this._isSideOutput[5] = nbttagcompound.n("side5output");
    }

    @Override
    public ur getStoredItemType() {
        if (this._storedQuantity > 0 || this._inventory[2] != null) {
            return new ur(this._storedId, this.getQuantityAdjusted(), this._storedMeta);
        }
        return null;
    }

    @Override
    public void setStoredItemCount(int amount) {
        this.clearSlots();
        this._storedQuantity = amount;
    }

    @Override
    public void setStoredItemType(int itemID, int meta, int Count) {
        this.clearSlots();
        this._storedId = itemID;
        this._storedMeta = meta;
        this._storedQuantity = Count;
    }

    @Override
    public int getMaxStoredCount() {
        return Integer.MAX_VALUE;
    }
}

