/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.minefactoryreloaded.transport;

import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidContainerRegistry;
import net.minecraftforge.liquids.LiquidStack;
import net.minecraftforge.liquids.LiquidTank;
import powercrystals.core.position.BlockPosition;
import powercrystals.minefactoryreloaded.core.TileEntityFactoryInventory;

public class TileEntityLiquidRouter
extends TileEntityFactoryInventory
implements ITankContainer {
    private LiquidTank[] _bufferTanks = new LiquidTank[6];
    private static final ForgeDirection[] _outputDirections = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.NORTH, ForgeDirection.SOUTH, ForgeDirection.EAST, ForgeDirection.WEST};

    public TileEntityLiquidRouter() {
        for (int i = 0; i < 6; ++i) {
            this._bufferTanks[i] = new LiquidTank(1000);
            this._bufferTanks[i].setTankPressure(-1);
        }
    }

    @Override
    public void g() {
        super.g();
        for (int i = 0; i < 6; ++i) {
            if (this._bufferTanks[i].getLiquid() == null || this._bufferTanks[i].getLiquid().amount <= 0) continue;
            this._bufferTanks[i].getLiquid().amount -= this.pumpLiquid(this._bufferTanks[i].getLiquid(), true);
        }
    }

    private int pumpLiquid(LiquidStack resource, boolean doFill) {
        any te;
        if (resource == null || resource.itemID <= 0 || resource.amount <= 0) {
            return 0;
        }
        int amountRemaining = resource.amount;
        for (int i = 0; !(i >= 6 || LiquidContainerRegistry.containsLiquid((ur)this._inventory[i], (LiquidStack)resource) && (te = BlockPosition.getAdjacentTileEntity((any)this, (ForgeDirection)_outputDirections[i])) != null && te instanceof ITankContainer && (amountRemaining -= ((ITankContainer)te).fill(_outputDirections[i].getOpposite(), new LiquidStack(resource.itemID, amountRemaining, resource.itemMeta), doFill)) <= 0); ++i) {
        }
        return resource.amount - amountRemaining;
    }

    @Override
    public boolean canRotate() {
        return false;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.pumpLiquid(resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return this.pumpLiquid(resource, doFill);
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return null;
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        return null;
    }

    public ILiquidTank[] getTanks(ForgeDirection direction) {
        return new ILiquidTank[]{this._bufferTanks[direction.ordinal()]};
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        if (LiquidContainerRegistry.containsLiquid((ur)this._inventory[direction.ordinal()], (LiquidStack)type)) {
            return this._bufferTanks[direction.ordinal()];
        }
        return null;
    }

    public int k_() {
        return 6;
    }

    public String b() {
        return "Liquid Router";
    }

    @Override
    public String getGuiBackground() {
        return "liquidrouter.png";
    }
}

