/*
 * Decompiled with CFR 0.152.
 */
package universalelectricity.prefab;

import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.registry.LanguageRegistry;

public class TranslationHelper {
    public static int loadLanguages(String languagePath, String[] languageSupported) {
        int languages = 0;
        for (String language : languageSupported) {
            LanguageRegistry.instance().loadLocalization(languagePath + language + ".properties", language, false);
            if (LanguageRegistry.instance().getStringLocalization("children", language) != "") {
                try {
                    String[] children;
                    for (String child : children = LanguageRegistry.instance().getStringLocalization("children", language).split(",")) {
                        if (child == "" && child == null) continue;
                        LanguageRegistry.instance().loadLocalization(languagePath + language + ".properties", child, false);
                        ++languages;
                    }
                }
                catch (Exception e) {
                    FMLLog.severe((String)"Failed to load a child language file.", (Object[])new Object[0]);
                    e.printStackTrace();
                }
            }
            ++languages;
        }
        return languages;
    }

    public static String getLocal(String key) {
        String text = LanguageRegistry.instance().getStringLocalization(key);
        if (text == null || text == "") {
            text = LanguageRegistry.instance().getStringLocalization(key, "en_US");
        }
        return text;
    }
}

