/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.position;

import java.util.ArrayList;
import java.util.List;
import powercrystals.core.position.BlockPosition;

public class Area {
    public int xMin;
    public int xMax;
    public int yMin;
    public int yMax;
    public int zMin;
    public int zMax;
    private BlockPosition _origin;

    public Area(int xMin, int xMax, int yMin, int yMax, int zMin, int zMax) {
        this.xMin = xMin;
        this.xMax = xMax;
        this.yMin = yMin;
        this.yMax = yMax;
        this.zMin = zMin;
        this.zMax = zMax;
    }

    public Area(BlockPosition center, int radius, int yNegOffset, int yPosOffset) {
        this.xMin = center.x - radius;
        this.xMax = center.x + radius;
        this.yMin = center.y - yNegOffset;
        this.yMax = center.y + yPosOffset;
        this.zMin = center.z - radius;
        this.zMax = center.z + radius;
        this._origin = center;
    }

    public BlockPosition getMin() {
        return new BlockPosition(this.xMin, this.yMin, this.zMin);
    }

    public BlockPosition getMax() {
        return new BlockPosition(this.xMax, this.yMax, this.zMax);
    }

    public List getPositionsTopFirst() {
        ArrayList<BlockPosition> positions = new ArrayList<BlockPosition>();
        for (int y = this.yMax; y >= this.yMin; --y) {
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int z = this.zMin; z <= this.zMax; ++z) {
                    positions.add(new BlockPosition(x, y, z));
                }
            }
        }
        return positions;
    }

    public List getPositionsBottomFirst() {
        ArrayList<BlockPosition> positions = new ArrayList<BlockPosition>();
        for (int y = this.yMin; y <= this.yMax; ++y) {
            for (int x = this.xMin; x <= this.xMax; ++x) {
                for (int z = this.zMin; z <= this.zMax; ++z) {
                    positions.add(new BlockPosition(x, y, z));
                }
            }
        }
        return positions;
    }

    public BlockPosition getOrigin() {
        return this._origin.copy();
    }

    public aoe toAxisAlignedBB() {
        return aoe.a((double)this.xMin, (double)this.yMin, (double)this.zMin, (double)(this.xMax + 1), (double)(this.yMax + 1), (double)(this.zMax + 1));
    }
}

