/*
 * Decompiled with CFR 0.152.
 */
package powercrystals.core.updater;

import cpw.mods.fml.common.IScheduledTickHandler;
import cpw.mods.fml.common.TickType;
import java.util.EnumSet;
import powercrystals.core.CoreCore;
import powercrystals.core.updater.IUpdateableMod;
import powercrystals.core.updater.UpdateCheckThread;

public class UpdateManager
implements IScheduledTickHandler {
    private boolean _notificationDisplayed;
    private IUpdateableMod _mod;
    private UpdateCheckThread _updateThread;

    public UpdateManager(IUpdateableMod mod) {
        this._mod = mod;
        this._updateThread = new UpdateCheckThread(mod);
        if (CoreCore.doUpdateCheck.getBoolean(true)) {
            this._updateThread.start();
        }
    }

    public void tickStart(EnumSet type, Object ... tickData) {
        if (!this._notificationDisplayed && this._updateThread.checkComplete()) {
            this._notificationDisplayed = true;
            if (this._updateThread.newVersionAvailable()) {
                qx player = (qx)tickData[0];
                player.a("[" + this._mod.getModName() + "] A new version is available: " + this._updateThread.newVersion().modVersion().toString());
                player.a(this._updateThread.newVersion().description());
            }
        }
    }

    public void tickEnd(EnumSet type, Object ... tickData) {
    }

    public EnumSet ticks() {
        if (this._notificationDisplayed) {
            return EnumSet.noneOf(TickType.class);
        }
        return EnumSet.of(TickType.PLAYER);
    }

    public String getLabel() {
        return this._mod.getModId() + ".version";
    }

    public int nextTickSpacing() {
        if (!this._notificationDisplayed) {
            return 400;
        }
        return 72000;
    }
}

