/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.gui;

import cpw.mods.fml.common.network.PacketDispatcher;
import railcraft.client.gui.TileGui;
import railcraft.client.gui.buttons.GuiToggleButtonSmall;
import railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import railcraft.common.gui.containers.ContainerLiquidLoader;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.util.misc.Game;
import railcraft.common.util.network.PacketGuiReturn;

public class GuiLoaderLiquid
extends TileGui {
    private static final String FILTER_LABEL = RailcraftLanguage.translate("gui.filters");
    private final TileLiquidLoader tile;
    private GuiToggleButtonSmall empty;
    private GuiToggleButtonSmall full;

    public GuiLoaderLiquid(qw inv, TileLiquidLoader tile) {
        super(tile, new ContainerLiquidLoader(inv, tile), "/railcraft/client/textures/gui/gui_liquid_loader.png");
        this.tile = tile;
    }

    public void A_() {
        super.A_();
        if (this.tile == null) {
            return;
        }
        this.i.clear();
        int w = (this.g - this.b) / 2;
        int h = (this.h - this.c) / 2;
        this.empty = new GuiToggleButtonSmall(0, w + 40, h + 45, 65, RailcraftLanguage.translate("gui.liquid.loader.empty"), this.tile.waitIfEmpty());
        this.i.add(this.empty);
        this.full = new GuiToggleButtonSmall(1, w + 40, h + 62, 65, RailcraftLanguage.translate("gui.liquid.loader.fill"), this.tile.waitTillFull());
        this.i.add(this.full);
    }

    protected void b(int mouseX, int mouseY) {
        int sWidth = this.l.a(this.tile.b());
        int sPos = this.b / 2 - sWidth / 2;
        this.l.b(this.tile.b(), sPos, 6, 0x404040);
        this.l.b(FILTER_LABEL, 85, 25, 0x404040);
    }

    protected void a(atb guibutton) {
        if (this.tile == null) {
            return;
        }
        if (guibutton.f == 0) {
            this.setWaitIfEmpty(!this.tile.waitIfEmpty());
        }
        if (guibutton.f == 1) {
            this.setWaitTillFull(!this.tile.waitTillFull());
        }
    }

    private void setWaitIfEmpty(boolean set) {
        this.tile.setWaitIfEmpty(set);
        this.empty.active = set;
        if (!set) {
            this.setWaitTillFull(false);
        }
    }

    private void setWaitTillFull(boolean set) {
        this.tile.setWaitTillFull(set);
        this.full.active = set;
        if (set) {
            this.setWaitIfEmpty(true);
        }
    }

    public void b() {
        this.tile.setWaitIfEmpty(this.empty.active);
        this.tile.setWaitTillFull(this.full.active);
        if (Game.isNotHost(this.tile.getWorld())) {
            PacketGuiReturn pkt = new PacketGuiReturn(this.tile);
            PacketDispatcher.sendPacketToServer((ef)pkt.getPacket());
        }
    }
}

