/*
 * Decompiled with CFR 0.152.
 */
package railcraft.client.render;

import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.liquids.LiquidStack;
import org.lwjgl.opengl.GL11;
import railcraft.client.render.LiquidRenderer;
import railcraft.client.render.RenderFakeBlock;
import railcraft.common.blocks.machine.gamma.TileLiquidLoader;
import railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.misc.FakeBlockRenderInfo;

public class RenderLiquidLoader
extends bdx {
    private static final float PIPE_OFFSET = 0.3125f;
    private static final int[] PIPE_TEXTURE = new int[]{228, 228, 212, 212, 212, 212};
    private static final FakeBlockRenderInfo backDrop = new FakeBlockRenderInfo();
    private static final FakeBlockRenderInfo pipe = new FakeBlockRenderInfo();

    public RenderLiquidLoader() {
        RenderLiquidLoader.backDrop.minX = 0.011f;
        RenderLiquidLoader.backDrop.minY = 0.01f;
        RenderLiquidLoader.backDrop.minZ = 0.011f;
        RenderLiquidLoader.backDrop.maxX = 0.989f;
        RenderLiquidLoader.backDrop.maxY = 0.99f;
        RenderLiquidLoader.backDrop.maxZ = 0.989f;
        RenderLiquidLoader.pipe.texture = PIPE_TEXTURE;
        RenderLiquidLoader.pipe.minX = 0.3125f;
        RenderLiquidLoader.pipe.minZ = 0.3125f;
        RenderLiquidLoader.pipe.maxX = 0.6875f;
        RenderLiquidLoader.pipe.maxY = 0.0625f;
        RenderLiquidLoader.pipe.maxZ = 0.6875f;
    }

    public void a(any tile, double x, double y, double z, float f) {
        int[] displayLists;
        TileLoaderLiquidBase base = (TileLoaderLiquidBase)tile;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)8192);
        GL11.glTranslatef((float)((float)x + 0.5f), (float)((float)y + 0.5f), (float)((float)z + 0.5f));
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        GL11.glScalef((float)1.0f, (float)0.6f, (float)1.0f);
        StandardTank tank = base.getTankManager().getTank(0);
        LiquidStack liquid = tank.getLiquid();
        if (liquid != null && liquid.amount > 0 && (displayLists = LiquidRenderer.getLiquidDisplayLists(liquid)) != null) {
            GL11.glPushMatrix();
            if (LiquidRenderer.bindLiquidTexture(liquid) != -1) {
                float cap = tank.getCapacity();
                float level = Math.min((float)liquid.amount, cap) / cap;
                GL11.glCallList((int)displayLists[(int)(level * 99.0f)]);
            }
            GL11.glPopMatrix();
        }
        ForgeHooksClient.bindTexture((String)"/railcraft/client/textures/machines.png", (int)0);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
        RenderLiquidLoader.backDrop.texture = new int[]{25};
        RenderFakeBlock.renderBlock(backDrop, (ym)base.getWorld(), x, y, z, false, true);
        if (tile.getClass() == TileLiquidLoader.class) {
            TileLiquidLoader loader = (TileLiquidLoader)tile;
            RenderLiquidLoader.pipe.minY = 0.0625f - loader.getPipeLenght();
            RenderFakeBlock.renderBlock(pipe, (ym)loader.getWorld(), x, y, z, false, true);
        }
        ForgeHooksClient.unbindTexture();
    }
}

