/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Random;
import java.util.Set;
import railcraft.common.api.core.WorldCoordinate;
import railcraft.common.api.signals.SignalTools;

public abstract class AbstractPair {
    private static final int PAIR_CHECK_INTERVAL = 128;
    protected static final Random rand = new Random();
    public final any tile;
    private WorldCoordinate coords;
    public final String name;
    public final int maxPairings;
    private boolean isBeingPaired;
    protected Deque pairings = new LinkedList();
    protected Set invalidPairings = new HashSet();
    private int update = rand.nextInt();
    private boolean needsInit = true;

    public AbstractPair(String name, any tile, int maxPairings) {
        this.tile = tile;
        this.maxPairings = maxPairings;
        this.name = name;
    }

    protected void addPairing(WorldCoordinate other) {
        this.pairings.add(other);
        while (this.pairings.size() > this.getMaxPairings()) {
            this.pairings.remove();
        }
        SignalTools.packetBuilder.sendPairPacketUpdate(this);
    }

    public void clearPairing(WorldCoordinate other) {
        this.invalidPairings.add(other);
    }

    public void endPairing() {
        this.isBeingPaired = false;
    }

    public void tickClient() {
        if (this.needsInit) {
            this.needsInit = false;
            SignalTools.packetBuilder.sendPairPacketRequest(this);
        }
    }

    public void tickServer() {
        ++this.update;
        if (this.update % 128 == 0) {
            this.validatePairings();
        }
    }

    protected void validatePairings() {
        for (WorldCoordinate coord : this.pairings) {
            this.getPairAt(coord);
        }
        this.cleanPairings();
    }

    public void cleanPairings() {
        boolean changed = this.pairings.removeAll(this.invalidPairings);
        this.invalidPairings.clear();
        if (changed) {
            SignalTools.packetBuilder.sendPairPacketUpdate(this);
        }
    }

    protected any getPairAt(WorldCoordinate coord) {
        if (!this.pairings.contains(coord)) {
            return null;
        }
        if (coord.y < 0) {
            return null;
        }
        int x = coord.x;
        int y = coord.y;
        int z = coord.z;
        if (!this.tile.k.f(x, y, z)) {
            return null;
        }
        any target = this.tile.k.q(x, y, z);
        if (this.isValidPair(target)) {
            return target;
        }
        this.clearPairing(coord);
        return null;
    }

    public abstract boolean isValidPair(any var1);

    public WorldCoordinate getCoords() {
        if (this.coords == null) {
            this.coords = new WorldCoordinate(this.tile.k.u.h, this.tile.l, this.tile.m, this.tile.n);
        }
        return this.coords;
    }

    public String getName() {
        return this.name;
    }

    public int getMaxPairings() {
        return this.maxPairings;
    }

    public int getNumPairs() {
        return this.pairings.size();
    }

    public boolean isPaired() {
        return !this.pairings.isEmpty();
    }

    public Collection getPairs() {
        return Collections.unmodifiableCollection(this.pairings);
    }

    public any getTile() {
        return this.tile;
    }

    public void startPairing() {
        this.isBeingPaired = true;
    }

    public boolean isBeingPaired() {
        return this.isBeingPaired;
    }

    public boolean isPairedWith(WorldCoordinate other) {
        return this.pairings.contains(other);
    }

    protected abstract String getTagName();

    public final void writeToNBT(bq data) {
        bq tag = new bq();
        this.saveNBT(tag);
        data.a(this.getTagName(), tag);
    }

    protected void saveNBT(bq data) {
        by list = new by();
        for (WorldCoordinate c : this.pairings) {
            bq tag = new bq();
            tag.a("coords", new int[]{c.dimension, c.x, c.y, c.z});
            list.a((cd)tag);
        }
        data.a("pairings", (cd)list);
    }

    public final void readFromNBT(bq data) {
        bq tag = data.l(this.getTagName());
        this.loadNBT(tag);
    }

    protected void loadNBT(bq data) {
        by list = data.m("pairings");
        for (int entry = 0; entry < list.c(); entry = (int)((byte)(entry + 1))) {
            bq tag = (bq)list.b(entry);
            int[] c = tag.k("coords");
            this.pairings.add(new WorldCoordinate(c[0], c[1], c[2], c[3]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void addPair(int x, int y, int z) {
        this.pairings.add(new WorldCoordinate(0, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public void removePair(int x, int y, int z) {
        this.pairings.remove(new WorldCoordinate(0, x, y, z));
    }

    public void clearPairings() {
        this.pairings.clear();
        if (!this.tile.k.I) {
            SignalTools.packetBuilder.sendPairPacketUpdate(this);
        }
    }
}

