/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.api.signals;

public enum SignalAspect {
    GREEN(0),
    BLINK_YELLOW(1),
    YELLOW(1),
    BLINK_RED(2),
    RED(2),
    OFF(3);

    private final int textureOffset;
    private static boolean blinkState;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private SignalAspect() {
        void textureOffset;
        this.textureOffset = textureOffset;
    }

    public int getTextureOffset() {
        return this.textureOffset;
    }

    public boolean isBlinkAspect() {
        return this == BLINK_YELLOW || this == BLINK_RED;
    }

    public boolean isLit() {
        if (this == OFF) {
            return false;
        }
        if (this == BLINK_YELLOW || this == BLINK_RED) {
            return SignalAspect.isBlinkOn();
        }
        return true;
    }

    public static boolean isBlinkOn() {
        return blinkState;
    }

    public static void invertBlinkState() {
        blinkState = !blinkState;
    }

    public static SignalAspect mostRestrictive(SignalAspect first, SignalAspect second) {
        if (first == null && second == null) {
            return RED;
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        if (first == OFF || second == OFF) {
            return RED;
        }
        if (first.ordinal() > second.ordinal()) {
            return first;
        }
        return second;
    }

    public String toString() {
        String[] sa = this.name().split("_");
        String out = "";
        for (String s : sa) {
            out = out + s.substring(0, 1) + s.substring(1).toLowerCase() + " ";
        }
        out = out.trim();
        return out;
    }
}

