/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Arrays;
import net.minecraftforge.common.MinecraftForge;
import railcraft.common.api.core.items.ItemRegistry;
import railcraft.common.blocks.aesthetics.post.BlockPost;
import railcraft.common.blocks.aesthetics.post.BlockPostMetal;
import railcraft.common.blocks.aesthetics.post.EnumPost;
import railcraft.common.blocks.aesthetics.post.ItemPost;
import railcraft.common.blocks.aesthetics.post.ItemPostMetal;
import railcraft.common.blocks.detector.BlockDetector;
import railcraft.common.blocks.detector.ItemDetector;
import railcraft.common.blocks.machine.BlockMachine;
import railcraft.common.blocks.machine.ItemMachine;
import railcraft.common.blocks.machine.alpha.EnumMachineAlpha;
import railcraft.common.blocks.machine.alpha.MachineProxyAlpha;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.blocks.machine.beta.MachineProxyBeta;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.machine.gamma.MachineProxyGamma;
import railcraft.common.blocks.signals.BlockSignal;
import railcraft.common.blocks.signals.ItemSignal;
import railcraft.common.blocks.tracks.BlockTrack;
import railcraft.common.blocks.tracks.BlockTrackElevator;
import railcraft.common.blocks.tracks.ItemTrack;
import railcraft.common.core.Railcraft;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.RailcraftPartItems;
import railcraft.common.lang.RailcraftLanguage;
import railcraft.common.plugins.forestry.ForestryPlugin;

public class RailcraftBlocks {
    private static amq blockDetector;
    private static amq blockMachineAlpha;
    private static amq blockMachineBeta;
    private static amq blockMachineGamma;
    private static amq blockTrack;
    private static amq blockRailElevator;
    private static amq blockSignal;
    private static amq blockPost;
    private static amq blockPostMetal;

    public static void registerBlockTrack() {
        int id;
        if (blockTrack == null && (id = RailcraftConfig.getBlockId("block.track")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockTrack = new BlockTrack(id, renderId).b("railcraftTrack");
            GameRegistry.registerBlock((amq)blockTrack, ItemTrack.class, (String)blockTrack.a());
            MinecraftForge.setBlockHarvestLevel((amq)blockTrack, (String)"crowbar", (int)0);
            MinecraftForge.setBlockHarvestLevel((amq)blockTrack, (String)"pickaxe", (int)0);
        }
    }

    public static amq getBlockTrack() {
        return blockTrack;
    }

    public static void registerBlockRailElevator() {
        int id;
        if (blockRailElevator == null && (id = RailcraftConfig.getBlockId("block.elevator")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockRailElevator = new BlockTrackElevator(id, renderId).b("elevatorRail");
            GameRegistry.registerBlock((amq)blockRailElevator, (String)blockRailElevator.a());
            MinecraftForge.setBlockHarvestLevel((amq)blockRailElevator, (String)"crowbar", (int)0);
            MinecraftForge.setBlockHarvestLevel((amq)blockRailElevator, (String)"pickaxe", (int)0);
            ur stackElevator = new ur(blockRailElevator, 8);
            GameRegistry.addRecipe((ur)stackElevator, (Object[])new Object[]{"IRI", "ISI", "IRI", Character.valueOf('I'), RailcraftPartItems.getRailAdvanced(), Character.valueOf('S'), RailcraftPartItems.getRailStandard(), Character.valueOf('R'), up.aC});
            RailcraftLanguage.getInstance().registerItemName(stackElevator, "track.elevator");
            ItemRegistry.registerItem("track.elevator", stackElevator);
        }
    }

    public static amq getBlockElevator() {
        return blockRailElevator;
    }

    public static void registerBlockDetector() {
        int id;
        if (blockDetector == null && (id = RailcraftConfig.getBlockId("block.detector")) > 0) {
            blockDetector = new BlockDetector(id).b("cartDetector");
            GameRegistry.registerBlock((amq)blockDetector, ItemDetector.class, (String)blockDetector.a());
            for (BlockDetector.Detector d : BlockDetector.Detector.values()) {
                ur stack = new ur(blockDetector, 1, d.ordinal());
                String tag = BlockDetector.getBlockNameFromMetadata(d.ordinal());
                RailcraftLanguage.getInstance().registerItemName(stack, tag);
                ItemRegistry.registerItem(tag, stack);
            }
        }
    }

    public static amq getBlockDetector() {
        return blockDetector;
    }

    public static void registerBlockMachineAlpha() {
        int id;
        if (blockMachineAlpha == null && (id = RailcraftConfig.getBlockId("block.machine.alpha")) > 0) {
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            blockMachineAlpha = new BlockMachine(id, 0, new MachineProxyAlpha(), true, lightOpacity).b("rcBlockMachineAlpha");
            GameRegistry.registerBlock((amq)blockMachineAlpha, ItemMachine.class, (String)blockMachineAlpha.a());
            block4: for (EnumMachineAlpha type : EnumMachineAlpha.values()) {
                switch (type) {
                    case FEED_STATION: 
                    case TANK_WATER: {
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"axe", (int)1);
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                        continue block4;
                    }
                    case WORLD_ANCHOR: 
                    case PERSONAL_ANCHOR: {
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"pickaxe", (int)3);
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                        continue block4;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"pickaxe", (int)2);
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                    }
                }
            }
        }
    }

    public static amq getBlockMachineAlpha() {
        return blockMachineAlpha;
    }

    public static void registerBlockMachineBeta() {
        int id;
        if (blockMachineBeta == null && (id = RailcraftConfig.getBlockId("block.machine.beta")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_HOBBY.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_LOW.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.ENGINE_STEAM_HIGH.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_WALL.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_VALVE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.TANK_IRON_GAUGE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.BOILER_TANK_LOW_PRESSURE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.BOILER_TANK_HIGH_PRESSURE.ordinal()] = 0;
            lightOpacity[EnumMachineBeta.SENTINEL.ordinal()] = 0;
            blockMachineBeta = new BlockMachine(id, renderId, new MachineProxyBeta(), false, lightOpacity).b("rcBlockMachineBeta");
            GameRegistry.registerBlock((amq)blockMachineBeta, ItemMachine.class, (String)blockMachineBeta.a());
            block3: for (EnumMachineBeta type : EnumMachineBeta.values()) {
                switch (type) {
                    case SENTINEL: {
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"pickaxe", (int)3);
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineAlpha, (int)type.ordinal(), (String)"crowbar", (int)0);
                        continue block3;
                    }
                    default: {
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineBeta, (int)type.ordinal(), (String)"pickaxe", (int)2);
                        MinecraftForge.setBlockHarvestLevel((amq)blockMachineBeta, (int)type.ordinal(), (String)"crowbar", (int)0);
                    }
                }
            }
        }
    }

    public static amq getBlockMachineBeta() {
        return blockMachineBeta;
    }

    public static void registerBlockMachineGamma() {
        int id;
        if (blockMachineGamma == null && (id = RailcraftConfig.getBlockId("block.machine.gamma")) > 0) {
            int[] lightOpacity = new int[16];
            Arrays.fill(lightOpacity, 255);
            lightOpacity[EnumMachineGamma.LIQUID_LOADER.ordinal()] = 0;
            lightOpacity[EnumMachineGamma.LIQUID_UNLOADER.ordinal()] = 0;
            blockMachineGamma = new BlockMachine(id, 0, new MachineProxyGamma(), false, lightOpacity).b("rcBlockMachineGamma");
            blockMachineGamma.a(tj.e);
            GameRegistry.registerBlock((amq)blockMachineGamma, ItemMachine.class, (String)blockMachineGamma.a());
            for (EnumMachineGamma type : EnumMachineGamma.values()) {
                switch (type) {
                    default: 
                }
                MinecraftForge.setBlockHarvestLevel((amq)blockMachineGamma, (int)type.ordinal(), (String)"pickaxe", (int)2);
                MinecraftForge.setBlockHarvestLevel((amq)blockMachineGamma, (int)type.ordinal(), (String)"crowbar", (int)0);
            }
        }
    }

    public static amq getBlockMachineGamma() {
        return blockMachineGamma;
    }

    public static void registerBlockSignal() {
        int id;
        if (blockSignal == null && (id = RailcraftConfig.getBlockId("block.signal")) > 0) {
            int renderId = Railcraft.getProxy().getRenderId();
            blockSignal = new BlockSignal(id, renderId);
            GameRegistry.registerBlock((amq)blockSignal, ItemSignal.class, (String)blockSignal.a());
            MinecraftForge.setBlockHarvestLevel((amq)blockSignal, (String)"pickaxe", (int)2);
            MinecraftForge.setBlockHarvestLevel((amq)blockSignal, (String)"crowbar", (int)0);
        }
    }

    public static amq getBlockSignal() {
        return blockSignal;
    }

    public static void registerBlockPost() {
        int id;
        if (blockPost == null && (id = RailcraftConfig.getBlockId("block.post")) > 0) {
            blockPost = new BlockPost(id, Railcraft.getProxy().getRenderId());
            GameRegistry.registerBlock((amq)blockPost, ItemPost.class, (String)blockPost.a());
            for (EnumPost post : EnumPost.values()) {
                ForestryPlugin.addBackpackItem("builder", post.getItem());
            }
        }
    }

    public static amq getBlockPost() {
        return blockPost;
    }

    public static void registerBlockPostMetal() {
        int id;
        if (blockPostMetal == null && (id = RailcraftConfig.getBlockId("block.post.metal")) > 0) {
            blockPostMetal = new BlockPostMetal(id, Railcraft.getProxy().getRenderId());
            GameRegistry.registerBlock((amq)blockPostMetal, ItemPostMetal.class, (String)blockPostMetal.a());
            for (int i = 0; i < 16; ++i) {
                ForestryPlugin.addBackpackItem("builder", new ur(blockPostMetal, 1, i));
            }
        }
    }

    public static amq getBlockPostMetal() {
        return blockPostMetal;
    }
}

