/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.beta;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.liquids.ILiquidTank;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.beta.EnumMachineBeta;
import railcraft.common.blocks.machine.beta.TileTankIron;
import railcraft.common.liquids.TankManager;
import railcraft.common.liquids.TankWrapper;
import railcraft.common.liquids.tanks.FakeTank;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileTankIronValve
extends TileTankIron
implements ITankContainer {
    private static final byte FILL_DURATION = 20;
    private byte filling = 0;

    private void setFilling() {
        boolean needsUpdate = false;
        if (this.filling == 0) {
            needsUpdate = true;
        }
        this.filling = (byte)20;
        if (needsUpdate) {
            this.sendUpdateToClient();
        }
    }

    private void decrementFilling() {
        byte f = this.filling;
        if (this.filling > 0) {
            this.filling = (byte)(this.filling - 1);
        }
        if (this.filling == 0 && f != 0) {
            this.sendUpdateToClient();
        }
    }

    public boolean isFilling() {
        return this.filling > 0;
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineBeta.TANK_IRON_VALVE;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isNotHost(this.k)) {
            return;
        }
        this.decrementFilling();
        if (this.isMaster) {
            LiquidStack available;
            any tileBelow = this.k.q(this.l, this.m - 1, this.n);
            TileTankIronValve tankBelow = null;
            if (tileBelow instanceof TileTankIronValve) {
                tankBelow = (TileTankIronValve)tileBelow;
                if (tankBelow.isStructureValid() && tankBelow.getPatternMarker() == 'T') {
                    StandardTank tank = tankBelow.getTankManager().getTank(0);
                    LiquidStack liquid = tank.getLiquid();
                    if (liquid != null && liquid.amount >= tank.getCapacity() - 1000) {
                        int used;
                        tankBelow = null;
                        LiquidStack fillStack = liquid.copy();
                        fillStack.amount = 1000 - (tank.getCapacity() - liquid.amount);
                        if (fillStack.amount > 0 && (used = this.fill(0, fillStack, false)) > 0) {
                            fillStack = tank.drain(used, true);
                            this.fill(0, fillStack, true);
                        }
                    }
                } else {
                    tankBelow = null;
                }
            }
            if (tankBelow != null && (available = this.tankManager.drain(0, 1000, false)) != null && available.amount > 0) {
                int used = tankBelow.fill(ForgeDirection.UP, available, true);
                this.tankManager.drain(0, used, true);
            }
        }
    }

    @Override
    public int getBlockTexture(int side) {
        if (!this.isStructureValid() || this.getPattern() == null) {
            return EnumMachineBeta.TANK_IRON_VALVE.getTexture(side);
        }
        ForgeDirection s = ForgeDirection.getOrientation((int)side);
        char markerSide = this.getPattern().getPatternMarkerChecked(MiscTools.getXOnSide(this.getPatternPositionX(), s), MiscTools.getYOnSide(this.getPatternPositionY(), s), MiscTools.getZOnSide(this.getPatternPositionZ(), s));
        if (!this.isMapPositionOtherBlock(markerSide)) {
            if (side == ForgeDirection.UP.ordinal() || side == ForgeDirection.DOWN.ordinal()) {
                return EnumMachineBeta.TANK_IRON_VALVE.getTexture(6);
            }
            return EnumMachineBeta.TANK_IRON_VALVE.getTexture(7);
        }
        return EnumMachineBeta.TANK_IRON_VALVE.getTexture(side);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.filling);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.filling = data.readByte();
    }

    public LiquidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        return this.drain(0, maxDrain, doDrain);
    }

    public LiquidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (this.getPatternPositionY() - this.getPattern().getMasterOffsetY() > 1) {
            return null;
        }
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.drain(tankIndex, maxDrain, doDrain);
        }
        return null;
    }

    public int fill(ForgeDirection from, LiquidStack resource, boolean doFill) {
        return this.fill(0, resource, doFill);
    }

    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        TankManager tMan = this.getTankManager();
        if (tMan == null) {
            return 0;
        }
        int filled = tMan.fill(tankIndex, resource, doFill);
        if (filled > 0) {
            this.setFilling();
        }
        return filled;
    }

    public ILiquidTank[] getTanks(ForgeDirection side) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return tMan.getTanks();
        }
        return FakeTank.ARRAY;
    }

    public ILiquidTank getTank(ForgeDirection direction, LiquidStack type) {
        TankManager tMan = this.getTankManager();
        if (tMan != null) {
            return new IronTankWrapper((ILiquidTank)tMan.getTank(0));
        }
        return FakeTank.INSTANCE;
    }

    private class IronTankWrapper
    extends TankWrapper {
        public IronTankWrapper(ILiquidTank tank) {
            super(tank);
        }

        @Override
        public int fill(LiquidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            int filled = this.tank.fill(resource, doFill);
            if (filled > 0) {
                TileTankIronValve.this.setFilling();
            }
            return filled;
        }

        @Override
        public LiquidStack drain(int maxDrain, boolean doDrain) {
            if (TileTankIronValve.this.getPatternPositionY() - TileTankIronValve.this.getPattern().getMasterOffsetY() > 1) {
                return null;
            }
            return this.tank.drain(maxDrain, doDrain);
        }

        @Override
        public int getTankPressure() {
            if (TileTankIronValve.this.getPatternPositionY() - TileTankIronValve.this.getPattern().getMasterOffsetY() > 1) {
                return 0;
            }
            return 1;
        }
    }
}

