/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.tools.IToolWrench;
import ic2.api.IWrenchable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.core.items.IMinecartItem;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.TileMachineItem;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileDispenserCart
extends TileMachineItem
implements IWrenchable,
ISidedInventory {
    protected ForgeDirection direction = ForgeDirection.NORTH;
    protected boolean powered;
    protected int timeSinceLastSpawn;

    public TileDispenserCart() {
        super(3);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.DISPENSER_CART;
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.direction.ordinal() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        IToolWrench wrench;
        ur current = player.bS();
        if (current != null && current.b() instanceof IToolWrench && (wrench = (IToolWrench)current.b()).canWrench(player, this.l, this.m, this.n)) {
            this.direction = this.direction.ordinal() == side ? MiscTools.getOppositeSide(side) : ForgeDirection.getOrientation((int)side);
            wrench.wrenchUsed(player, this.l, this.m, this.n);
            this.markBlockForUpdate();
            return true;
        }
        return super.blockActivated(player, side);
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.CART_DISPENSER, player, this.k, this.l, this.m, this.n);
        return true;
    }

    @Override
    public void onBlockPlacedBy(md entityliving) {
        super.onBlockPlacedBy(entityliving);
        this.direction = MiscTools.getSideClosestToPlayer(this.k, this.l, this.m, this.n, entityliving);
    }

    @Override
    public boolean canUpdate() {
        return true;
    }

    @Override
    public void g() {
        super.g();
        if (this.timeSinceLastSpawn < Integer.MAX_VALUE) {
            ++this.timeSinceLastSpawn;
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        boolean newPower;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = newPower = this.k.A(this.l, this.m, this.n) || this.k.B(this.l, this.m, this.n);
        if (!this.powered && newPower) {
            this.powered = newPower;
            py cart = CartTools.getMinecartOnSide(this.k, this.l, this.m, this.n, 0.0f, this.direction);
            if (cart == null) {
                if (this.timeSinceLastSpawn > RailcraftConfig.getCartDispenserMinDelay() * 20) {
                    for (int ii = 0; ii < this.k_(); ++ii) {
                        ur cartStack = this.a(ii);
                        if (cartStack == null) continue;
                        int x = MiscTools.getXOnSide(this.l, this.direction);
                        int y = MiscTools.getYOnSide(this.m, this.direction);
                        int z = MiscTools.getZOnSide(this.n, this.direction);
                        boolean minecartItem = cartStack.b() instanceof IMinecartItem;
                        if (cartStack.b() instanceof uv || minecartItem) {
                            boolean canPlace = true;
                            if (minecartItem) {
                                canPlace = ((IMinecartItem)cartStack.b()).canBePlacedByNonPlayer(cartStack);
                            }
                            if (!canPlace) continue;
                            ur placedStack = cartStack.l();
                            py placedCart = CartTools.placeCart(this.getOwner(), placedStack, this.k, x, y, z);
                            if (placedCart == null) continue;
                            this.a(ii, 1);
                            this.timeSinceLastSpawn = 0;
                            break;
                        }
                        float rx = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                        float ry2 = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                        float rz = MiscTools.getRand().nextFloat() * 0.8f + 0.1f;
                        px item = new px(this.k, (double)((float)x + rx), (double)((float)y + ry2), (double)((float)z + rz), cartStack);
                        float factor = 0.05f;
                        item.w = (float)MiscTools.getRand().nextGaussian() * factor;
                        item.x = (float)MiscTools.getRand().nextGaussian() * factor + 0.2f;
                        item.y = (float)MiscTools.getRand().nextGaussian() * factor;
                        if (!this.k.d((lq)item)) continue;
                        this.a(ii, null);
                    }
                }
            } else if (!cart.L && cart.getCartItem() != null) {
                InventoryCopy testInv = new InventoryCopy(this);
                ur cartStack = InvTools.moveItemStack(cart.getCartItem(), testInv);
                if (cartStack == null) {
                    InvTools.moveItemStack(cart.getCartItem(), this);
                    if (cart.n != null) {
                        cart.n.a(null);
                    }
                    cart.x();
                }
            }
        } else if (this.powered ^ newPower) {
            this.powered = newPower;
        }
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("powered", this.powered);
        data.a("direction", (byte)this.direction.ordinal());
        data.a("time", this.timeSinceLastSpawn);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.powered = data.n("powered");
        this.direction = ForgeDirection.getOrientation((int)data.c("direction"));
        this.timeSinceLastSpawn = data.e("time");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeByte(this.direction.ordinal());
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.direction = ForgeDirection.getOrientation((int)data.readByte());
        this.markBlockForUpdate();
    }

    public boolean getPowered() {
        return this.powered;
    }

    public void setPowered(boolean power) {
        this.powered = power;
    }

    @Override
    public boolean wrenchCanSetFacing(qx player, int side) {
        return this.direction.ordinal() != side;
    }

    @Override
    public void setFacing(short facing) {
        this.direction = ForgeDirection.getOrientation((int)facing);
        this.sendUpdateToClient();
    }

    @Override
    public short getFacing() {
        return (short)this.direction.ordinal();
    }

    @Override
    public boolean wrenchCanRemove(qx entityPlayer) {
        return true;
    }

    @Override
    public float getWrenchDropRate() {
        return 1.0f;
    }

    @Override
    public ur getWrenchDrop(qx entityPlayer) {
        return this.getMachineType().getItem();
    }

    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return this.k_();
    }

    @Override
    public int c() {
        return 64;
    }
}

