/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.inventory.ISpecialInventory;
import java.util.Iterator;
import java.util.Map;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.carts.CartTools;
import railcraft.common.api.core.items.IItemType;
import railcraft.common.api.core.items.IMinecartItem;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.machine.gamma.TileDispenserCart;
import railcraft.common.carts.ItemCartAnchor;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.inventory.ItemStackSet;
import railcraft.common.util.inventory.PhantomInventory;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;

public class TileDispenserTrain
extends TileDispenserCart
implements ISpecialInventory {
    public static final int PATTERN_SIZE = 9;
    public static final int BUFFER_SIZE = 18;
    private byte patternIndex;
    private boolean spawningTrain = false;
    private py lastCart;
    private PhantomInventory invPattern = new PhantomInventory(9, this);
    private int update = MiscTools.getRand().nextInt();

    public TileDispenserTrain() {
        this.setInventorySize(18);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.DISPENSER_TRAIN;
    }

    public PhantomInventory getPattern() {
        return this.invPattern;
    }

    @Override
    public int getBlockTexture(int side) {
        if (this.getFacing() == side) {
            return this.getMachineType().getTexture(3);
        }
        if (side != 0 && side != 1) {
            return this.getMachineType().getTexture(2);
        }
        return this.getMachineType().getTexture(1);
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.TRAIN_DISPENSER, player, this.k, this.l, this.m, this.n);
        return true;
    }

    private boolean canBuildTrain() {
        Map pattern = InvTools.getManifest(this.getPattern());
        Map buffer = InvTools.getManifest(this);
        for (Map.Entry entry : pattern.entrySet()) {
            Integer count = (Integer)buffer.get(entry.getKey());
            if (count != null && count >= (Integer)entry.getValue()) continue;
            return false;
        }
        return true;
    }

    private boolean spawnNextCart() {
        ur cartItem;
        ur spawn = this.getPattern().a(this.patternIndex);
        if (spawn == null) {
            this.resetSpawnSequence();
            return false;
        }
        MinecartItemType filter = new MinecartItemType(spawn);
        if (InvTools.countItems((la)this, filter) == 0) {
            this.resetSpawnSequence();
            return false;
        }
        int x = MiscTools.getXOnSide(this.l, this.direction);
        int y = MiscTools.getYOnSide(this.m, this.direction);
        int z = MiscTools.getZOnSide(this.n, this.direction);
        if ((spawn.b() instanceof uv || spawn.b() instanceof IMinecartItem) && CartTools.getMinecartOnSide(this.k, this.l, this.m, this.n, 0.0f, this.direction) == null && (cartItem = InvTools.removeOneItem((la)this, filter)) != null) {
            py cartPlaced = CartTools.placeCart(this.getOwner(), cartItem, this.k, x, y, z);
            if (cartPlaced != null) {
                CartTools.getLinkageManager(this.k).createLink(cartPlaced, this.lastCart);
                this.lastCart = cartPlaced;
                this.patternIndex = (byte)(this.patternIndex + 1);
                if (this.patternIndex >= this.getPattern().k_()) {
                    this.resetSpawnSequence();
                }
                return true;
            }
            InvTools.moveItemStack(cartItem, this);
        }
        return false;
    }

    private void resetSpawnSequence() {
        this.patternIndex = 0;
        this.spawningTrain = false;
        this.timeSinceLastSpawn = 0;
    }

    @Override
    public void g() {
        super.g();
        ++this.update;
        if (this.spawningTrain && this.update % 4 == 0) {
            this.spawnNextCart();
        }
    }

    @Override
    public void onNeighborBlockChange(int id) {
        boolean newPower;
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        boolean bl = newPower = this.k.A(this.l, this.m, this.n) || this.k.B(this.l, this.m, this.n);
        if (!this.powered && newPower) {
            this.powered = newPower;
            py cart = CartTools.getMinecartOnSide(this.k, this.l, this.m, this.n, 0.0f, this.direction);
            if (cart == null && !this.spawningTrain && this.canBuildTrain() && this.timeSinceLastSpawn > RailcraftConfig.getCartDispenserMinDelay() * 20) {
                this.spawningTrain = true;
            }
        } else if (this.powered ^ newPower) {
            this.powered = newPower;
        }
    }

    @Override
    public int getStartInventorySide(ForgeDirection side) {
        return 0;
    }

    @Override
    public int getSizeInventorySide(ForgeDirection side) {
        return 18;
    }

    @Override
    public int c() {
        return 64;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("spawningTrain", this.spawningTrain);
        data.a("patternIndex", this.patternIndex);
        this.getPattern().writeToNBT("invPattern", data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.spawningTrain = data.n("spawningTrain");
        this.patternIndex = data.c("patternIndex");
        if (data.b("pattern")) {
            bq pattern = data.l("pattern");
            this.getPattern().readFromNBT("Items", pattern);
        } else {
            this.getPattern().readFromNBT("invPattern", data);
        }
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        ur leftOver;
        if (InvTools.isInventoryEmpty(this.getPattern())) {
            return 0;
        }
        Object inv = new InventoryMapper(this);
        if (!doAdd) {
            inv = new InventoryCopy((la)inv);
        }
        if ((leftOver = InvTools.moveItemStack(stack, inv)) == null) {
            return stack.a;
        }
        return stack.a - leftOver.a;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        Iterator i$;
        ItemStackSet patternSet = new ItemStackSet();
        ItemStackSet bufferSet = new ItemStackSet();
        for (ur stack : this.getPattern().getContents()) {
            if (stack == null) continue;
            patternSet.add(stack);
        }
        for (ur stack : this.getInventory().getContents()) {
            if (stack == null) continue;
            bufferSet.add(stack);
        }
        bufferSet.removeAll(patternSet);
        la inv = this;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        if ((i$ = bufferSet.iterator()).hasNext()) {
            ur[] urArray;
            ur stack = (ur)i$.next();
            ur removed = InvTools.removeOneItem(inv, stack);
            if (removed != null) {
                ur[] urArray2 = new ur[1];
                urArray = urArray2;
                urArray2[0] = removed;
            } else {
                urArray = new ur[]{};
            }
            return urArray;
        }
        return new ur[0];
    }

    private static class MinecartItemType
    implements IItemType {
        private final ur original;
        private final boolean isAnchor;

        public MinecartItemType(ur cart) {
            this.original = cart;
            this.isAnchor = this.original.b() instanceof ItemCartAnchor;
        }

        @Override
        public boolean isItemType(ur stack) {
            if (stack == null) {
                return false;
            }
            if (InvTools.isItemEqual(stack, this.original)) {
                return true;
            }
            return this.isAnchor && stack.b() instanceof ItemCartAnchor;
        }
    }
}

