/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.machine.gamma;

import buildcraft.api.inventory.ISpecialInventory;
import buildcraft.api.transport.IPipe;
import buildcraft.api.transport.IPipeTile;
import ic2.api.IWrenchable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.ISidedInventory;
import net.minecraftforge.liquids.ITankContainer;
import net.minecraftforge.liquids.LiquidStack;
import railcraft.common.api.carts.CartTools;
import railcraft.common.blocks.machine.IEnumMachine;
import railcraft.common.blocks.machine.gamma.EnumMachineGamma;
import railcraft.common.blocks.machine.gamma.TileLoaderLiquidBase;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.gui.EnumGui;
import railcraft.common.gui.GuiHandler;
import railcraft.common.liquids.LiquidManager;
import railcraft.common.liquids.TankToolkit;
import railcraft.common.liquids.tanks.StandardTank;
import railcraft.common.util.inventory.InvTools;
import railcraft.common.util.inventory.InventoryCopy;
import railcraft.common.util.inventory.InventoryMapper;
import railcraft.common.util.inventory.PhantomInventory;
import railcraft.common.util.misc.Game;
import railcraft.common.util.misc.MiscTools;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileLiquidUnloader
extends TileLoaderLiquidBase
implements IWrenchable,
ISidedInventory,
ISpecialInventory,
ITankContainer,
IGuiReturnHandler {
    private static final int CAPACITY = 8000;
    private static final int TRANSFER_RATE = 80;
    private static final int SLOT_INPUT = 0;
    private static final int SLOT_OUTPUT = 1;
    private boolean waitTillEmpty = true;
    private final PhantomInventory invFilter = new PhantomInventory(1);

    public TileLiquidUnloader() {
        StandardTank tank = new StandardTank(8000, this);
        tank.setTankPressure(1);
        this.tankManager.addTank(tank);
    }

    @Override
    public IEnumMachine getMachineType() {
        return EnumMachineGamma.LIQUID_UNLOADER;
    }

    public PhantomInventory getLiquidFilter() {
        return this.invFilter;
    }

    @Override
    public int getBlockTexture(int side) {
        if (side > 1) {
            return 24;
        }
        return this.getMachineType().getTexture(side);
    }

    public LiquidStack getFilterLiquid() {
        if (this.invFilter.a(0) != null) {
            return LiquidManager.getInstance().getLiquidInContainer(this.invFilter.a(0));
        }
        return null;
    }

    @Override
    public boolean blockActivated(qx player, int side) {
        return super.blockActivated(player, side);
    }

    @Override
    public void g() {
        ur bottomSlot;
        super.g();
        if (Game.isNotHost(this.getWorld())) {
            return;
        }
        ur topSlot = this.a(0);
        if (topSlot != null && !LiquidManager.getInstance().isContainer(topSlot)) {
            this.a(0, null);
            this.dropItem(topSlot);
        }
        if ((bottomSlot = this.a(1)) != null && !LiquidManager.getInstance().isContainer(bottomSlot)) {
            this.a(1, null);
            this.dropItem(bottomSlot);
        }
        if (this.update % 8 == 0) {
            LiquidManager.getInstance().processContainers(this.tankManager.getTank(0), this, 0, 1, false, true);
        }
        for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
            LiquidStack available;
            IPipe pipe;
            if (ForgeDirection.UP == side) continue;
            any tile = MiscTools.getBlockTileEntityOnSide(this.k, this.l, this.m, this.n, side);
            ITankContainer nearbyTank = null;
            side = side.getOpposite();
            if (tile instanceof ITankContainer) {
                nearbyTank = (ITankContainer)tile;
            } else if (tile instanceof IPipeTile && (pipe = ((IPipeTile)tile).getPipe()) instanceof ITankContainer) {
                nearbyTank = (ITankContainer)pipe;
            }
            if (nearbyTank == null || (available = this.tankManager.getTank(0).drain(80, false)) == null) continue;
            int used = nearbyTank.fill(side, available, true);
            this.tankManager.getTank(0).drain(used, true);
        }
        py cart = CartTools.getMinecartOnSide(this.k, this.l, this.m, this.n, 0.1f, ForgeDirection.UP);
        if (cart != this.currentCart) {
            this.setPowered(false);
            this.currentCart = cart;
            this.cartSent();
        }
        if (cart == null) {
            return;
        }
        if (!(cart instanceof ITankContainer)) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        if (this.isSendCart()) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        ur minecartSlot1 = this.getCartFilters().a(0);
        ur minecartSlot2 = this.getCartFilters().a(1);
        if (!(minecartSlot1 == null && minecartSlot2 == null || CartTools.doesCartMatchFilter(minecartSlot1, cart) || CartTools.doesCartMatchFilter(minecartSlot2, cart))) {
            if (CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
                this.setPowered(true);
            }
            return;
        }
        TankToolkit tankCart = new TankToolkit((ITankContainer)cart);
        int flow = 0;
        LiquidStack drained = tankCart.drain(ForgeDirection.DOWN, RailcraftConfig.getTankCartFillRate(), false);
        if (this.getFilterLiquid() == null || this.getFilterLiquid().isLiquidEqual(drained)) {
            flow = this.tankManager.getTank(0).fill(drained, true);
            tankCart.drain(ForgeDirection.DOWN, flow, true);
        }
        if (flow > 0) {
            this.setPowered(false);
        }
        if (flow <= 0 && !this.isPowered() && CartTools.cartVelocityIsLessThan(cart, 0.02f)) {
            if (!this.waitTillEmpty()) {
                this.setPowered(true);
            } else if (this.getFilterLiquid() != null && tankCart.isTankEmpty(this.getFilterLiquid())) {
                this.setPowered(true);
            } else if (tankCart.areTanksEmpty()) {
                this.setPowered(true);
            }
        }
    }

    @Override
    public int fill(int tankIndex, LiquidStack resource, boolean doFill) {
        return 0;
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("waitTillEmpty", this.waitTillEmpty);
        this.getLiquidFilter().writeToNBT("invFilter", data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.waitTillEmpty = data.n("waitTillEmpty");
        if (data.b("filter")) {
            bq filter = data.l("filter");
            this.getLiquidFilter().readFromNBT("Items", filter);
        } else {
            this.getLiquidFilter().readFromNBT("invFilter", data);
        }
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.waitTillEmpty = data.readBoolean();
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        data.writeBoolean(this.waitTillEmpty);
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        this.waitTillEmpty = data.readBoolean();
    }

    public boolean waitTillEmpty() {
        return this.waitTillEmpty;
    }

    public void setWaitTillEmpty(boolean wait) {
        this.waitTillEmpty = wait;
    }

    @Override
    public short getFacing() {
        return (short)ForgeDirection.UP.ordinal();
    }

    public ForgeDirection getOrientation() {
        return ForgeDirection.UP;
    }

    @Override
    public boolean openGui(qx player) {
        GuiHandler.openGui(EnumGui.UNLOADER_LIQUID, player, this.k, this.l, this.m, this.n);
        return true;
    }

    public int getStartInventorySide(ForgeDirection side) {
        if (side == ForgeDirection.DOWN) {
            return 1;
        }
        return 0;
    }

    public int getSizeInventorySide(ForgeDirection side) {
        return 1;
    }

    @Override
    public int addItem(ur stack, boolean doAdd, ForgeDirection from) {
        if (LiquidManager.getInstance().isEmptyContainer(stack)) {
            ur ret;
            Object slot = new InventoryMapper(this, 0, 1);
            if (!doAdd) {
                slot = new InventoryCopy((la)slot);
            }
            if ((ret = InvTools.moveItemStack(stack.l(), slot)) != null && stack.a != ret.a) {
                return stack.a - ret.a;
            }
            if (ret == null) {
                return stack.a;
            }
        }
        return 0;
    }

    @Override
    public ur[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        la inv = this;
        if (!doRemove) {
            inv = new InventoryCopy(inv);
        }
        return new ur[]{inv.a(1, maxItemCount)};
    }
}

