/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.signals;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.signals.DualSignalReceiver;
import railcraft.common.api.signals.IReceiverTile;
import railcraft.common.api.signals.SignalAspect;
import railcraft.common.api.signals.SignalController;
import railcraft.common.blocks.signals.EnumSignal;
import railcraft.common.blocks.signals.IDualHeadSignal;
import railcraft.common.blocks.signals.Signals;
import railcraft.common.blocks.signals.TileSignalBase;
import railcraft.common.util.misc.Game;

public class TileSignalDualHeadDistantSignal
extends TileSignalBase
implements IReceiverTile,
IDualHeadSignal {
    private static final float SIZE = 0.15f;
    private boolean prevLightState;
    private final DualSignalReceiver receiver = new DualSignalReceiver(this.b(), this);

    @Override
    public EnumSignal getSignalType() {
        return EnumSignal.DUAL_HEAD_DISTANT_SIGNAL;
    }

    @Override
    public void g() {
        super.g();
        if (Game.isNotHost(this.k)) {
            boolean lightState;
            this.receiver.tickClient();
            boolean bl = lightState = Signals.isAspectLit(this.getTopAspect()) || Signals.isAspectLit(this.getBottomAspect());
            if (this.update % 4 == 0 && lightState != this.prevLightState) {
                this.prevLightState = lightState;
                this.k.c(yo.b, this.getX(), this.getY(), this.getZ());
                this.markBlockForUpdate();
            }
            return;
        }
        this.receiver.tickServer();
        int numPairs = this.receiver.getNumPairs();
        boolean changed = false;
        switch (numPairs) {
            case 0: {
                changed |= this.receiver.setTopAspect(SignalAspect.BLINK_RED);
            }
            case 1: {
                changed |= this.receiver.setBottomAspect(SignalAspect.BLINK_RED);
            }
        }
        if (changed) {
            this.sendUpdateToClient();
        }
    }

    @Override
    public void onControllerAspectChange(SignalController con, SignalAspect aspect) {
        this.sendUpdateToClient();
    }

    @Override
    public void setBlockBoundsBasedOnState(ym world, int i, int j, int k) {
        this.getBlock().a(0.15f, 0.0f, 0.15f, 0.85f, 1.0f, 0.85f);
    }

    @Override
    public aoe getSelectedBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)i + 0.85f), (double)((float)j + 1.0f), (double)((float)k + 0.85f));
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool(yc world, int i, int j, int k) {
        return aoe.a().a((double)((float)i + 0.15f), (double)j, (double)((float)k + 0.15f), (double)((float)(i + 1) - 0.15f), (double)(j + 1), (double)((float)(k + 1) - 0.15f));
    }

    @Override
    public void b(bq data) {
        super.b(data);
        this.receiver.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        this.receiver.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        this.receiver.writePacketData(data);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        this.receiver.readPacketData(data);
    }

    @Override
    public int getLightValue() {
        if (Signals.isAspectLit(this.getTopAspect()) || Signals.isAspectLit(this.getBottomAspect())) {
            return 5;
        }
        return 0;
    }

    @Override
    public DualSignalReceiver getReceiver() {
        return this.receiver;
    }

    @Override
    public SignalAspect getTopAspect() {
        return this.receiver.getTopAspect();
    }

    @Override
    public SignalAspect getBottomAspect() {
        return this.receiver.getBottomAspect();
    }

    @Override
    public SignalAspect getSignalAspect() {
        return this.receiver.getTopAspect();
    }
}

