/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.logging.Level;
import net.minecraftforge.common.ForgeDirection;
import railcraft.common.api.core.IPostConnection;
import railcraft.common.api.tracks.ITrackBlocksMovement;
import railcraft.common.api.tracks.ITrackCustomShape;
import railcraft.common.api.tracks.ITrackEmitter;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.TrackRegistry;
import railcraft.common.api.tracks.TrackSpec;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TileTrack;
import railcraft.common.util.misc.Game;

public class BlockTrack
extends alr
implements IPostConnection {
    protected final int renderType;

    public BlockTrack(int blockID, int modelID) {
        super(blockID, 255, false);
        TrackSpec.blockID = blockID;
        this.renderType = modelID;
        this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        this.b(3.5f);
        this.c(1.05f);
        this.a(i);
        this.r();
        this.a(tj.e);
        GameRegistry.registerTileEntity(TileTrack.class, (String)"RailcraftTrackTile");
    }

    public void a(int id, tj tab, List list) {
        HashSet<TrackSpec> railcraftSpecs = new HashSet<TrackSpec>();
        for (EnumTrack t : EnumTrack.getCreativeList()) {
            railcraftSpecs.add(TrackRegistry.getTrackSpec(t.ordinal()));
            if (!t.isEnabled()) continue;
            list.add(t.getItem());
        }
        HashSet specs = new HashSet(TrackRegistry.getTrackSpecs().values());
        specs.removeAll(railcraftSpecs);
        specs.remove(TrackRegistry.getTrackSpec(-1));
        for (TrackSpec spec : specs) {
            list.add(new ur((amq)this, 1, (int)spec.getTrackId()));
        }
    }

    public ur getPickBlock(aoh target, yc world, int x, int y, int z) {
        any tile = world.q(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return new ur((amq)this, 1, (int)track.getTrackSpec().getTrackId());
        }
        return null;
    }

    public int d() {
        return this.renderType;
    }

    public boolean hasTileEntity(int metadata) {
        return true;
    }

    public int q_() {
        return 0;
    }

    public aoe e(yc world, int i, int j, int k) {
        ITrackInstance track;
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).getCollisionBoundingBoxFromPool();
        }
        return null;
    }

    public aoe b_(yc world, int i, int j, int k) {
        ITrackInstance track;
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).getSelectedBoundingBoxFromPool();
        }
        return aoe.a().a((double)i + this.ct, (double)j + this.cu, (double)k + this.cv, (double)i + this.cw, (double)j + this.cx, (double)k + this.cy);
    }

    public boolean c() {
        return false;
    }

    public aoh a(yc world, int i, int j, int k, aoj vec3d, aoj vec3d1) {
        ITrackInstance track;
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackCustomShape) {
            return ((ITrackCustomShape)track).collisionRayTrace(vec3d, vec3d1);
        }
        return super.a(world, i, j, k, vec3d, vec3d1);
    }

    public void a(ym iblockaccess, int i, int j, int k) {
        int l = iblockaccess.h(i, j, k);
        if (l >= 2 && l <= 5) {
            this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.625f, 1.0f);
        } else {
            this.a(0.0f, 0.0f, 0.0f, 1.0f, 0.125f, 1.0f);
        }
    }

    public boolean c(ym world, int x, int y, int z) {
        ITrackInstance track;
        any tile = world.q(x, y, z);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof ITrackBlocksMovement) {
            return !((ITrackBlocksMovement)((Object)track)).blocksMovement();
        }
        return super.c(world, x, y, z);
    }

    public boolean b(yc world, int i, int j, int k) {
        return !alr.e_((yc)world, (int)i, (int)(j + 1), (int)k);
    }

    public boolean b() {
        return false;
    }

    public boolean i() {
        return true;
    }

    public boolean canConnectRedstone(ym world, int x, int y, int z, int side) {
        any tile = world.q(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter;
        }
        return false;
    }

    public boolean b(ym world, int x, int y, int z, int side) {
        any tile = world.q(x, y, z);
        if (tile instanceof TileTrack) {
            ITrackInstance track = ((TileTrack)tile).getTrackInstance();
            return track instanceof ITrackEmitter && ((ITrackEmitter)track).isTrackPowering();
        }
        return false;
    }

    public boolean c(ym world, int x, int y, int z, int side) {
        return this.b(world, x, y, z, side);
    }

    public void onMinecartPass(yc world, py cart, int i, int j, int k) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).getTrackInstance().onMinecartPass(cart);
        }
    }

    public int getBasicRailMetadata(ym world, py cart, int i, int j, int k) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getBasicRailMetadata(cart);
        }
        return world.h(i, j, k);
    }

    public float getRailMaxSpeed(yc world, py cart, int i, int j, int k) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getRailMaxSpeed(cart);
        }
        return 0.4f;
    }

    public boolean a(yc world, int i, int j, int k, qx player, int side, float u1, float u2, float u3) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().blockActivated(player);
        }
        return false;
    }

    public boolean isFlexibleRail(yc world, int i, int j, int k) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().isFlexibleRail();
        }
        return false;
    }

    public boolean canMakeSlopes(yc world, int i, int j, int k) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().canMakeSlopes();
        }
        return true;
    }

    public boolean hasPowerBit(yc world, int i, int j, int k) {
        return false;
    }

    public String getTextureFile() {
        return "/railcraft/client/textures/tracks.png";
    }

    public int a(int side, int meta) {
        return this.cl;
    }

    public int d(ym world, int i, int j, int k, int side) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getTextureIndex();
        }
        return -1;
    }

    public ArrayList getBlockDropped(yc world, int i, int j, int k, int md2, int fortune) {
        any tile = world.q(i, j, k);
        ArrayList<ur> items = new ArrayList<ur>();
        if (tile instanceof TileTrack) {
            items.add(new ur((amq)this, 1, (int)((TileTrack)tile).getTrackInstance().getTrackSpec().getTrackId()));
        } else {
            Game.log(Level.WARNING, "Rail Tile was invalid when harvesting rail", new Object[0]);
            items.add(new ur(amq.aJ));
        }
        return items;
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        return 1;
    }

    public int a(int i, Random random, int j) {
        Game.log(Level.WARNING, "Wrong function called when harvesting rail", new Object[0]);
        return amq.aJ.a(i, random, j);
    }

    public any getBlockEntity(int md2) {
        return null;
    }

    public void a(yc world, int i, int j, int k, md entityliving) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).onBlockPlacedBy(entityliving);
            ((TileTrack)tile).getTrackInstance().onBlockPlacedBy(entityliving);
        }
    }

    public void g(yc world, int i, int j, int k, int meta) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            ((TileTrack)tile).getTrackInstance().onBlockPlaced();
        }
    }

    public void a(yc world, qx entityplayer, int i, int j, int k, int l) {
    }

    public boolean removeBlockByPlayer(yc world, qx player, int i, int j, int k) {
        player.a(jq.C[this.cm], 1);
        player.j(0.025f);
        if (Game.isHost(world) && !player.cd.d) {
            this.c(world, i, j, k, 0, 0);
        }
        return world.e(i, j, k, 0);
    }

    public void a(yc world, int i, int j, int k, int id, int meta) {
        super.a(world, i, j, k, id, meta);
        try {
            any tile = world.q(i, j, k);
            if (tile instanceof TileTrack) {
                ((TileTrack)tile).getTrackInstance().onBlockRemoved();
            }
        }
        catch (Throwable error) {
            Game.logErrorAPI("Railcraft", error);
        }
        world.r(i, j, k);
    }

    public void a(yc world, int i, int j, int k, int id) {
        if (Game.isNotHost(world)) {
            return;
        }
        any t = world.q(i, j, k);
        if (t instanceof TileTrack) {
            TileTrack tile = (TileTrack)t;
            tile.getTrackInstance().onNeighborBlockChange(id);
        }
    }

    public float getExplosionResistance(lq exploder, yc world, int i, int j, int k, double srcX, double srcY, double srcZ) {
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack) {
            return ((TileTrack)tile).getTrackInstance().getExplosionResistance(srcX, srcY, srcZ, exploder) * 3.0f / 5.0f;
        }
        return this.a(exploder);
    }

    public boolean canBeReplacedByLeaves(yc world, int x, int y, int z) {
        return false;
    }

    public boolean canCreatureSpawn(me type, yc world, int x, int y, int z) {
        return false;
    }

    @Override
    public boolean connectsAt(yc world, int i, int j, int k, ForgeDirection side) {
        ITrackInstance track;
        any tile = world.q(i, j, k);
        if (tile instanceof TileTrack && (track = ((TileTrack)tile).getTrackInstance()) instanceof IPostConnection) {
            return ((IPostConnection)((Object)track)).connectsAt(world, i, j, k, side);
        }
        return false;
    }
}

