/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.util.ArrayList;
import java.util.List;
import railcraft.common.api.tracks.TrackRegistry;
import railcraft.common.api.tracks.TrackSpec;
import railcraft.common.blocks.RailcraftBlocks;
import railcraft.common.blocks.tracks.TrackBoarding;
import railcraft.common.blocks.tracks.TrackBoardingTrain;
import railcraft.common.blocks.tracks.TrackBufferStop;
import railcraft.common.blocks.tracks.TrackControl;
import railcraft.common.blocks.tracks.TrackCoupler;
import railcraft.common.blocks.tracks.TrackDecoupler;
import railcraft.common.blocks.tracks.TrackDefault;
import railcraft.common.blocks.tracks.TrackDetectorDirection;
import railcraft.common.blocks.tracks.TrackDisembark;
import railcraft.common.blocks.tracks.TrackDisposal;
import railcraft.common.blocks.tracks.TrackEmbarking;
import railcraft.common.blocks.tracks.TrackGated;
import railcraft.common.blocks.tracks.TrackGatedOneWay;
import railcraft.common.blocks.tracks.TrackHolding;
import railcraft.common.blocks.tracks.TrackHoldingTrain;
import railcraft.common.blocks.tracks.TrackJunction;
import railcraft.common.blocks.tracks.TrackLauncher;
import railcraft.common.blocks.tracks.TrackLimiter;
import railcraft.common.blocks.tracks.TrackLockdown;
import railcraft.common.blocks.tracks.TrackLockdownTrain;
import railcraft.common.blocks.tracks.TrackLocomotive;
import railcraft.common.blocks.tracks.TrackOneWay;
import railcraft.common.blocks.tracks.TrackPriming;
import railcraft.common.blocks.tracks.TrackReinforced;
import railcraft.common.blocks.tracks.TrackReinforcedBooster;
import railcraft.common.blocks.tracks.TrackReinforcedJunction;
import railcraft.common.blocks.tracks.TrackReinforcedSwitch;
import railcraft.common.blocks.tracks.TrackReinforcedWye;
import railcraft.common.blocks.tracks.TrackSlow;
import railcraft.common.blocks.tracks.TrackSlowBooster;
import railcraft.common.blocks.tracks.TrackSlowJunction;
import railcraft.common.blocks.tracks.TrackSlowSwitch;
import railcraft.common.blocks.tracks.TrackSlowWye;
import railcraft.common.blocks.tracks.TrackSpeed;
import railcraft.common.blocks.tracks.TrackSpeedBoost;
import railcraft.common.blocks.tracks.TrackSpeedSwitch;
import railcraft.common.blocks.tracks.TrackSpeedTransition;
import railcraft.common.blocks.tracks.TrackSpeedWye;
import railcraft.common.blocks.tracks.TrackSuspended;
import railcraft.common.blocks.tracks.TrackSwitch;
import railcraft.common.blocks.tracks.TrackWhistle;
import railcraft.common.blocks.tracks.TrackWye;
import railcraft.common.blocks.tracks.old.TileRailBoarding;
import railcraft.common.blocks.tracks.old.TileRailBoardingTrain;
import railcraft.common.blocks.tracks.old.TileRailControl;
import railcraft.common.blocks.tracks.old.TileRailCoupler;
import railcraft.common.blocks.tracks.old.TileRailDecoupler;
import railcraft.common.blocks.tracks.old.TileRailDisembark;
import railcraft.common.blocks.tracks.old.TileRailGated;
import railcraft.common.blocks.tracks.old.TileRailGatedOneWay;
import railcraft.common.blocks.tracks.old.TileRailHolding;
import railcraft.common.blocks.tracks.old.TileRailHoldingTrain;
import railcraft.common.blocks.tracks.old.TileRailJunction;
import railcraft.common.blocks.tracks.old.TileRailLauncher;
import railcraft.common.blocks.tracks.old.TileRailOneway;
import railcraft.common.blocks.tracks.old.TileRailPriming;
import railcraft.common.blocks.tracks.old.TileRailSlow;
import railcraft.common.blocks.tracks.old.TileRailSlowBooster;
import railcraft.common.blocks.tracks.old.TileRailSlowJunction;
import railcraft.common.blocks.tracks.old.TileRailSlowSwitch;
import railcraft.common.blocks.tracks.old.TileRailSpeed;
import railcraft.common.blocks.tracks.old.TileRailSpeedBoost;
import railcraft.common.blocks.tracks.old.TileRailSpeedSwitch;
import railcraft.common.blocks.tracks.old.TileRailSpeedTransition;
import railcraft.common.blocks.tracks.old.TileRailSuspended;
import railcraft.common.blocks.tracks.old.TileRailSwitch;
import railcraft.common.core.RailcraftConfig;
import railcraft.common.items.RailcraftPartItems;
import railcraft.common.items.RailcraftToolItems;
import railcraft.common.modules.ModuleManager;
import railcraft.common.plugins.forge.CraftingPlugin;

public enum EnumTrack {
    BOARDING(ModuleManager.Module.TRACKS, 0, "boarding", "RCBoardingRailTile", 8, TileRailBoarding.class, TrackBoarding.class),
    HOLDING(ModuleManager.Module.TRACKS, 4, "holding", "RCHoldingRailTile", 8, TileRailHolding.class, TrackHolding.class),
    ONEWAY(ModuleManager.Module.TRACKS, 16, "oneway", "RCOneWayRailTile", 8, TileRailOneway.class, TrackOneWay.class),
    CONTROL(ModuleManager.Module.TRACKS, 100, "control", "RCControlRailTile", 16, TileRailControl.class, TrackControl.class),
    LAUNCHER(ModuleManager.Module.EXTRAS, 36, "launcher", "RCLauncherRailTile", 1, TileRailLauncher.class, TrackLauncher.class),
    PRIMING(ModuleManager.Module.EXTRAS, 68, "priming", "RCPrimingRailTile", 8, TileRailPriming.class, TrackPriming.class),
    JUNCTION(ModuleManager.Module.TRACKS, 39, "junction", "RCJunctionRailTile", 8, TileRailJunction.class, TrackJunction.class),
    SWITCH(ModuleManager.Module.SIGNALS, 48, "switch", "RCSwitchRailTile", 8, TileRailSwitch.class, TrackSwitch.class),
    DISEMBARK(ModuleManager.Module.TRACKS, 116, "disembarking", "RCDisembarkingRailTile", 8, TileRailDisembark.class, TrackDisembark.class),
    SUSPENDED(ModuleManager.Module.EXTRAS, 253, "suspended", "RCSuspendedRailTile", 8, TileRailSuspended.class, TrackSuspended.class),
    GATED_ONEWAY(ModuleManager.Module.TRACKS, 132, "gated.oneway", "RCGatedOneWayRailTile", 4, TileRailGatedOneWay.class, TrackGatedOneWay.class),
    GATED(ModuleManager.Module.TRACKS, 254, "gated", "RCGatedRailTile", 4, TileRailGated.class, TrackGated.class),
    SLOW(ModuleManager.Module.TRACKS_WOOD, 22, "slow", "RCSlowRailTile", 16, TileRailSlow.class, TrackSlow.class),
    SLOW_BOOSTER(ModuleManager.Module.TRACKS_WOOD, 52, "slow.boost", "RCSlowBoosterRailTile", 8, TileRailSlowBooster.class, TrackSlowBooster.class),
    SLOW_JUNCTION(ModuleManager.Module.TRACKS_WOOD, 38, "slow.junction", "RCSlowJunctionRailTile", 8, TileRailSlowJunction.class, TrackSlowJunction.class),
    SLOW_SWITCH(ModuleManager.Module.SIGNALS, 64, "slow.switch", "RCSlowSwitchRailTile", 8, TileRailSlowSwitch.class, TrackSlowSwitch.class),
    SPEED(ModuleManager.Module.TRACKS_HIGHSPEED, 23, "speed", "RCSpeedRailTile", 16, TileRailSpeed.class, TrackSpeed.class),
    SPEED_BOOST(ModuleManager.Module.TRACKS_HIGHSPEED, 20, "speed.boost", "RCSpeedBoostRailTile", 8, TileRailSpeedBoost.class, TrackSpeedBoost.class),
    SPEED_TRANSITION(ModuleManager.Module.TRACKS_HIGHSPEED, 32, "speed.transition", "RCSpeedTransitionRailTile", 8, TileRailSpeedTransition.class, TrackSpeedTransition.class),
    SPEED_SWITCH(ModuleManager.Module.SIGNALS, 80, "speed.switch", "RCSpeedSwitchRailTile", 8, TileRailSpeedSwitch.class, TrackSpeedSwitch.class),
    BOARDING_TRAIN(ModuleManager.Module.TRAIN, 96, "boarding.train", "RCBoardingRailTrainTile", 8, TileRailBoardingTrain.class, TrackBoardingTrain.class),
    HOLDING_TRAIN(ModuleManager.Module.TRAIN, 148, "holding.train", "RCHoldingRailTrainTile", 8, TileRailHoldingTrain.class, TrackHoldingTrain.class),
    COUPLER(ModuleManager.Module.TRACKS, 112, "coupler", "RCCouplerTrackTile", 8, TileRailCoupler.class, TrackCoupler.class),
    DECOUPLER(ModuleManager.Module.TRACKS, 114, "decoupler", "RCDecouplerTrackTile", 8, TileRailDecoupler.class, TrackDecoupler.class),
    REINFORCED(ModuleManager.Module.TRACKS_REINFORCED, 24, "reinforced", "", 16, null, TrackReinforced.class),
    REINFORCED_BOOSTER(ModuleManager.Module.TRACKS_REINFORCED, 164, "reinforced.boost", "", 8, null, TrackReinforcedBooster.class),
    REINFORCED_JUNCTION(ModuleManager.Module.TRACKS_REINFORCED, 40, "reinforced.junction", "", 8, null, TrackReinforcedJunction.class),
    REINFORCED_SWITCH(ModuleManager.Module.TRACKS_REINFORCED, 128, "reinforced.switch", "", 8, null, TrackReinforcedSwitch.class),
    BUFFER_STOP(ModuleManager.Module.TRACKS, 180, "buffer.stop", "", 8, null, TrackBufferStop.class),
    DISPOSAL(ModuleManager.Module.TRACKS, 252, "disposal", "", 8, null, TrackDisposal.class),
    DETECTOR_DIRECTION(ModuleManager.Module.TRACKS, 144, "detector.direction", "", 8, null, TrackDetectorDirection.class),
    EMBARKING(ModuleManager.Module.TRACKS, 196, "embarking", "", 8, null, TrackEmbarking.class),
    WYE(ModuleManager.Module.TRACKS, 160, "wye", "", 8, null, TrackWye.class),
    SLOW_WYE(ModuleManager.Module.TRACKS, 162, "slow.wye", "", 8, null, TrackSlowWye.class),
    REINFORCED_WYE(ModuleManager.Module.TRACKS, 176, "reinforced.wye", "", 8, null, TrackReinforcedWye.class),
    SPEED_WYE(ModuleManager.Module.TRACKS, 178, "speed.wye", "", 8, null, TrackSpeedWye.class),
    LOCKDOWN(ModuleManager.Module.TRACKS, 228, "lockdown", "", 8, null, TrackLockdown.class),
    LOCKDOWN_TRAIN(ModuleManager.Module.TRAIN, 244, "lockdown.train", "", 8, null, TrackLockdownTrain.class),
    WHISTLE(ModuleManager.Module.LOCOMOTIVES, 54, "whistle", "", 8, null, TrackWhistle.class),
    LOCOMOTIVE(ModuleManager.Module.LOCOMOTIVES, 192, "locomotive", "", 8, null, TrackLocomotive.class),
    LIMITER(ModuleManager.Module.LOCOMOTIVES, 224, "limiter", "", 8, null, TrackLimiter.class);

    private final ModuleManager.Module module;
    private final String tag;
    private final String tileTag;
    private final int recipeOutput;
    private final Class tile;
    private final int textureIndex;
    private final TrackSpec trackSpec;
    private static final List creativeList;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private EnumTrack(String module3, String textureIndex, int tag, Class tileTag, Class recipeOutput) {
        void track;
        void tile;
        this.module = module3;
        this.textureIndex = (int)textureIndex;
        this.tag = (String)tag;
        this.tileTag = tileTag;
        this.recipeOutput = (int)recipeOutput;
        this.tile = tile;
        String textureFile = "/railcraft/client/textures/tracks.png";
        this.trackSpec = new TrackSpec((short)this.ordinal(), this.getTag(), textureFile, (int)textureIndex, (Class)track);
        TrackRegistry.registerTrackSpec(this.trackSpec);
    }

    public boolean isEnabled() {
        return ModuleManager.isModuleLoaded(this.module) && RailcraftConfig.isSubBlockEnabled(this.getTag());
    }

    public ur getItem() {
        return this.getItem(1);
    }

    public ur getItem(int qty) {
        return new ur(RailcraftBlocks.getBlockTrack(), qty, this.ordinal());
    }

    public TrackSpec getTrackSpec() {
        return this.trackSpec;
    }

    public String getTag() {
        return "rc.track." + this.tag;
    }

    public String getTileTag() {
        return this.tileTag;
    }

    public Class getTileClass() {
        return this.tile;
    }

    public any getBlockEntity() {
        try {
            return (any)this.tile.newInstance();
        }
        catch (InstantiationException ex) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    public int getTextureIndex() {
        return this.textureIndex;
    }

    public static EnumTrack fromId(int id) {
        if (id < 0 || id >= EnumTrack.values().length) {
            id = 0;
        }
        return EnumTrack.values()[id];
    }

    public static List getCreativeList() {
        return creativeList;
    }

    public ur registerRecipe() {
        if (this.getItem() == null) {
            return null;
        }
        ur output = this.getItem(this.recipeOutput * 2);
        ur railWood = RailcraftPartItems.getRailWood();
        ur railStandard = RailcraftPartItems.getRailStandard();
        ur railAdvanced = RailcraftPartItems.getRailAdvanced();
        ur railSpeed = RailcraftPartItems.getRailSpeed();
        ur railReinforced = RailcraftPartItems.getRailReinforced();
        ur woodTie = RailcraftPartItems.getTieWood();
        ur woodRailbed = RailcraftPartItems.getRailbedWood();
        ur stoneRailbed = RailcraftPartItems.getRailbedStone();
        ur reinforcedRailbed = RailcraftConfig.useOldRecipes() ? new ur(amq.as) : RailcraftPartItems.getRailbedStone();
        ur crowbar = RailcraftToolItems.getCrowbar();
        crowbar.b(-1);
        switch (this) {
            case BOARDING: {
                CraftingPlugin.addShapedRecipe(output, "IrI", "IbI", "IsI", Character.valueOf('I'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), up.aC, Character.valueOf('b'), amq.aN);
                break;
            }
            case BOARDING_TRAIN: {
                CraftingPlugin.addShapedRecipe(output, "IrI", "IbI", "IsI", Character.valueOf('I'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), up.bb, Character.valueOf('b'), amq.aN);
                break;
            }
            case ONEWAY: {
                CraftingPlugin.addShapedRecipe(output, "IbI", "IsI", "IpI", Character.valueOf('I'), railStandard, Character.valueOf('s'), woodRailbed, Character.valueOf('b'), amq.aN, Character.valueOf('p'), amq.ac);
                break;
            }
            case CONTROL: {
                CraftingPlugin.addShapedRecipe(output, "IrI", "GsG", "IrI", Character.valueOf('I'), railStandard, Character.valueOf('G'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), up.aC);
                break;
            }
            case HOLDING: {
                CraftingPlugin.addShapedRecipe(output, "IsI", "IbI", "IrI", Character.valueOf('I'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), up.aC, Character.valueOf('b'), amq.aN);
                break;
            }
            case HOLDING_TRAIN: {
                CraftingPlugin.addShapedRecipe(output, "IsI", "IbI", "IrI", Character.valueOf('I'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), up.bb, Character.valueOf('b'), amq.aN);
                break;
            }
            case LOCKDOWN: {
                CraftingPlugin.addShapedRecipe(output, "IbI", "IrI", "IsI", Character.valueOf('I'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), up.aC, Character.valueOf('b'), amq.aN);
                break;
            }
            case LOCKDOWN_TRAIN: {
                CraftingPlugin.addShapedRecipe(output, "IbI", "IrI", "IsI", Character.valueOf('I'), railAdvanced, Character.valueOf('s'), woodRailbed, Character.valueOf('r'), up.bb, Character.valueOf('b'), amq.aN);
                break;
            }
            case SPEED: {
                CraftingPlugin.addShapedRecipe(output, "I I", "IsI", "I I", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed);
                break;
            }
            case SPEED_BOOST: {
                CraftingPlugin.addShapedRecipe(output, "IrI", "IsI", "IrI", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed, Character.valueOf('r'), up.aC);
                break;
            }
            case SPEED_TRANSITION: {
                CraftingPlugin.addShapedRecipe(output, "IrI", "IrI", "IsI", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed, Character.valueOf('r'), up.aC);
                CraftingPlugin.addShapedRecipe(output, "IsI", "IrI", "IrI", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed, Character.valueOf('r'), up.aC);
                break;
            }
            case SPEED_SWITCH: {
                CraftingPlugin.addShapedRecipe(output, "IsI", "III", "III", Character.valueOf('I'), railSpeed, Character.valueOf('s'), stoneRailbed);
                break;
            }
            case LAUNCHER: {
                CraftingPlugin.addShapedOreRecipe(output, "IsI", "BPB", "IsI", Character.valueOf('I'), railReinforced, Character.valueOf('B'), "blockSteel", Character.valueOf('s'), stoneRailbed, Character.valueOf('P'), amq.ac);
                break;
            }
            case PRIMING: {
                CraftingPlugin.addShapedRecipe(output, "IpI", "IsI", "IfI", Character.valueOf('I'), railReinforced, Character.valueOf('s'), stoneRailbed, Character.valueOf('p'), amq.aN, Character.valueOf('f'), up.i);
                break;
            }
            case JUNCTION: {
                CraftingPlugin.addShapedRecipe(output, "III", "I#I", "III", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW: {
                CraftingPlugin.addShapedRecipe(output, "I I", "I#I", "I I", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW_BOOSTER: {
                CraftingPlugin.addShapedRecipe(output, "I I", "G#G", "IrI", Character.valueOf('G'), up.p, Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), up.aC);
                break;
            }
            case SLOW_SWITCH: {
                CraftingPlugin.addShapedRecipe(output, "I#I", "III", "III", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW_JUNCTION: {
                CraftingPlugin.addShapedRecipe(output, "III", "I#I", "III", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SWITCH: {
                CraftingPlugin.addShapedRecipe(output, "I#I", "III", "III", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed);
                break;
            }
            case WYE: {
                CraftingPlugin.addShapedRecipe(output, "III", "II#", "III", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed);
                break;
            }
            case SLOW_WYE: {
                CraftingPlugin.addShapedRecipe(output, "III", "II#", "III", Character.valueOf('I'), railWood, Character.valueOf('#'), woodRailbed);
                break;
            }
            case REINFORCED_WYE: {
                CraftingPlugin.addShapedRecipe(output, "III", "II#", "III", Character.valueOf('I'), railReinforced, Character.valueOf('#'), stoneRailbed);
                break;
            }
            case SPEED_WYE: {
                CraftingPlugin.addShapedRecipe(output, "III", "II#", "III", Character.valueOf('I'), railSpeed, Character.valueOf('#'), stoneRailbed);
                break;
            }
            case DISEMBARK: {
                CraftingPlugin.addShapedRecipe(output, "IpI", "I#I", "IrI", Character.valueOf('I'), railAdvanced, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), up.aC, Character.valueOf('p'), amq.aN);
                break;
            }
            case EMBARKING: {
                CraftingPlugin.addShapedRecipe(output, "IpI", "I#I", "IpI", Character.valueOf('I'), railAdvanced, Character.valueOf('#'), woodRailbed, Character.valueOf('p'), up.bn);
                break;
            }
            case SUSPENDED: {
                CraftingPlugin.addShapedRecipe(output, "ItI", "ItI", "ItI", Character.valueOf('I'), railStandard, Character.valueOf('t'), woodTie);
                break;
            }
            case DISPOSAL: {
                CraftingPlugin.addShapedRecipe(output, "ItI", "IPI", "ItI", Character.valueOf('I'), railStandard, Character.valueOf('P'), RailcraftPartItems.getPlateSteel(), Character.valueOf('t'), woodTie);
                break;
            }
            case BUFFER_STOP: {
                CraftingPlugin.addShapedRecipe(output, "I I", "I#I", "IbI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('b'), amq.al);
                break;
            }
            case DETECTOR_DIRECTION: {
                CraftingPlugin.addShapedRecipe(output, "IrI", "I#I", "IsI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('r'), up.aC, Character.valueOf('s'), amq.aN);
                break;
            }
            case GATED: {
                CraftingPlugin.addShapedRecipe(output, "IgI", "I#I", "IgI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('g'), amq.by);
                break;
            }
            case GATED_ONEWAY: {
                CraftingPlugin.addShapedRecipe(output, "IgI", "G#G", "IgI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('g'), amq.by, Character.valueOf('G'), railAdvanced);
                break;
            }
            case COUPLER: {
                CraftingPlugin.addShapedRecipe(output, "I I", "I#I", "IcI", Character.valueOf('I'), railAdvanced, Character.valueOf('#'), woodRailbed, Character.valueOf('c'), crowbar);
                break;
            }
            case DECOUPLER: {
                CraftingPlugin.addShapedRecipe(output, "IcI", "I#I", "I I", Character.valueOf('I'), railAdvanced, Character.valueOf('#'), woodRailbed, Character.valueOf('c'), crowbar);
                break;
            }
            case WHISTLE: {
                CraftingPlugin.addShapedOreRecipe(output, "IyI", "I#I", "IbI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('y'), "dyeYellow", Character.valueOf('b'), "dyeBlack");
                break;
            }
            case LOCOMOTIVE: {
                CraftingPlugin.addShapedRecipe(output, "IlI", "I#I", "IlI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('l'), RailcraftPartItems.getSignalLamp());
                break;
            }
            case LIMITER: {
                CraftingPlugin.addShapedRecipe(output, "IlI", "I#I", "IlI", Character.valueOf('I'), railStandard, Character.valueOf('#'), woodRailbed, Character.valueOf('l'), up.bb);
                break;
            }
            case REINFORCED: {
                CraftingPlugin.addShapedRecipe(output, "I I", "I#I", "I I", Character.valueOf('I'), railReinforced, Character.valueOf('#'), reinforcedRailbed);
                break;
            }
            case REINFORCED_BOOSTER: {
                CraftingPlugin.addShapedRecipe(output, "I I", "I#I", "IrI", Character.valueOf('I'), railReinforced, Character.valueOf('r'), new ur(up.aC), Character.valueOf('#'), reinforcedRailbed);
                break;
            }
            case REINFORCED_JUNCTION: {
                CraftingPlugin.addShapedRecipe(output, "III", "I#I", "III", Character.valueOf('I'), railReinforced, Character.valueOf('#'), reinforcedRailbed);
                break;
            }
            case REINFORCED_SWITCH: {
                CraftingPlugin.addShapedRecipe(output, "I#I", "III", "III", Character.valueOf('I'), railReinforced, Character.valueOf('#'), reinforcedRailbed);
            }
        }
        return output;
    }

    static {
        creativeList = new ArrayList(50);
        TrackRegistry.registerTrackSpec(new TrackSpec(-1, "track.default", "/terrain.png", 128, TrackDefault.class));
        creativeList.add(SWITCH);
        creativeList.add(WYE);
        creativeList.add(JUNCTION);
        creativeList.add(CONTROL);
        creativeList.add(BOARDING);
        creativeList.add(BOARDING_TRAIN);
        creativeList.add(HOLDING);
        creativeList.add(HOLDING_TRAIN);
        creativeList.add(LOCKDOWN);
        creativeList.add(LOCKDOWN_TRAIN);
        creativeList.add(DISEMBARK);
        creativeList.add(EMBARKING);
        creativeList.add(COUPLER);
        creativeList.add(DECOUPLER);
        creativeList.add(WHISTLE);
        creativeList.add(LOCOMOTIVE);
        creativeList.add(LIMITER);
        creativeList.add(BUFFER_STOP);
        creativeList.add(ONEWAY);
        creativeList.add(DETECTOR_DIRECTION);
        creativeList.add(GATED_ONEWAY);
        creativeList.add(GATED);
        creativeList.add(SUSPENDED);
        creativeList.add(DISPOSAL);
        creativeList.add(SLOW);
        creativeList.add(SLOW_BOOSTER);
        creativeList.add(SLOW_JUNCTION);
        creativeList.add(SLOW_SWITCH);
        creativeList.add(SLOW_WYE);
        creativeList.add(REINFORCED);
        creativeList.add(REINFORCED_BOOSTER);
        creativeList.add(REINFORCED_JUNCTION);
        creativeList.add(REINFORCED_SWITCH);
        creativeList.add(REINFORCED_WYE);
        creativeList.add(SPEED);
        creativeList.add(SPEED_BOOST);
        creativeList.add(SPEED_TRANSITION);
        creativeList.add(SPEED_SWITCH);
        creativeList.add(SPEED_WYE);
        creativeList.add(PRIMING);
        creativeList.add(LAUNCHER);
    }
}

