/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackInstance;
import railcraft.common.api.tracks.ITrackTile;
import railcraft.common.api.tracks.TrackRegistry;
import railcraft.common.api.tracks.TrackSpec;
import railcraft.common.blocks.RailcraftTileEntity;
import railcraft.common.core.Railcraft;
import railcraft.common.util.network.IGuiReturnHandler;

public class TileTrack
extends RailcraftTileEntity
implements ITrackTile,
IGuiReturnHandler {
    public ITrackInstance track;

    public TileTrack() {
    }

    public TileTrack(ITrackInstance t) {
        this.track = t;
        this.track.setTile(this);
    }

    @Override
    public String b() {
        return Railcraft.getProxy().getItemDisplayName(this.getTrackInstance().getTrackSpec().getItem());
    }

    @Override
    public void b(bq data) {
        super.b(data);
        data.a("trackId", (int)this.getId());
        this.track.writeToNBT(data);
    }

    @Override
    public void a(bq data) {
        super.a(data);
        TrackSpec spec = TrackRegistry.getTrackSpec(data.e("trackId"));
        this.track = spec.createInstanceFromSpec();
        this.track.setTile(this);
        this.track.readFromNBT(data);
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        if (this.track != null) {
            this.track.writePacketData(data);
        }
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        if (this.track != null) {
            this.track.readPacketData(data);
        }
    }

    public boolean canUpdate() {
        return this.track.canUpdate();
    }

    public void g() {
        this.track.updateEntity();
    }

    @Override
    public short getId() {
        return this.track.getTrackSpec().getTrackId();
    }

    @Override
    public ITrackInstance getTrackInstance() {
        this.track.setTile(this);
        return this.track;
    }

    @Override
    public void writeGuiData(DataOutputStream data) throws IOException {
        if (this.track instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.track)).writeGuiData(data);
        }
    }

    @Override
    public void readGuiData(DataInputStream data) throws IOException {
        if (this.track instanceof IGuiReturnHandler) {
            ((IGuiReturnHandler)((Object)this.track)).readGuiData(data);
        }
    }
}

