/*
 * Decompiled with CFR 0.152.
 */
package railcraft.common.blocks.tracks;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import railcraft.common.api.tracks.ITrackCustomShape;
import railcraft.common.api.tracks.ITrackReversable;
import railcraft.common.blocks.tracks.EnumTrack;
import railcraft.common.blocks.tracks.TrackBaseRailcraft;
import railcraft.common.util.misc.MiscTools;

public class TrackBufferStop
extends TrackBaseRailcraft
implements ITrackReversable,
ITrackCustomShape {
    private static final float CBOX = 0.0625f;
    private static final float SBOX = 0.1875f;
    private static final float SBOXY = 0.3125f;
    private boolean reversed = false;

    @Override
    public EnumTrack getTrackType() {
        return EnumTrack.BUFFER_STOP;
    }

    @Override
    public int getTextureIndex() {
        if (this.reversed) {
            return this.getTrackType().getTextureIndex() + 1;
        }
        return this.getTrackType().getTextureIndex();
    }

    @Override
    public aoe getSelectedBoundingBoxFromPool() {
        return aoe.a().a((double)((float)this.tileEntity.l + 0.1875f), (double)this.tileEntity.m, (double)((float)this.tileEntity.n + 0.1875f), (double)((float)(this.tileEntity.l + 1) - 0.1875f), (double)((float)(this.tileEntity.m + 1) - 0.3125f), (double)((float)(this.tileEntity.n + 1) - 0.1875f));
    }

    @Override
    public aoh collisionRayTrace(aoj vec3d, aoj vec3d1) {
        return MiscTools.collisionRayTrace(vec3d, vec3d1, this.getX(), this.getY(), this.getZ());
    }

    @Override
    public aoe getCollisionBoundingBoxFromPool() {
        return aoe.a().a((double)((float)this.tileEntity.l + 0.0625f), (double)this.tileEntity.m, (double)((float)this.tileEntity.n + 0.0625f), (double)((float)(this.tileEntity.l + 1) - 0.0625f), (double)(this.tileEntity.m + 1), (double)((float)(this.tileEntity.n + 1) - 0.0625f));
    }

    @Override
    public boolean canMakeSlopes() {
        return false;
    }

    @Override
    public boolean isReversed() {
        return this.reversed;
    }

    @Override
    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    @Override
    public void writeToNBT(bq nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.a("direction", this.reversed);
    }

    @Override
    public void readFromNBT(bq nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.reversed = nbttagcompound.n("direction");
    }

    @Override
    public void writePacketData(DataOutputStream data) throws IOException {
        super.writePacketData(data);
        data.writeBoolean(this.reversed);
    }

    @Override
    public void readPacketData(DataInputStream data) throws IOException {
        super.readPacketData(data);
        boolean r = data.readBoolean();
        if (this.reversed != r) {
            this.reversed = r;
            this.markBlockNeedsUpdate();
        }
    }
}

